************************************************************************
**  ^ROUTINE: WMCH - function to return machine constants. (^)
**
      double precision function dmch ( ch , iparm , fparm , iwk , fwk , 
     &   ier )
**
**  ^DESCRIPTION:
**    This routine returns the relevant machine constant as specified
**    by the argument ch.
**    This version relies on routines taken from Lapack.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:09 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
*#    BASICAL             - (^)
      character ch
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer i
      logical first
      save first
      double precision values(10)
      save values
      character*10 names
*
      double precision dlamch
      external dlamch
*
      data first /.true./
      data names /'ESBPNRMULO'/
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:09 1996 $
*     $Id: mch.fm4,v 1.2 1994/04/30 04:39:55 joubert Exp $
*     $Revision: 1.2 $
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (first) then
         do 8511 i = 1, 10
      values(i) = dlamch(names(i:i))
 8511 continue
        first = .false.
      endif
      dmch = values(index(names,ch))
  900 continue
      return
      end
