************************************************************************
**  ^ROUTINE: WJAGR - Preconditioner linking routine,
**                     ja preconditioner, gr format.(^)
**
      subroutine djagr ( ijob , accel , ia , ja , a , u , uexact , b , 
     &   iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine links in the package routines necessary for the ja
**    preconditioner, gr format, and then passes things down to
**    the routine "prec".
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:13 1996 $
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WPREC  - routine to actually call preconditioner generator and itmeth
**       WCKJA  - routine to check correctness of the format
**       WSCJA  - scaling routine
**       WMVJA  - matvec routine
**       WJAJAX - preconditioner routine
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    PRECAL            - preconditioner routine arg list
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      external accel
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       double precision a(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
      external dprec
      external dckgr
      external dscgr
      external dmvgr
      external djagrx
      call dprec ( dckgr, dscgr, dscgr, dmvgr, djagrx, ijob , accel , 
     &   ia , ja , a , u , uexact , b , iwk , fwk , iparm , fparm , ier 
     &   )
      return
      end
******^^****************************************************************
************************************************************************
