************************************************************************
**  ^ROUTINE: WGMRS - gmrs iterative method, direct
**                        communication interface. (^)
**
      subroutine dgmrs ( ijob , suba , ia , ja , a , subq , iq , jq , q 
     &   , u , uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine interfaces the gmrs revcom routine via the wmeth interface
*     routine in order to apply the iterative method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Preconditioned gmrs iterative method
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       double precision a(*)
       double precision q(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
*
      external dmeth
      external dgmrsr
*
      call dmeth ( dgmrsr , ijob , suba , ia , ja , a , subq , iq , jq ,
     &    q , u , uexact , b , iwk , fwk , iparm , fparm , ier )
*
      return
      end
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:17 1996 $
*     $Id: gmrs.fm4,v 1.1 1994/03/26 01:41:38 joubert Exp $
*     $Revision: 1.1 $
************************************************************************
