************************************************************************
**  ^ROUTINE: WCGS2 - cgs2 iterative method, direct
**                        communication interface. (^)
**
      subroutine dcgs2 ( ijob , suba , ia , ja , a , subq , iq , jq , q 
     &   , u , uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine interfaces the cgs2 revcom routine via the wmeth interface
*     routine in order to apply the iterative method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Preconditioned cgs2 iterative method
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       double precision a(*)
       double precision q(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
*
      external dmeth
      external dcgs2r
*
      call dmeth ( dcgs2r , ijob , suba , ia , ja , a , subq , iq , jq ,
     &    q , u , uexact , b , iwk , fwk , iparm , fparm , ier )
*
      return
      end
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:25 1996 $
*     $Id: cgs2.fm4,v 1.1 1994/05/17 18:08:56 joubert Exp $
*     $Revision: 1.1 $
*     $Log: cgs2.fm4,v $
*     Revision 1.1  1994/05/17  18:08:56  joubert
*     added CGSTAB(2) acceleration
*
*
************************************************************************
