************************************************************************
**  ^ROUTINE: WBCGR  - Reverse communication level routine for
**                     biconjugate gradient acceleration. (^)
**
      subroutine dbcgr ( ijob , ireq , u , uexact , b , iva , ivql , 
     &   ivqr , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    Preconditioned biconjugate gradient routine, a.k.a.
**    two-term Lanczos/Orthomin acceleration.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: Modified: wdj@lanl.gov Tue Sep 28 08:27:54 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**   $$\tilde r^{(0)} = Q_L    r^{(0  )} $$
**   $$   Q_L p^{(0)} = Q_L    r^{(0  )} $$
**   $$\tilde p^{(0)} = \tilde r^{(0  )} $$
**   $$   Q_L p^{(n)} = Q_L    r^{(n  )} +
**            \alpha_n  Q_L    p^{(n-1)}, \quad n>0$$
**   $$\tilde p^{(n)} = \tilde r^{(n  )} +
**            \alpha_n^*\tilde p^{(n-1)}, \quad n>0$$
**   $$\alpha_n = {(\tilde r^{(n  )},Q_L r^{(n  )}) \over
**                 (\tilde r^{(n-1)},Q_L r^{(n-1)})}$$
**   $$       u^{(n+1)} =        u^{(n)} +
**                      \lambda_n       Q_R Q_L            p^{(n)} $$
**   $$   Q_L r^{(n+1)} = Q_L    r^{(n)} -
**                      \lambda_n Q_L A Q_R Q_L            p^{(n)} $$
**   $$\tilde r^{(n+1)} = \tilde r^{(n)} -
**                      \lambda_n^* Q_R^* A^* Q_L^* \tilde p^{(n)} $$
**   $$\lambda_n = {(\tilde r^{(n)},Q_L           r^{(n)}) \over
**                  (\tilde p^{(n)},Q_L A Q_R Q_L p^{(n)})}$$
**
**  ^REFERENCES:
**    **    Eigenvalue Problem of Linear Differential and Integral Operators,''
**    J. Res. Nat. Bur. Standards, 45 (1950), pp. 255--282.
**
**    R. Fletcher, Conjugate Gradient Methods for Indefinite
**    Systems,'' Numerical Analysis Dundee 1975, G. A. Watson ed., New
**    York:  Springer, Lecture Notes in Mathematics, no. 506, 1976, pp.
**    73--89.
**
**    Wayne Joubert, ``Lanczos Methods for the Solution of Nonsymmetric
**    Systems of Linear Equations,'' {\sl SIAM Journal on Matrix
**    Analysis and Applications}, vol. 13, no. 3, July 1992, pp.
**    926--943.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer iitab
      integer iftab
      integer iwkstg
      integer iclstg
      integer in
      integer is
      integer iretlb
      integer ivitmp, ivotmp
      integer iv1tst, iv2tst
      integer istab1, istab2, istab
      integer ib1,ib2, iu1,iu2
      integer iud
      parameter (iud =0)
      integer ibd
      parameter (ibd =1)
      integer ilbd
      parameter (ilbd =2)
      integer irlbd
      parameter (irlbd=3)
      integer ied
      parameter (ied =4)
      integer ird
      parameter (ird =5)
      integer ilrd
      parameter (ilrd =6)
      integer irlrd
      parameter (irlrd=7)
      double precision urndf
      double precision top
      double precision bot
      parameter (urndf=.1)
      double precision mydot1, mydot2
      external dargck
      external dckstg
      external dwrnd
      external difppr
      external ditput
      external xtimer
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
*     integer imv1, imv2        ! temporaries - for matvec
      integer ir
      integer iqlr
      integer iqrqlr
      integer irt
      integer iqlp
      integer iqrqlp
      integer ipt
      integer iv1, iv2
      double precision alphan
      double precision rdot
      double precision pap
      double precision rnorm
      double precision r0norm
      double precision rr
      double precision rrold
      double precision vlamda
      double precision uudot, uexdt
*
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:30 1996 $
*     $Id: bcgr.fm4,v 1.28 1994/11/22 05:20:07 joubert Exp $
*     $Revision: 1.28 $
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      irt = (iparm(6))
      iqlp = (iparm(6))
      iqrqlp = (iparm(6))
      ipt = (iparm(6))
      iv1 = (iparm(6))
      iv2 = (iparm(6))
*
*
      if (ijob .ne. 1) go to 1000
*
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
      call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
        call dargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 0) then
        call difppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
      call ximal (iitab,24, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iftab,10, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/''     Biconjugate Gradient Method.''/)')
        endif
      endif
*
      call dfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &     12).eq.6)) then
      call dfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
      else
        ir = iqlr
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call dfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else
        iqrqlr = iqlr
      endif
      call dfmal (irt ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iqlp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call dfmal (iqrqlp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else
        iqrqlp = iqlp
      endif
      call dfmal (ipt ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iv1 ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iv2 ,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(14) .eq. -2 ) then
          call dwfil (u,0d0, iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(14) .eq. 2 .or. iparm(14) .eq. -1) go to 5500
                 go to 5501
 5500  continue
          call dwrdot (mydot1,b, b, iparm , fparm , iwk , fwk , ier )
        call dwrnd (u, iparm , fparm , iwk , fwk , ier )
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2000
      go to 1500
 2000 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwrdot (mydot2,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call dwscl ( u, u, urndf*sqrt(mydot1/mydot2), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5502
 5501 continue
 5502 continue
*
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2001
      go to 1500
 2001 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(iv1), b, fwk(iv1), iparm , fparm , iwk , fwk 
     &       , ier )
          call dwrdot (mydot1,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call dwset (fwk(iv1),u, iparm , fparm , iwk , fwk , ier )
        call dwrnd (u, iparm , fparm , iwk , fwk , ier )
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv2
       ireq = 3
      iretlb = 2002
      go to 1500
 2002 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwrdot (mydot2,fwk(iv2), fwk(iv2), iparm , fparm , iwk , 
     &       fwk , ier )
          call dwsax (u,fwk(iv1), u, -urndf*sqrt(mydot1/mydot2), iparm ,
     &        fparm , iwk , fwk , ier )
                go to 5505
 5504 continue
 5505 continue
*
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
      call dfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call dwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call dwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call dwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5511
 5510 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call dwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2003
      go to 1500
 2003 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5511 continue
          call dwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call dwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call dwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5514
 5513 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2004
      go to 1500
 2004 continue
       if (ijob .eq. -1) go to 900
 5514 continue
          call dwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call dwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call dwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2005
      go to 1500
 2005 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call dwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call dwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5517
 5516 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2006
      go to 1500
 2006 continue
       if (ijob .eq. -1) go to 900
 5517 continue
          call dwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call dwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call dwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5520
 5519 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2007
      go to 1500
 2007 continue
       if (ijob .eq. -1) go to 900
 5520 continue
          call dwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &)') sqrt(fwk(istab+irlrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call dffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5527
                 go to 5528
 5527  continue
          call dwset (fwk(ir),b, iparm , fparm , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          call dwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5532
 5531 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2008
      go to 1500
 2008 continue
       if (ijob .eq. -1) go to 900
 5532 continue
                go to 5529
 5528 continue
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call dwset (fwk(iqlr),b, iparm , fparm , iwk , fwk , ier )
                go to 5535
 5534 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call dwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iqlr
       ireq = 5
      iretlb = 2009
      go to 1500
 2009 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5535 continue
 5529 continue
                go to 5526
 5525 continue
          call dwset (fwk(iqlr),b, iparm , fparm , iwk , fwk , ier )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5539
                 go to 5540
 5539  continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ir
       ireq = 3
      iretlb = 2010
      go to 1500
 2010 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(ir), b, fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call dwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5544
 5543 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2011
      go to 1500
 2011 continue
       if (ijob .eq. -1) go to 900
 5544 continue
                go to 5541
 5540 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2012
      go to 1500
 2012 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(iv1), b, fwk(iv1), iparm , fparm , iwk , fwk 
     &       , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5545
                 go to 5546
 5545  continue
          call dwset (fwk(iqlr),fwk(iv1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5547
 5546 continue
          iva = iv1
          ivql = iqlr
       ireq = 5
      iretlb = 2013
      go to 1500
 2013 continue
       if (ijob .eq. -1) go to 900
 5547 continue
 5541 continue
                go to 5538
 5537 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iqlr
       ireq = 3
      iretlb = 2014
      go to 1500
 2014 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(iqlr), b, fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
 5538 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5548
                 go to 5549
 5548  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5551
                 go to 5552
 5551  continue
          call dwset (fwk(iqrqlr),fwk(iqlr), iparm , fparm , iwk , fwk ,
     &        ier )
                go to 5553
 5552 continue
          ivql = iqlr
          ivqr = iqrqlr
       ireq = 7
      iretlb = 2015
      go to 1500
 2015 continue
       if (ijob .eq. -1) go to 900
 5553 continue
                go to 5550
 5549 continue
 5550 continue
*
          call dwrdot (rdot,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
      rnorm = sqrt(abs(rdot))
      r0norm = rnorm
*
*---------------------------iteration loop------------------------------
*
  100 continue
*
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'QL r norm           ', rnorm
        endif
        endif
*
        if (iparm(12).eq.-3) go to 5554
                 go to 5555
 5554  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr
          endif
          ireq = 9
      iretlb = 2016
      go to 1500
 2016 continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call ditput ( in , is , iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a/)') ' User-requested termination of itera
     &tive method.'
        endif
            endif
            go to 900
          endif
                go to 5556
 5555 continue
 5556 continue
        if (iparm(12) .gt. 1) go to 5557
                 go to 5558
 5557  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'dbcgr' , iparm , '19 and 12 incompat
     &ible' )
                go to 900
              endif
          call dwdot (bot, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
              top = bot
            else
      call dfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call dwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call dwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call dffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call dwdot (bot, b, b, iparm , fparm , iwk , fwk , ier )
              top = bot
            else
          call dwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            endif
          endif
          if (iparm(12) .eq. 3) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call dwdot (bot, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5568
 5567 continue
      call dfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call dwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5571
 5570 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call dwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2017
      go to 1500
 2017 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5571 continue
          call dwdot (bot, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call dffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
              top = bot
                go to 5565
 5564 continue
          call dwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
 5565 continue
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 4) go to 5572
                 go to 5573
 5572  continue
            if (iparm(5) .eq. 0) go to 5575
                 go to 5576
 5575  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5578
                 go to 5579
 5578  continue
          call dwdot (bot, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5580
 5579 continue
      call dfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
          call dwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5583
 5582 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call dwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2018
      go to 1500
 2018 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5583 continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call dwset (fwk(iv2tst),fwk(iv1tst), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5586
 5585 continue
          ivql = iv1tst
          ivqr = iv2tst
       ireq = 7
      iretlb = 2019
      go to 1500
 2019 continue
       if (ijob .eq. -1) go to 900
 5586 continue
          call dwdot (bot, fwk(iv2tst), fwk(iv2tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call dffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5580 continue
              top = bot
                go to 5577
 5576 continue
          call dwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
 5577 continue
                go to 5574
 5573 continue
 5574 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'dbcgr' , iparm , '19 and 12 incompat
     &ible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call dwdot (top, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
            else
      call dfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call dwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call dwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call dffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call dwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call dwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call dwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if ((top) .lt. (0d0)) then
                ier = -10
                call xersho ( ier, 'dbcgr' , iparm , 'Attempt to take sq
     &rt of negative number' )
                go to 900
          endif
          if ((bot) .le. (0d0)) then
                ier = -10
                call xersho ( ier, 'dbcgr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = sqrt((top)/(bot))
          call ditput ( in , is , iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
                go to 5559
 5558 continue
 5559 continue
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. 0d0) then
                ier = -10
                call xersho ( ier, 'dbcgr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call ditput ( in , is , iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
        endif
*
        if (iparm(12) .eq. -2) then
          call dwsub ( fwk(iv1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call dwrdot (uudot,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call dwrdot (uexdt,uexact, uexact, iparm , fparm , iwk , fwk ,
     &        ier )
          if ((uudot) .lt. (0d0)) then
                ier = -10
                call xersho ( ier, 'dbcgr' , iparm , 'Attempt to take sq
     &rt of negative number' )
                go to 900
          endif
          if ((uexdt) .le. (0d0)) then
                ier = -10
                call xersho ( ier, 'dbcgr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = sqrt((uudot)/(uexdt))
          call ditput ( in , is , iparm , fparm , iwk , fwk , ier )
          if ((fparm(5)) .le. (fparm(4))) go to 2500
        endif
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'dbcgr' , iparm , ' ' )
          go to 900
        endif
*
        call dckstg ( iclstg, iwkstg, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*-----------------------proceed with iteration--------------------------
*
        if (in .eq. 0) go to 5587
                 go to 5588
 5587  continue
          call dwset (fwk(irt),fwk(iqlr), iparm , fparm , iwk , fwk , 
     &       ier )
          if (iparm(20) .eq. 1) then
            rr = rdot
          else
          call dwcdot (rr, fwk(irt), fwk(iqlr), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
          endif
          call dwset (fwk(iqlp),fwk(iqlr), iparm , fparm , iwk , fwk , 
     &       ier )
          call dwset (fwk(ipt),fwk(irt), iparm , fparm , iwk , fwk , 
     &       ier )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call dwset (fwk(iqrqlp),fwk(iqrqlr), iparm , fparm , iwk , 
     &       fwk , ier )
          endif
                go to 5589
 5588 continue
          go to (501,502,503,504), iparm(13)+1
  501     continue
          iva = ipt
          ivqr = iv1
       ireq = 4
      iretlb = 2020
      go to 1500
 2020 continue
       if (ijob .eq. -1) go to 900
          go to 510
  502     continue
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5590
                 go to 5591
 5590  continue
          call dwset (fwk(iv2),fwk(ipt), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5592
 5591 continue
          ivql = ipt
          iva = iv2
       ireq = 6
      iretlb = 2021
      go to 1500
 2021 continue
       if (ijob .eq. -1) go to 900
 5592 continue
          iva = iv2
          ivqr = iv1
       ireq = 4
      iretlb = 2022
      go to 1500
 2022 continue
       if (ijob .eq. -1) go to 900
          go to 510
  503     continue
          iva = ipt
          ivqr = iv2
       ireq = 4
      iretlb = 2023
      go to 1500
 2023 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
          call dwset (fwk(iv1),fwk(iv2), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5595
 5594 continue
          ivqr = iv2
          ivql = iv1
       ireq = 8
      iretlb = 2024
      go to 1500
 2024 continue
       if (ijob .eq. -1) go to 900
 5595 continue
          go to 510
  504     continue
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5596
                 go to 5597
 5596  continue
          call dwset (fwk(iv1),fwk(ipt), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5598
 5597 continue
          ivql = ipt
          iva = iv1
       ireq = 6
      iretlb = 2025
      go to 1500
 2025 continue
       if (ijob .eq. -1) go to 900
 5598 continue
          iva = iv1
          ivqr = iv2
       ireq = 4
      iretlb = 2026
      go to 1500
 2026 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5599
                 go to 5600
 5599  continue
          call dwset (fwk(iv1),fwk(iv2), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5601
 5600 continue
          ivqr = iv2
          ivql = iv1
       ireq = 8
      iretlb = 2027
      go to 1500
 2027 continue
       if (ijob .eq. -1) go to 900
 5601 continue
  510     continue
          call dwsax (fwk(irt),fwk(irt), fwk(iv1), (-vlamda), iparm , 
     &       fparm , iwk , fwk , ier )
          rrold = rr
          if (abs(rrold) .eq. (0d0)) then
                ier = -7
                call xersho ( ier, 'dbcgr' , iparm , ' ' )
                go to 900
          endif
          call dwcdot (rr, fwk(irt), fwk(iqlr), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
          alphan = rr / rrold
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'alpha               ', alphan
        endif
          endif
          call dwsax (fwk(iqlp),fwk(iqlr), fwk(iqlp), alphan, iparm , 
     &       fparm , iwk , fwk , ier )
          call dwsax (fwk(ipt),fwk(irt), fwk(ipt), (alphan), iparm , 
     &       fparm , iwk , fwk , ier )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call dwsax (fwk(iqrqlp),fwk(iqrqlr), fwk(iqrqlp), alphan, 
     &       iparm , fparm , iwk , fwk , ier )
          endif
 5589 continue
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) '(rtilde,r)          ', rr
        endif
        endif
*
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
          ivqr = iqrqlp
          iva = iv2
       ireq = 3
      iretlb = 2028
      go to 1500
 2028 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5605
                 go to 5606
 5605  continue
          call dwset (fwk(iv1),fwk(iv2), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5607
 5606 continue
          iva = iv2
          ivql = iv1
       ireq = 5
      iretlb = 2029
      go to 1500
 2029 continue
       if (ijob .eq. -1) go to 900
 5607 continue
                go to 5604
 5603 continue
          ivqr = iqrqlp
          iva = iv1
       ireq = 3
      iretlb = 2030
      go to 1500
 2030 continue
       if (ijob .eq. -1) go to 900
 5604 continue
*
          call dwcdot (pap, fwk(ipt), fwk(iv1), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) '(p,ap)              ', pap
        endif
        endif
        if (pap .eq. 0d0) then
                ier = -6
                call xersho ( ier, 'dbcgr' , iparm , ' ' )
                go to 900
        endif
        vlamda = rr / pap
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'lambda              ', vlamda
        endif
        endif
*
          call dwsax (u,u, fwk(iqrqlp), vlamda, iparm , fparm , iwk , 
     &       fwk , ier )
          call dwsax (fwk(iqlr),fwk(iqlr), fwk(iv1), (-vlamda), iparm , 
     &       fparm , iwk , fwk , ier )
        if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &     /2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
          call dwsax (fwk(ir),fwk(ir), fwk(iv2), (-vlamda), iparm , 
     &       fparm , iwk , fwk , ier )
        endif
        if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5611
                 go to 5612
 5611  continue
          call dwset (fwk(iv2),fwk(iv1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5613
 5612 continue
          ivql = iv1
          ivqr = iv2
       ireq = 7
      iretlb = 2031
      go to 1500
 2031 continue
       if (ijob .eq. -1) go to 900
 5613 continue
          call dwsax (fwk(iqrqlr),fwk(iqrqlr), fwk(iv2), (-vlamda), 
     &       iparm , fparm , iwk , fwk , ier )
                go to 5610
 5609 continue
 5610 continue
*
          call dwrdot (rdot,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
        rnorm = sqrt(abs(rdot))
*
        in = in + 1
        iparm(5) = in
        is = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a,i7,a/)') '     Biconjugate Gradient Metho
     &d has converged in ', iparm(5), ' iterations.'
        endif
      endif
*
*-------------------------------terminate-------------------------------
*
  900 continue
*
      if (iclstg .ne. 1) then
        call dckstg (-1, iwkstg, iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5614
                 go to 5615
 5614  continue
      call dfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call dfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
      call dfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call dfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call dwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call dwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5617
                 go to 5618
 5617  continue
          call dwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5619
 5618 continue
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call dwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2032
      go to 1500
 2032 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
 5619 continue
          call dwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call dwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5620
                 go to 5621
 5620  continue
          call dwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5622
 5621 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2033
      go to 1500
 2033 continue
       if (ijob .eq. -1) go to 900
 5622 continue
          call dwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call dwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call dwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call dfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call dwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2034
      go to 1500
 2034 continue
      call dffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
          call dwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call dwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5623
                 go to 5624
 5623  continue
          call dwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5625
 5624 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2035
      go to 1500
 2035 continue
       if (ijob .eq. -1) go to 900
 5625 continue
          call dwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call dwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5626
                 go to 5627
 5626  continue
          call dwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5628
 5627 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2036
      go to 1500
 2036 continue
       if (ijob .eq. -1) go to 900
 5628 continue
          call dwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. 0d0) then
                ier = 4
                call xersho ( ier, 'dbcgr' , iparm , 'Value of RELERR ma
     &y be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. 0d0) then
                ier = 4
                call xersho ( ier, 'dbcgr' , iparm , 'Value of RELRSD ma
     &y be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &)') sqrt(fwk(istab+irlrd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10
     &)') fparm(8)
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10
     &)') fparm(7)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call dffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (istab2,8, iparm , fparm , iwk , fwk , ier )
      call dffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5616
 5615 continue
 5616 continue
*
      call dffre (iv2 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (iv1 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (ipt ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call dffre (iqrqlp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      call dffre (iqlp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call dffre (irt ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call dffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12)
     &   .eq.6) .and. ((iparm(13).eq.1).or.(iparm(13).eq.3))) then
      call dffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      call dffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call dffre (iftab,10, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,24, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
  910 continue
      if (iparm(27) .eq. 0) then
        call difppr ( -1 , iparm, fparm, ier )
      endif
*
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'dbcgr' , iparm , 'Values of ijob and
     & iparm(iptr) incompatible' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
        iitab = iwk(iitab+0)
        iftab = iwk(iitab+1)
        istab = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in = iwk(iitab+5)
        is = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ir = iwk(iitab+15)
        iqlr = iwk(iitab+16)
        iqrqlr = iwk(iitab+17)
        irt = iwk(iitab+18)
        iqlp = iwk(iitab+19)
        iqrqlp = iwk(iitab+20)
        ipt = iwk(iitab+21)
        iv1 = iwk(iitab+22)
        iv2 = iwk(iitab+23)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        alphan = fwk(iftab+2)
        rdot = fwk(iftab+3)
        pap = fwk(iftab+4)
        rnorm = fwk(iftab+5)
        r0norm = fwk(iftab+6)
        rr = fwk(iftab+7)
        rrold = fwk(iftab+8)
        vlamda = fwk(iftab+9)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'dbcgr' , iparm , 'Argument ijob inva
     &lid' )
      endif
*
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,
     &   2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,
     &   2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,
     &   2035,2036), iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
        iwk(iitab+0) = iitab
        iwk(iitab+1) = iftab
        iwk(iitab+2) = istab
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in
        iwk(iitab+6) = is
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ir
        iwk(iitab+16) = iqlr
        iwk(iitab+17) = iqrqlr
        iwk(iitab+18) = irt
        iwk(iitab+19) = iqlp
        iwk(iitab+20) = iqrqlp
        iwk(iitab+21) = ipt
        iwk(iitab+22) = iv1
        iwk(iitab+23) = iv2
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = alphan
        fwk(iftab+3) = rdot
        fwk(iftab+4) = pap
        fwk(iftab+5) = rnorm
        fwk(iftab+6) = r0norm
        fwk(iftab+7) = rr
        fwk(iftab+8) = rrold
        fwk(iftab+9) = vlamda
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10 )
*
      end
