************************************************************************
**  ^ROUTINE: WARGCK - Routine to check the validity of iparm and
**                     fparm entries on entry to the package. (^)
**
      subroutine dargck ( iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    Routine to check the validity of iparm and fparm entries on
**    entry to the package.  Warnings or errors are given if necessary.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:32 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**    This program makes heavy use of the definitions in defs_ifparm.m4
**
**  ^SIDE_EFFECTS:
**    The i/fparm variables associated with the timers are initialized.
**    The ier error code is set if necessary.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
*#    BASICAL    - (^)
*
      integer icallr
      double precision relpr
*
      double precision dmch
      external dmch
      external xerstr
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:32 1996 $
*     $Id: argck.fm4,v 1.15 1994/09/06 17:34:33 joubert Exp $
*     $Revision: 1.15 $
*******************************************************************************
*
*
      icallr = iparm(27)
*
        if (.not.(iparm(2).ge.0 .and. iparm(2).le.5)) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'lev
     &out' )
                go to 900
        endif
        if (.not.(iparm(3) .ge.0 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'nru
     &   ' )
                go to 900
        endif
        if (.not.(iparm(4).ge.0 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'its
     &max' )
                go to 900
        endif
        if (.not.(iparm(6).ge.0 .and. iparm(6).le.1)) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'mal
     &loc' )
                go to 900
        endif
        if (.not.(iparm(7).ge.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'nwi
     &   ' )
                go to 900
        endif
        if (.not.(iparm(8).ge.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'nwf
     &   ' )
                go to 900
        endif
        if (.not.(iparm(12) .ge.-3 .and. iparm(12) .le.8 .and..not. (
     &     iparm(12) .eq.-3 .and. iparm(27) .ne.0).and..not. (iparm(12) 
     &     .eq.-2 .and. iparm(19).ne.1))) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'nte
     &st ' )
                go to 900
        endif
        if (.not.(iparm(13).ge.0 .and. iparm(13).le.3 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'iqs
     &ide' )
                go to 900
        endif
        if (.not.(iparm(14).ge.-2 .and. iparm(14).le.3 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'iui
     &nit' )
                go to 900
        endif
        if (.not.(iparm(15).ge.0 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'nee
     &drc' )
                go to 900
        endif
        if (.not.(iparm(16).ge.0 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ns1
     &   ' )
                go to 900
        endif
        if (.not.(iparm(17).ge.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ns2
     &   ' )
                go to 900
        endif
        if (.not.(iparm(18).ge.-1 .and. iparm(18).le.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ick
     &stg' )
                go to 900
        endif
        if (.not.(iparm(19).ge.0 .and. iparm(19).le.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'iue
     &xac' )
                go to 900
        endif
        if (.not.(iparm(20).ge.0 .and. iparm(20).le.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ido
     &t  ' )
                go to 900
        endif
        if (.not.(iparm(21).ge.0 .and. iparm(21).le.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ist
     &ats' )
                go to 900
        endif
        if (.not.(iparm(24).ge.0)) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'msg
     &min' )
                go to 900
        endif
        if (.not.(iparm(25).le.(1999999999-2**30+1))) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'msg
     &max' )
                go to 900
        endif
        if (.not.(iparm(26).ge.iparm(24) .and. iparm(26).le.iparm(25) ))
     &      then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'msg
     &typ' )
                go to 900
        endif
        if (.not.(iparm(27).ge.0 .and. iparm(27).le.2 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'icl
     &ev ' )
                go to 900
        endif
      if (icallr .le. 0) go to 900
*
      relpr = dmch('E', iparm , fparm , iwk , fwk , ier )
      if (ier .lt. 0) go to 900
      if ((fparm(4)) .lt. (relpr)) then
                ier = 3
                call xersho ( ier, 'dargck' , iparm , ' ' )
      endif
      if (icallr .le. 1) go to 900
*
        if (.not.(iparm(41).ge.0 .and. iparm(41).le.3 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'isc
     &ale' )
                go to 900
        endif
        if (.not.(iparm(42).ge.0 .and. iparm(42).le.1 )) then
                ier = -5
                call xersho ( ier, 'dargck' , iparm , 'Parameter '//'ict
     &ran' )
                go to 900
        endif
      if (icallr .le. 2) go to 900
*
  900 continue
*
      return
      end
