************************************************************************
**  ^ROUTINE: WWSCL - Routine to scale a vector by a constant (^)
**
      subroutine cwscl ( z , y , c , iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    Simply scales the vector y by the constatn c and puts the result in z
**    (z = c y).  This routine is part of the Low-level level-1 BLAS-type
**    routine required by pcg package.  Written for Sun, Cray YMP, Ncube,
*#    iPSC 860, or generic f77; as set by m4 variable MACHINE.
**
**    On a Cray YMP the vector is partitioned out to all available processors.
**    The partitioning is done using compiler directives, thus the complier
**    decides how the partitioning is done.
**
**  ^AUTHOR:  wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:33 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
       complex z(*)
       complex y(*)
      complex c
      integer nv
      integer i
      external cwfil
          external ccopy
          external cscal
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:33 1996 $
*     $Id: wscl.fm4,v 1.7 1994/02/04 03:00:08 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
      if (c .eq. (0e0,0.0e0)) then
        call cwfil ( z , (0e0,0.0e0) , iparm , fparm , iwk , fwk , ier )
        return
      endif
      nv = iparm(3)
          call ccopy (nv,y,1,z,1)
          call cscal (nv,c,z,1)
      fparm(3) = fparm(3) + (6.*nv)
      return
      end
