************************************************************************
**  ^ROUTINE: WWRND - Routine to fill a vector with uniformly distributed
**                    random numbers between -1 and 1.
**                   (^)
**
      subroutine cwrnd ( vo , iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    The elements of the vector vo are set equal to random numbers.
**
**  ^AUTHOR:  wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:34 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**    Simply the setting of the elements of vo to the value of the scalar c.
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
*
       complex vo(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer nv
      integer i
      integer iseed
*
      external crndv
      complex crndv
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:34 1996 $
*     $Id: wrnd.fm4,v 1.3 1994/06/24 18:19:57 joubert Exp $
*     $Revision: 1.3 $
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      nv = iparm(3)
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
         iseed = 1 + ipme
*
       do 8511 i = 1, nv
      vo(i) = crndv (iseed)
 8511 continue
*
      return
      end
*------------------------------------------------------------------------------
      complex function crndv (i)
*
* simple random number generator
*
      integer i
         integer iold
      integer n1, n2
      parameter (n1=16807,n2=57853)
*
         i = mod(n1*i,n2)
         iold = i
         i = mod(n1*i,n2)
         crndv = cmplx(2.*(real((1e0,0.0e0))*iold)/n2-1., 2.*(real((1e0,
     &      0.0e0))*i )/n2-1.)
*
      return
      end
*------------------------------------------------------------------------------
