************************************************************************
**  ^ROUTINE: WMFREE - This returns memory and places it in void list. (^)
**
**
      subroutine cmfree (fwk,aloc,ier)
**  ^DESCRIPTION:
**       This routine puts memory back on free list.  It attempts to join
**     voids if they are next to it.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Tue Jul 20 12:38:55 1993
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Fri Oct 22 15:43:35 1993 $
**
**  ^REQUIREMENTS:
**       must have been allocated from this array.
**
**  ^SIDE_EFFECTS:
**       changes void list
**
**  ^ALGORITHM:
**
**  ^MACROS_USED:
*#    ASSERT - (^)
*#    ERRMEM - (^)
*#    FETCH - (^)
*#    FTYPE - (^)
*#    HANDLE_ERROR - (^)
*#    IGETVSIZ - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    SAVE - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
*#    WMEMCK - (^)
*#    WMFREE - (^)
*#    WNAME - (^)
**
****^^******************************************************************
*
      implicit none
*
       complex fwk(*)
      integer aloc
      integer ier
*
      integer forwrd,bckwrd
      integer go
      integer itmp
      integer left,right
      integer loc
      integer nvoids
      integer rover
      integer size
      integer vdsize
      logical rtn
*
         integer memtmp
         integer mtmp2
      integer fused
      integer iequiv
      complex requiv
      equivalence (iequiv,requiv)
*
      logical cmemck
      external cmemck
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Fri Oct 22 15:43:35 1993 $
*     $Id: mfree.fm4,v 1.7 1994/04/30 04:40:00 joubert Exp $
*     $Revision: 1.7 $
*     $Log: mfree.fm4,v $
*     Revision 1.7  1994/04/30  04:40:00  joubert
*     improved error handling
*
*     Revision 1.6  1994/04/22  03:30:45  joubert
*     fixed bug in c memory allocator
*
*     Revision 1.5  1994/04/21  04:18:46  joubert
*     debugged YMP version
*
*     Revision 1.2  1994/01/20  21:52:03  mclay
*     added aloc = -1
*
*     Revision 1.1  1993/09/28  16:26:26  joubert
*     Implemented IPARM variable 15
*
*     Revision 1.2  1993/09/14  02:24:03  mclay
*     Corrected memory allocations routines.
*
*     Revision 1.1  1993/08/24  16:07:59  mclay
*     New 0 malloc routines.
*
************************************************************************
*
*
      requiv=fwk(4)
      itmp=iequiv
      if (itmp .ne. 4) then
        aloc = -1
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: array not initialized'])
      endif
*
      requiv=fwk(3)
      rover =iequiv
      requiv=fwk(5)
      nvoids =iequiv
*
      loc = aloc - 1
      requiv=fwk(loc)
      itmp=iequiv
      size = abs(itmp)
      requiv=fwk(loc+size-1)
      itmp=iequiv
      if (-size .ne. itmp) then
        aloc = -1
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Boundary words do not match'])
      endif
*
*
      if (nvoids .eq. 0) then
        nvoids = 1
        rover = loc
        iequiv=size
        fwk(rover) =requiv
        iequiv=rover
        fwk(rover+1) =requiv
        iequiv=rover
        fwk(rover+2) =requiv
        fwk(rover + size - 1) = fwk(rover)
      else
*
        go = rover
*
        requiv=fwk(loc-1)
        itmp=iequiv
        if (itmp .gt. 0) then
*
          requiv=fwk(loc-1)
          vdsize =iequiv
          left = loc - vdsize
          vdsize = vdsize + size
          iequiv=vdsize
          fwk(left) =requiv
          fwk(left+vdsize-1) = fwk(left)
*
          rover = left
        else
          if (loc .gt. rover) then
 8511       continue
              requiv=fwk(rover+2)
              bckwrd =iequiv
              requiv=fwk(rover+1)
              forwrd =iequiv
              if ((bckwrd .lt. loc .or. forwrd .eq. go) .and. (loc .lt. 
     &           rover)) go to 8513
              requiv=fwk(rover+1)
              rover =iequiv
            if (.not. (rover .eq. go)) go to 8511
 8513       continue
          endif
*
          requiv=fwk(rover+2)
          left =iequiv
*
          iequiv=loc
          fwk(left+1) =requiv
          iequiv=loc
          fwk(rover+2) =requiv
*
          iequiv=size
          fwk(loc) =requiv
          iequiv=rover
          fwk(loc+1) =requiv
          iequiv=left
          fwk(loc+2) =requiv
          fwk(loc+size-1) = fwk(loc)
          nvoids = nvoids + 1
          rover = loc
          vdsize = size
        endif
*
        right = rover + vdsize
        requiv=fwk(right)
        itmp=iequiv
        if (itmp .gt. 0) then
          requiv=fwk(right)
          itmp=iequiv
          vdsize = itmp + vdsize
          iequiv=vdsize
          fwk(rover) =requiv
          fwk(rover+vdsize-1) = fwk(rover)
*
          requiv=fwk(right+1)
          forwrd =iequiv
          requiv=fwk(right+2)
          bckwrd =iequiv
          iequiv=bckwrd
          fwk(forwrd+2) =requiv
          iequiv=forwrd
          fwk(bckwrd+1) =requiv
          nvoids = nvoids - 1
        endif
      endif
*
      iequiv=min(go,loc)
      fwk(3) =requiv
      iequiv=nvoids
      fwk(5) =requiv
*
      requiv=fwk(6)
      itmp=iequiv
      itmp = itmp - 1
      iequiv=itmp
      fwk(6)=requiv
      rtn = cmemck (fwk)
      if (.not.rtn) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Re-initializing memory'])
      endif
*
  900 continue
      return
      end
