************************************************************************
**  ^ROUTINE: cmemck - This routine checks the status of the array
**                     allocation. (^)
**
**
      logical function cmemck (fwk)
**  ^DESCRIPTION: This routine checks the status of the array by walking
**      down the array, checking to see if it is consistent.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Tue Jul 20 16:05:33 1993
**
**  ^MODIFIED: mclay@vato.ae.utexas.edu on Tue Sep  7 13:40:20 1993 $
**
**  ^REQUIREMENTS:  The array must be initialized first.
**
**
**  ^SIDE_EFFECTS: None
**
**  ^MACROS_USED:
*#    ERRMEM - (^)
*#    FETCH - (^)
*#    FTYPE - (^)
*#    HANDLE_ERROR - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    ISTART - (^)
*#    NSIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    SAVE - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
*#    WMEMCK - (^)
*#    WNAME - (^)
**
****^^******************************************************************
*
      implicit none
*
      complex fwk(*)
*
      integer bottom
      integer forwrd,bckwrd
      integer go
      integer ier, iparm
      integer itmp
      integer ivoid
      integer maxsiz
      integer nuser
      integer nvoids
      integer size
      integer vdsize
      integer rover
      integer marker
      integer ifval1, ifval2
*
         integer memtmp
         integer mtmp2
      integer fused
      integer imem
*     external imem
      integer cmem
*     external cmem
      integer iequiv
      complex requiv
      equivalence (iequiv,requiv)
*
      save marker
*
      data marker/122/
*
****^^******************************************************************
*     $Modified: mclay@vato.ae.utexas.edu on Tue Sep  7 13:40:20 1993 $
*     $Id: memck.fm4,v 1.7 1994/06/24 18:20:04 joubert Exp $
*     $Revision: 1.7 $
*     $Log: memck.fm4,v $
*     Revision 1.7  1994/06/24  18:20:04  joubert
*     t3d version mods; installed iom it meth
*
*     Revision 1.6  1994/04/30  04:39:58  joubert
*     improved error handling
*
*     Revision 1.5  1994/04/22  03:30:43  joubert
*     fixed bug in c memory allocator
*
*     Revision 1.4  1994/04/21  04:18:44  joubert
*     debugged YMP version
*
*     Revision 1.1  1993/09/28  16:26:24  joubert
*     Implemented IPARM variable 15
*
*     Revision 1.2  1993/09/14  02:24:01  mclay
*     Corrected memory allocations routines.
*
*     Revision 1.1  1993/08/24  16:07:58  mclay
*     New 0 malloc routines.
*
************************************************************************
*
      cmemck = .TRUE.
*
      requiv=fwk(4)
      itmp=iequiv
      if (itmp .ne. 4) then
        cmemck = .FALSE.
        return
**$
                ier = -14
                call xersho ( ier, 'cmemck' , iparm , 'error array not i
     &nitialized' )
                go to 900
      endif
*
      requiv=fwk(3)
      rover =iequiv
      requiv=fwk(5)
      nvoids =iequiv
*
      marker = marker + 1
*
      if (nvoids .gt. 0) then
*
        go = rover
        bottom = go
        do 8511 ivoid = 1,nvoids
*
          requiv=fwk(rover)
          vdsize =iequiv
*
          requiv=fwk(rover+vdsize-1)
          ifval2=iequiv
          if (vdsize .ne. ifval2) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['Void Boundaries do not match'])
          endif
*
          iequiv=marker
          fwk(rover+3) =requiv
*
          requiv=fwk(rover+2)
          bckwrd =iequiv
          requiv=fwk(bckwrd+1)
          forwrd =iequiv
          if (forwrd .ne. rover) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['Void linkage Bad'])
          endif
*
          requiv=fwk(rover+1)
          forwrd =iequiv
          requiv=fwk(forwrd+2)
          bckwrd =iequiv
          if (bckwrd .ne. rover) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['Void linkage Bad'])
          endif
*
          bottom = min(bottom,rover)
*
          if (rover .gt. forwrd .and. forwrd .ne. go) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['void link list out of order'])
          endif
*
          requiv=fwk(rover+1)
          rover =iequiv
 8511   continue
      endif
*
      if (go .ne. rover) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,['go does not equal rover'])
      endif
*
      if (go .ne. bottom) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,['go does not equal bottom of link list'])
      endif
*
      rover = 9
      requiv=fwk(7)
      maxsiz =iequiv
      requiv=fwk(9-1)
      itmp=iequiv
      if (itmp .ne. -1) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,[' fwk(ISTART) does not equal -1'])
      endif
      requiv=fwk(maxsiz)
      itmp=iequiv
      if (itmp .ne. -1) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,[' fwk(maxsiz) does not equal -1'])
      endif
*
      nvoids = 0
      nuser = 0
 8513 if (rover .lt. maxsiz) then
        requiv=fwk(rover)
        size =iequiv
        if (abs(size) .lt. 3) then
          cmemck = .FALSE.
          return
**#       HANDLE_ERROR(ERRMEM,['size too small: size less than 3 '])
        endif
        if (size .lt. 0) then
*
          size = abs(size)
          nuser = nuser + 1
*
          requiv=fwk(rover+size-1)
          itmp=iequiv
          if (-size .ne. itmp) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['User Boundaries do not match'])
          endif
*
          rover = rover + size
        else
*
          nvoids = nvoids + 1
          vdsize = size
*
          requiv=fwk(rover+vdsize-1)
          itmp=iequiv
          if (vdsize .ne. itmp) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['Void Boundaries do not match'])
          endif
*
          requiv=fwk(rover+3)
          itmp=iequiv
          if (itmp .ne. marker) then
            cmemck = .FALSE.
            return
**#         HANDLE_ERROR(ERRMEM,['Did not mark this void'])
          endif
*
          rover = rover + size
        endif
      go to 8513 
      endif
*
      if (rover .ne. maxsiz) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,['rover does not equal maxsiz'])
      endif
*
      requiv=fwk(6)
      itmp=iequiv
      if (nuser .ne. itmp) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,['nuser does not equal fwk(NUSERBLKS)'])
      endif
*
      requiv=fwk(5)
      itmp=iequiv
      if (nvoids .ne. itmp) then
        cmemck = .FALSE.
        return
**#     HANDLE_ERROR(ERRMEM,['nvoids does not equal fwk(NVOIDS)'])
      endif
*
  900 continue
      return
*
 1000 format(1x,'void boundaries do not match:',/ ,'rover',i10,/ ,'vdsiz
     &e',i10,/ ,'fwk(rover+vdsize-1)',i10)
 1010 format(1x,'void linkage bad: ',/ ,'rover',i10,/ ,'fwk(rover+2)',
     &   i10,/ ,'fwk(fwk(rover+2)+1)',i10)
 1020 format(1x,'void linkage bad: ',/ ,'rover',i10,/ ,'fwk(rover+1)',
     &   i10,/ ,'fwk(fwk(rover+1)+2)',i10)
 1030 format(1x,'user boundaries do not match:',/ ,'rover',i10,/ ,'size'
     &   ,i10,/ ,'fwk(rover)',i10,/ ,'fwk(rover+size-1)',i10)
*
      end
