************************************************************************
**  ^ROUTINE: cmem - allocate a block of space from a floating user array.
**
      integer function cmem (fwk,usrsiz)
**  ^DESCRIPTION:
**       This routine allocates space from a floating user array.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Mon Jul 19 21:50:38 1993
**
**  ^MODIFIED: mclay@vato.ae.utexas.edu on Tue Sep  7 13:58:07 1993 $
**
**  ^REQUIREMENTS:  the array fwk must be initialized by fminit routine.
**
**  ^ALGORITHM:      This is a next fit allocation scheme.  See Knuth vol 1.
**
**  ^MACROS_USED:
*#    ERRMEM - (^)
*#    FETCH - (^)
*#    FTYPE - (^)
*#    HANDLE_ERROR - (^)
*#    IGETVSIZ - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    SAVE - (^)
*#    SLOP - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
*#    WMEM - (^)
*#    WMEMCK - (^)
*#    WNAME - (^)
**
****^^******************************************************************
*
      implicit none
*
       complex fwk(*)
      integer usrsiz
*
      integer aloc
      integer forwrd,bckwrd
      integer go
      integer itmp
      integer nvoids
      integer rover
      integer usize
      integer vdsize
      integer vdstrt
      logical found
*
      integer iequiv
      complex requiv
      equivalence (iequiv,requiv)
*
      logical cmemck
      external cmemck
*
****^^******************************************************************
*     $Modified: mclay@vato.ae.utexas.edu on Tue Sep  7 13:58:07 1993 $
*     $Id: mem.fm4,v 1.7 1994/04/30 04:39:56 joubert Exp $
*     $Revision: 1.7 $
*     $Log: mem.fm4,v $
*     Revision 1.7  1994/04/30  04:39:56  joubert
*     improved error handling
*
*     Revision 1.6  1994/04/29  23:53:15  joubert
*     added tfqmr method
*
*     Revision 1.5  1994/04/21  01:37:23  joubert
*     cleaned up memory management macros
*
*     Revision 1.4  1994/02/18  08:49:33  joubert
*     mpi, t3dpvm versions completed; misc other changes
*
*     Revision 1.3  1994/02/04  03:00:48  joubert
*
*     Revision 1.2  1994/01/28  23:04:20  joubert
*     added t3d version
*
*     Revision 1.1  1993/09/28  16:26:22  joubert
*     Implemented IPARM variable 15
*
*     Revision 1.3  1993/09/25  02:46:34  joubert
*     fixed some memory problems in the revcom layer
*
*     Revision 1.2  1993/09/14  02:23:59  mclay
*     Corrected memory allocations routines.
*
*     Revision 1.1  1993/08/24  16:07:56  mclay
*     New 0 malloc routines.
*
************************************************************************
*
      if (usrsiz .le. 0) then
        cmem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: usrsiz <= 0'])
      endif
      usize = usrsiz
      if (usize .lt. 3) usize = 3
*
      requiv=fwk(4)
      itmp=iequiv
      if (itmp .ne. 4) then
        cmem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: array not initialized'])
      endif
*
      requiv=fwk(3)
      rover =iequiv
      requiv=fwk(5)
      nvoids =iequiv
*
      found = .FALSE.
      if (nvoids .le. 0) then
        cmem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: no voids left'])
      endif
*
      go = rover
 8511 continue
        requiv=fwk(rover)
        vdsize =iequiv
        requiv=fwk(rover+vdsize-1)
        itmp =iequiv
        if (vdsize .ne. itmp) then
          cmem = 0
          go to 900
**#       HANDLE_ERROR(ERRMEM,['Error: boundary words do not match'])
        endif
        if (vdsize .ge. usize + 2) then
          found = .TRUE.
          go to 8513
        endif
        requiv=fwk(rover+1)
        rover =iequiv
      if (.not. (rover .eq. go)) go to 8511
 8513 continue
*
      if (.not. found) then
        cmem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: No void found'])
      endif
*
      if (vdsize - (usize + 2) .le. 12) then
*
        nvoids = nvoids - 1
        aloc = rover + 1
        requiv=fwk(rover+1)
        forwrd =iequiv
        requiv=fwk(rover+2)
        bckwrd =iequiv
*
        iequiv=-vdsize
        fwk(rover) =requiv
        iequiv=-vdsize
        fwk(rover+vdsize-1) =requiv
*
        iequiv=bckwrd
        fwk(forwrd+2) =requiv
        iequiv=forwrd
        fwk(bckwrd+1) =requiv
*
        if (rover .eq. go) then
          requiv=fwk(go+1)
          rover =iequiv
        else
          rover = go
        endif
*
      else
*
        aloc = rover + 1
        vdstrt = rover + usize + 2
        vdsize = vdsize - (usize + 2)
        requiv=fwk(rover+1)
        forwrd =iequiv
        requiv=fwk(rover+2)
        bckwrd =iequiv
*
        if (forwrd .eq. rover) forwrd = vdstrt
        if (bckwrd .eq. rover) bckwrd = vdstrt
*
        iequiv=vdsize
        fwk(vdstrt) =requiv
        iequiv=vdsize
        fwk(vdstrt + vdsize - 1) =requiv
*
        iequiv=forwrd
        fwk(vdstrt+1) =requiv
        iequiv=bckwrd
        fwk(vdstrt+2) =requiv
*
        iequiv=vdstrt
        fwk(bckwrd+1) =requiv
        iequiv=vdstrt
        fwk(forwrd+2) =requiv
*
        iequiv=-(usize + 2)
        fwk(rover) =requiv
        iequiv=-(usize + 2)
        fwk(rover + usize + 1) =requiv
*
        if (rover .eq. go) then
          rover = vdstrt
        else
          rover = go
        endif
*
      endif
*
      requiv=fwk(2)
      itmp=iequiv
      itmp = max(itmp,aloc+usize+1)
      iequiv=itmp
      fwk(2)=requiv
*
      iequiv=rover
      fwk(3) =requiv
      iequiv=nvoids
      fwk(5) =requiv
      cmem = aloc
*
      requiv=fwk(6)
      itmp=iequiv
      itmp = itmp + 1
      iequiv=itmp
      fwk(6)=requiv
      if (.not. cmemck (fwk)) then
        cmem = 0
      endif
*
  900 continue
      return
      end
