************************************************************************
**  ^ROUTINE: WJAGRX - Preconditioning routine for Jabobi method
**            preconditioner, regular grid format. Solves a diagonal
**            system each time it is called, returns solution in vo.
**            (^)
      subroutine cjagrx ( ijob , ia , ja , a , vi , vo , iwk , fwk , 
     &   iparm , fparm , ier )
**
**  ^DESCRIPTION: Preconditioning routine for Jacobi method
**      preconditioner, regular grid format. For IJOB
**      = 1/2 extract the diagonal of A, inverts, and stores it.
**      = 5 solves $Q_L$ vo = vi
**      = 6 solves $Q_L^*$ vo = vi
**      = 7 solves $Q_R$ vo = vi
**      = 8 solves $Q_R^*$ vo = vi
**
**  ^AUTHOR:   ak@c3.lanl.gov
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: see External declerations below
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    MVFFAL            - preconditioner applyer arg list
*#                    !---Integer Scalars:
*#                        ijob   - requested task (1=setup, -1=terminate)
*#                        ier    - error return value.
*#                    !---Integer Arrays:
*#                        ia     - used to store indexing information for
*#                                 non-zero elements of matrix stored in a.
*#                        ja     - used to store stencil and subgrid related
*#                                 info.
*#                        iparm  - used to pass integer parameters to and
*#                                 from the package.
*#                        iwk    - integer workspace
*#                    !---Float Arrays:
*#                        a      - array used to store non-zero elements
*#                                 of the matrix A.
*#                        fparm  - used to pass floating point
*#                                 parameters to and from the package.
*#                        fwk    - floating work array space
*#                        vi     - input vector
*#                        vo     - output vector
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
       integer ia(*)
       integer ja(*)
       complex a(*)
       complex vi(*)
       complex vo(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      external ximini
      external ximal
      external xifre
      external cfmini
      external cfmal
      external cffre
      integer nv
      integer ndim
      integer nsten
      integer nb
      integer ns
      integer imaxgr
      external imaxgr
      integer ivaxgr
      external ivaxgr
      integer itab
      integer iq
      integer imdiag
      integer iaxis
      integer isten
      integer is
      integer ibr
      integer ibc
*
      complex dmin
          complex dtmp
*
      external cwset
      external chad0
      external cchad0
          external cglmin
*
**#   NTAB - size of the saved table = 1
**#   IOFST - stencil offset extracted from ja
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov
*     $Id: jagrx.fm4,v 1.7 1994/11/22 05:19:28 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
*
* Table semantics:
*         1 - pointer to Q_L (which is == Q_R)
*
*-----------------------------------------------------------------------
*
      itab = (iparm(6))
      iq = (iparm(6))
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      nv = iparm(3 )
      ndim = ia (1 )
      nsten = ia (2)
      nb = ia (3 )
      ns = nv / nb
*
*-----------------------------------------------------------------------
*-----------------------------init case---------------------------------
*-----------------------------------------------------------------------
*
      if ((ijob .eq. 1) .or. (ijob .eq. 2)) then
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Point Jacobi Preconditioner.'
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        endif
*
      call ximal (itab,1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
           iparm(11) = itab
*
        if (iparm(13) .eq. 0) goto 900
*
      call cfmal (iq,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
           iwk(itab+0) = iq
*
         do 8511 ibr = 1, nb
       do 8513 is = 1, ns
      fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = (0e0,0.0e0)
 8513 continue
 8511 continue
        imdiag = 0
        do 8515 isten = 1, nsten
          do 8517 iaxis = 1, ndim
            if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 10
 8517     continue
          imdiag = 1
           do 8519 ibr = 1, nb
       do 8521 is = 1, ns
      fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = fwk(iq-1+ivaxgr(ibr,
     &   is,ia(5),nb,ns,nsten)) + a ( imaxgr(ibr,ibr,isten,is,ia(4),nb,
     &   ns,nsten))
 8521 continue
 8519 continue
   10     continue
 8515   continue
        if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'cjagrx' , iparm , 'No main diagonal'
     &              )
                go to 900
        endif
*
        dmin = real(abs(fwk(iq-1+ivaxgr(1,1,ia(5),nb,ns,nsten))))
         do 8523 ibr = 1, nb
       do 8525 is = 1, ns
      dmin = min(real(dmin), real(abs(fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,
     &   ns,nsten)))))
 8525 continue
 8523 continue
           call cglmin (1,dmin,dtmp, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        if (real(dmin) .eq. real((0e0,0.0e0))) then
                ier = -9
                call xersho ( ier, 'cjagrx' , iparm , ' ' )
                go to 900
        endif
*
*
        if (iparm(13).eq.1 .or. iparm(13).eq.2) then
*
           do 8527 ibr = 1, nb
       do 8529 is = 1, ns
      fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = (1e0,0.0e0) / fwk(iq-
     &   1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8529 continue
 8527 continue
*
        else
           do 8531 ibr = 1, nb
       do 8533 is = 1, ns
      fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = (1e0,0.0e0) / sqrt(
     &   real(abs(fwk(iq-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)))))
 8533 continue
 8531 continue
          fparm(13) = fparm(13) + ((7e0,0.0e0)*nb*ns)
*
        endif
*
        fparm(13) = fparm(13) + ((17e0,0.0e0)*nb*ns)
*
        go to 900
*
      else
        itab = iparm(11)
        if (itab .eq. (iparm(6))) goto 900
        iq = iwk(itab+0)
      endif
*
*-----------------------------------------------------------------------
*-----------------------------apply case--------------------------------
*-----------------------------------------------------------------------
*
      if (ijob .eq. 5) then
        if ((iparm(13).eq.1).or.(iparm(13).eq.3)) then
          call chad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          fparm(13) = fparm(13) + ((6e0,0.0e0)*nb*ns)
          go to 900
        else
          call cwset ( vo, vi , iparm , fparm , iwk , fwk , ier )
          go to 900
        endif
      endif
*
      if (ijob .eq. 7) then
        if ((iparm(13).eq.2).or.(iparm(13).eq.3)) then
          call chad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          fparm(13) = fparm(13) + ((6e0,0.0e0)*nb*ns)
          go to 900
        else
          call cwset ( vo, vi , iparm , fparm , iwk , fwk , ier )
          go to 900
        endif
      endif
*
      if (ijob .eq. 6) then
        if ((iparm(13).eq.1).or.(iparm(13).eq.3)) then
          if (iparm(42) .eq. 1) then
            call cchad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          else
            call chad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          endif
          fparm(13) = fparm(13) + ((6e0,0.0e0)*nb*ns)
          go to 900
        else
          call cwset ( vo, vi , iparm , fparm , iwk , fwk , ier )
          go to 900
        endif
      endif
*
      if (ijob .eq. 8) then
        if ((iparm(13).eq.2).or.(iparm(13).eq.3)) then
          if (iparm(42) .eq. 1) then
            call cchad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          else
            call chad0 (nv, vo, 1, fwk(iq), 1, vi, 1)
          endif
          fparm(13) = fparm(13) + ((6e0,0.0e0)*nb*ns)
          go to 900
        else
          call cwset ( vo, vi , iparm , fparm , iwk , fwk , ier )
          go to 900
        endif
                ier = -5
                call xersho ( ier, 'cjagrx' , iparm , ' ' )
                go to 900
      endif
*
      if (ijob .eq. -1) then
        go to 900
      endif
*
*-----------------------------------------------------------------------
*-------------------------final termination-----------------------------
*-----------------------------------------------------------------------
*
  900 continue
*
      if (iparm(11) .eq. (iparm(6))) go to 910
*
      if ((ijob.eq.-1) .or. (ier .lt. 0)) then
      call cffre (iq,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call xifre (itab,1, iparm , fparm , iwk , fwk , ier )
        iparm(11) = (iparm(6))
      endif
*
  910 continue
      return
      end
*-----------------------------------------------------------------------
