************************************************************************
**  ^ROUTINE: WIOMR - Reverse communication level routine for the
**                    truncated incomplete orthogonalization method
**                    (IOM). (^)
**
      subroutine ciomr ( ijob , ireq , u , uexact , b , iva , ivql , 
     &   ivqr , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    IOM iterative method of Saad, a.k.a. Arnoldi method for solving
**    linear systems of equations.  This is the truncated version;
**    if the truncation factor 16 is set sufficiently high, this
**    method becomes the full orthogonalization method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    Youcef Saad, "Krylov Subspace Methods for Solving Large
**    Unsymmetric Linear Systems", {\sl Mathematics of Computation},
**    Vol. 37, No. 155, July 1981, pp. 105--126.
**
**    Youcef Saad, ``Practical use of Some Krylov Subspace Methods for
**    Solving Indefinite and Nonsymmetric Linear Systems,'' {\sl SIAM
**    J. Sci. Stat. Comp.}, vol. 5, no. 1, March 1984, pp.  203-228.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
       complex u(*)
       complex uexact(*)
       complex b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer iitab
      integer iftab
      integer iwkstg
      integer iclstg
      integer in
      integer is
      integer iretlb
      integer ivitmp, ivotmp
      integer iv1tst, iv2tst
      integer istab1, istab2, istab
      integer ib1,ib2, iu1,iu2
      integer iud
      parameter (iud =0)
      integer ibd
      parameter (ibd =1)
      integer ilbd
      parameter (ilbd =2)
      integer irlbd
      parameter (irlbd=3)
      integer ied
      parameter (ied =4)
      integer ird
      parameter (ird =5)
      integer ilrd
      parameter (ilrd =6)
      integer irlrd
      parameter (irlrd=7)
      complex urndf
      complex top
      complex bot
      parameter (urndf=.1)
      complex mydot1, mydot2
      external cargck
      external cckstg
      external cwrnd
      external cifppr
      external citput
      external xtimer
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      external ximini
      external ximal
      external xifre
      external cfmini
      external cfmal
      external cffre
*     integer imv1, imv2        ! temporaries - for matvec
      integer ir
      integer iqlr
      integer iqrqlr
      integer ip
      integer iqlp
      integer iqrqlp
      integer iqrqlw
      integer iv1
      integer iv2
      integer ipf, iwf, icos, isin, iu
      integer ns
      integer i
      complex rdot
      complex rnorm
      complex r0norm
      complex vnorm, vnold
      complex zold, zbar, zbold, ucpr, ucprol, ucfr, ucfrol
      complex uudot, uexdt
      complex pap, vdot, ut, h, v1, v2, denom, val
*
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:52 1996 $
*     $Id: iomr.fm4,v 1.6 1994/11/22 05:20:27 joubert Exp $
*     $Revision: 1.6 $
*     $Log: iomr.fm4,v $
*     Revision 1.6  1994/11/22  05:20:27  joubert
*     misc changes for release 1.0
*
*     Revision 1.5  1994/10/06  16:24:20  joubert
*     fixed Intel flop count problem; ifparm param name changes
*
*     Revision 1.4  1994/09/28  19:24:52  joubert
*     mods to stats and ntest options
*
*     Revision 1.3  1994/07/06  05:52:33  joubert
*     mods to it meths
*
*     Revision 1.2  1994/07/05  22:20:49  joubert
*     lanczos/orthores acceleration; some cleanup of iterative methods
*
*     Revision 1.1  1994/06/24  18:20:53  joubert
*     t3d version mods; installed iom it meth
*
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      ip = (iparm(6))
      iqlp = (iparm(6))
      iqrqlp = (iparm(6))
      iqrqlw = (iparm(6))
      iv1 = (iparm(6))
      iv2 = (iparm(6))
      ipf = (iparm(6))
      iwf = (iparm(6))
      icos = (iparm(6))
      isin = (iparm(6))
      iu = (iparm(6))
*
*
      if (ijob .ne. 1) go to 1000
*
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
      call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
        call cargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 0) then
        call cifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
      call ximal (iitab,30, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iftab,14, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/''     Truncated IOM Method.''/)')
        endif
      endif
*
      ns = max(1,min(iparm(16),iparm(4)))
*
      call cfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqrqlw,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &     12).eq.6)) then
      call cfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ip,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , ier 
     &   )
           if (ier .lt. 0) go to 900
        endif
      else
        ir = iqlr
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call cfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
           if (ier .lt. 0) go to 900
      else
        iqrqlr = iqlr
        iqrqlp = iqlp
      endif
      call cfmal (iv1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iv2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ipf ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iwf ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (icos ,ns+1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (isin ,ns+1, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iu ,(ns+1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      if (iparm(14) .eq. -2 .or. iparm(14) .eq. -1) then
          call cwfil (u,(0e0,0.0e0), iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(14) .eq. 2 ) go to 5500
                 go to 5501
 5500  continue
          call cwrdot (mydot1,b, b, iparm , fparm , iwk , fwk , ier )
        call cwrnd (u, iparm , fparm , iwk , fwk , ier )
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2000
      go to 1500
 2000 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwrdot (mydot2,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwscl ( u, u, urndf*sqrt(mydot1/mydot2), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5502
 5501 continue
 5502 continue
*
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2001
      go to 1500
 2001 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(iv1), b, fwk(iv1), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwrdot (mydot1,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwset (fwk(iv1),u, iparm , fparm , iwk , fwk , ier )
        call cwrnd (u, iparm , fparm , iwk , fwk , ier )
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv2
       ireq = 3
      iretlb = 2002
      go to 1500
 2002 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwrdot (mydot2,fwk(iv2), fwk(iv2), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwsax (u,fwk(iv1), u, -urndf*sqrt(mydot1/mydot2), iparm ,
     &        fparm , iwk , fwk , ier )
                go to 5505
 5504 continue
 5505 continue
*
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
      call cfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call cwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call cwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5511
 5510 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2003
      go to 1500
 2003 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5511 continue
          call cwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5514
 5513 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2004
      go to 1500
 2004 continue
       if (ijob .eq. -1) go to 900
 5514 continue
          call cwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call cwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2005
      go to 1500
 2005 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call cwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5517
 5516 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2006
      go to 1500
 2006 continue
       if (ijob .eq. -1) go to 900
 5517 continue
          call cwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5520
 5519 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2007
      go to 1500
 2007 continue
       if (ijob .eq. -1) go to 900
 5520 continue
          call cwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2)) .or. iparm(14).eq.-1) 
     &   go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5527
                 go to 5528
 5527  continue
          call cwset (fwk(ir),b, iparm , fparm , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          call cwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5532
 5531 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2008
      go to 1500
 2008 continue
       if (ijob .eq. -1) go to 900
 5532 continue
                go to 5529
 5528 continue
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call cwset (fwk(iqlr),b, iparm , fparm , iwk , fwk , ier )
                go to 5535
 5534 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iqlr
       ireq = 5
      iretlb = 2009
      go to 1500
 2009 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5535 continue
 5529 continue
                go to 5526
 5525 continue
          call cwset (fwk(iqlr),b, iparm , fparm , iwk , fwk , ier )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5539
                 go to 5540
 5539  continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ir
       ireq = 3
      iretlb = 2010
      go to 1500
 2010 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ir), b, fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5542
                 go to 5543
 5542  continue
          call cwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5544
 5543 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2011
      go to 1500
 2011 continue
       if (ijob .eq. -1) go to 900
 5544 continue
                go to 5541
 5540 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iv1
       ireq = 3
      iretlb = 2012
      go to 1500
 2012 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(iv1), b, fwk(iv1), iparm , fparm , iwk , fwk 
     &       , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5545
                 go to 5546
 5545  continue
          call cwset (fwk(iqlr),fwk(iv1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5547
 5546 continue
          iva = iv1
          ivql = iqlr
       ireq = 5
      iretlb = 2013
      go to 1500
 2013 continue
       if (ijob .eq. -1) go to 900
 5547 continue
 5541 continue
                go to 5538
 5537 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iqlr
       ireq = 3
      iretlb = 2014
      go to 1500
 2014 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(iqlr), b, fwk(ir), iparm , fparm , iwk , fwk 
     &       , ier )
 5538 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5548
                 go to 5549
 5548  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5551
                 go to 5552
 5551  continue
          call cwset (fwk(iqrqlr),fwk(iqlr), iparm , fparm , iwk , fwk ,
     &        ier )
                go to 5553
 5552 continue
          ivql = iqlr
          ivqr = iqrqlr
       ireq = 7
      iretlb = 2015
      go to 1500
 2015 continue
       if (ijob .eq. -1) go to 900
 5553 continue
                go to 5550
 5549 continue
 5550 continue
*
          call cwrdot (rdot,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
      rnorm = sqrt(abs(rdot))
      r0norm = rnorm
*
*---------------------------iteration loop------------------------------
*
  100 continue
*
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'QL r norm           ', rnorm
        endif
        endif
*
        if (iparm(12).eq.-3) go to 5554
                 go to 5555
 5554  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr
          endif
          ireq = 9
      iretlb = 2016
      go to 1500
 2016 continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a/)') ' User-requested termination of itera
     &tive method.'
        endif
            endif
            go to 900
          endif
                go to 5556
 5555 continue
 5556 continue
        if (iparm(12) .gt. 1) go to 5557
                 go to 5558
 5557  continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ciomr' , iparm , '19 and 12 incompat
     &ible' )
                go to 900
              endif
          call cwdot (bot, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
              top = bot
            else
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call cwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call cwdot (bot, b, b, iparm , fparm , iwk , fwk , ier )
              top = bot
            else
          call cwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            endif
          endif
          if (iparm(12) .eq. 3) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call cwdot (bot, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5568
 5567 continue
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call cwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5571
 5570 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2017
      go to 1500
 2017 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5571 continue
          call cwdot (bot, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
              top = bot
                go to 5565
 5564 continue
          call cwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
 5565 continue
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 4) go to 5572
                 go to 5573
 5572  continue
            if (iparm(5) .eq. 0) go to 5575
                 go to 5576
 5575  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5578
                 go to 5579
 5578  continue
          call cwdot (bot, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5580
 5579 continue
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
          call cwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5583
 5582 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2018
      go to 1500
 2018 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5583 continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call cwset (fwk(iv2tst),fwk(iv1tst), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5586
 5585 continue
          ivql = iv1tst
          ivqr = iv2tst
       ireq = 7
      iretlb = 2019
      go to 1500
 2019 continue
       if (ijob .eq. -1) go to 900
 5586 continue
          call cwdot (bot, fwk(iv2tst), fwk(iv2tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5580 continue
              top = bot
                go to 5577
 5576 continue
          call cwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
 5577 continue
                go to 5574
 5573 continue
 5574 continue
          if (iparm(12) .eq. 1 ) then
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ciomr' , iparm , '19 and 12 incompat
     &ible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call cwdot (top, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
            else
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call cwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call cwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call cwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call cwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (real(top) .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ciomr' , iparm , 'Attempt to take sq
     &rt of negative number' )
                go to 900
          endif
          if (real(bot) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ciomr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(top)/real(bot))
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
                go to 5559
 5558 continue
 5559 continue
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. (0e0,0.0e0)) then
                ier = -10
                call xersho ( ier, 'ciomr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*
        if (iparm(12) .eq. -2) then
          call cwsub ( fwk(iv1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call cwrdot (uudot,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwrdot (uexdt,uexact, uexact, iparm , fparm , iwk , fwk ,
     &        ier )
          if (real(uudot) .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ciomr' , iparm , 'Attempt to take sq
     &rt of negative number' )
                go to 900
          endif
          if (real(uexdt) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ciomr' , iparm , 'Attempt to divide 
     &by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(uudot)/real(uexdt))
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'ciomr' , iparm , ' ' )
          go to 900
        endif
*
        call cckstg ( iclstg, iwkstg, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*-----------------------proceed with iteration--------------------------
*
        if (is .eq. 0) then
          call cwset (fwk(iqlp+iparm(3)*((mod((is),(ns+1))))),fwk(iqlr),
     &        iparm , fparm , iwk , fwk , ier )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(
     &       15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) 
     &       then
          call cwset (fwk(ip+iparm(3)*((mod((is),(ns+1))))),fwk(ir), 
     &       iparm , fparm , iwk , fwk , ier )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwset (fwk(iqrqlp+iparm(3)*((mod((is),(ns+1))))),fwk(
     &       iqrqlr), iparm , fparm , iwk , fwk , ier )
          endif
          vnorm = rnorm
          if (vnorm .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ciomr' , iparm , ' ' )
                go to 900
          endif
          fwk((ipf + mod((is),(ns+1)))) = (1e0,0.0e0)/vnorm
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'h(1,0)              ', vnorm
        endif
          endif
        endif
*
        go to (501,502,503,504), iparm(13)+1
  501   continue
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 3
      iretlb = 2020
      go to 1500
 2020 continue
       if (ijob .eq. -1) go to 900
        go to 510
  502   continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5587
                 go to 5588
 5587  continue
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 3
      iretlb = 2021
      go to 1500
 2021 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5590
                 go to 5591
 5590  continue
          call cwset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip +
     &       iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5592
 5591 continue
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 5
      iretlb = 2022
      go to 1500
 2022 continue
       if (ijob .eq. -1) go to 900
 5592 continue
                go to 5589
 5588 continue
          ivqr = iqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iv1
       ireq = 3
      iretlb = 2023
      go to 1500
 2023 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
          call cwset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iv1 
     &       ), iparm , fparm , iwk , fwk , ier )
                go to 5595
 5594 continue
          iva = iv1
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 5
      iretlb = 2024
      go to 1500
 2024 continue
       if (ijob .eq. -1) go to 900
 5595 continue
 5589 continue
        go to 510
  503   continue
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 3
      iretlb = 2025
      go to 1500
 2025 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5596
                 go to 5597
 5596  continue
          call cwset (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(
     &       iqlp +iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5598
 5597 continue
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
          ivqr = iqrqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 7
      iretlb = 2026
      go to 1500
 2026 continue
       if (ijob .eq. -1) go to 900
 5598 continue
        go to 510
  504   continue
          if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &       12).eq.6)) go to 5599
                 go to 5600
 5599  continue
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 3
      iretlb = 2027
      go to 1500
 2027 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
          call cwset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip +
     &       iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5604
 5603 continue
          iva = ip + iparm(3)*((mod((is+1),(ns+1))))
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 5
      iretlb = 2028
      go to 1500
 2028 continue
       if (ijob .eq. -1) go to 900
 5604 continue
                go to 5601
 5600 continue
          ivqr = iqrqlp + iparm(3)*((mod((is),(ns+1))))
          iva = iv1
       ireq = 3
      iretlb = 2029
      go to 1500
 2029 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5605
                 go to 5606
 5605  continue
          call cwset (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(iv1 
     &       ), iparm , fparm , iwk , fwk , ier )
                go to 5607
 5606 continue
          iva = iv1
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 5
      iretlb = 2030
      go to 1500
 2030 continue
       if (ijob .eq. -1) go to 900
 5607 continue
 5601 continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
          call cwset (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(
     &       iqlp +iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5610
 5609 continue
          ivql = iqlp + iparm(3)*((mod((is+1),(ns+1))))
          ivqr = iqrqlp + iparm(3)*((mod((is+1),(ns+1))))
       ireq = 7
      iretlb = 2031
      go to 1500
 2031 continue
       if (ijob .eq. -1) go to 900
 5610 continue
  510   continue
*
        fwk((ipf + mod((is+1),(ns+1)))) = fwk((ipf + mod((is),(ns+1))))
        do 8511 i = max(0,(is+1)-ns), (is+1)-1
          call cwdot (pap, fwk(iqlp+iparm(3)*((mod((i),(ns+1))))), fwk(
     &       iqlp+iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , iwk 
     &       , fwk , ier )
          pap = pap * conjg(fwk((ipf + mod((i),(ns+1))))) * fwk((ipf + 
     &       mod((is+1),(ns+1))))
          fwk((iu + mod((i+1)-1,(ns+1)))) = pap
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),'(a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') 'h(',i+
     &       1,',',is+1,')      ', pap
        endif
          endif
          val = - pap * fwk((ipf + mod((i),(ns+1)))) / fwk((ipf + mod((
     &       is+1),(ns+1))))
          call cwsax (fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(
     &       iqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(iqlp+iparm(3)*((
     &       mod((i),(ns+1))))), val, iparm , fparm , iwk , fwk , ier )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(
     &       15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) 
     &       then
          call cwsax (fwk(ip+iparm(3)*((mod((is+1),(ns+1))))),fwk(ip+
     &       iparm(3)*((mod((is+1),(ns+1))))), fwk(ip+iparm(3)*((mod((i)
     &       ,(ns+1))))), val, iparm , fparm , iwk , fwk , ier )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwsax (fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))),fwk(
     &       iqrqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(iqrqlp+iparm(
     &       3)*((mod((i),(ns+1))))), val, iparm , fparm , iwk , fwk , 
     &       ier )
          endif
 8511   continue
*
          call cwrdot (vdot,fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))), 
     &       fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))), iparm , fparm , 
     &       iwk , fwk , ier )
        vdot = vdot * conjg(fwk((ipf + mod((is+1),(ns+1))))) * fwk((ipf 
     &     + mod((is+1),(ns+1))))
        vnold = vnorm
        vnorm = sqrt(vdot)
        fwk((iu + mod((is+2)-1,(ns+1)))) = vnorm
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),'(a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') 'h(',is+
     &       2,',',is+1,')      ', vnorm
        endif
        endif
        if ((is+1)-ns .gt. 0) fwk((iu + mod(((is+1)-ns)-1,(ns+1)))) = (
     &     0e0,0.0e0)
        if (vnorm .eq. (0e0,0.0e0)) then
          fwk((ipf + mod((is+1),(ns+1)))) = (1e0,0.0e0)
        else
          fwk((ipf + mod((is+1),(ns+1)))) = fwk((ipf + mod((is+1),(ns+1)
     &       )))/vnorm
        endif
        if (.true.) then
          call cwscl ( fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(
     &       iqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk((ipf + mod((is+
     &       1),(ns+1)))), iparm , fparm , iwk , fwk , ier )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(
     &       15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) 
     &       then
          call cwscl ( fwk(ip+iparm(3)*((mod((is+1),(ns+1))))), fwk(ip+
     &       iparm(3)*((mod((is+1),(ns+1))))), fwk((ipf + mod((is+1),(
     &       ns+1)))), iparm , fparm , iwk , fwk , ier )
          endif
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwscl ( fwk(iqrqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk(
     &       iqrqlp+iparm(3)*((mod((is+1),(ns+1))))), fwk((ipf + mod((
     &       is+1),(ns+1)))), iparm , fparm , iwk , fwk , ier )
          endif
          fwk((ipf + mod((is+1),(ns+1)))) = (1e0,0.0e0)
        endif
*
        do 8513 i = max(1,(is+1)-ns), (is+1)-1
          ut = fwk((iu + mod((i )-1,(ns+1))))
          h = fwk((iu + mod((i+1)-1,(ns+1))))
          fwk((iu + mod((i )-1,(ns+1)))) = conjg(fwk((icos + mod((i),ns)
     &       )))*ut + conjg(fwk((isin + mod((i),ns))))*h
          fwk((iu + mod((i+1)-1,(ns+1)))) = -fwk((isin + mod((i),ns))) *
     &       ut + fwk((icos + mod((i),ns))) *h
 8513   continue
        if (iparm(2) .ge. 5) then
          do 8515 i = max(1,(is+1)-ns), (is+1)
        if (ipme .eq. 0) then
          write (iparm(1),'(a,i5,a,i5,a,1pg20.10,2x,1pg20.10)') 'u(',i,'
     &,',is+1,')      ', fwk((iu + mod((i)-1,(ns+1))))
        endif
 8515     continue
        endif
        ucprol = ucpr
        ucpr = fwk((iu + mod((is+1)-1,(ns+1))))
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'ucorner half rotated', ucpr
        endif
        endif
        v1 = ucpr
        v2 = vnorm
        denom = sqrt (conjg(v1)*v1 + conjg(v2)*v2)
        if (denom .eq. (0e0,0.0e0)) then
                ier = -6
                call xersho ( ier, 'ciomr' , iparm , 'Iterative method h
     &as apparently converged' )
                go to 900
        endif
        fwk((icos + mod((is+1),ns))) = v1/denom
        fwk((isin + mod((is+1),ns))) = v2/denom
        ucfrol = ucfr
        ucfr = denom
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'ucorner rotated     ', ucfr
        endif
        endif
*
        if (is .ne. 0) then
          fwk((iwf + mod((is-1),(ns+1)))) = fwk((iwf + mod((is-1),(ns+1)
     &       ))) * ucprol/ucfrol
        endif
*
          call cwset (fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))),fwk(
     &       iqrqlp+iparm(3)*((mod((is),(ns+1))))), iparm , fparm , iwk 
     &       , fwk , ier )
        fwk((iwf + mod((is),(ns+1)))) = fwk((ipf + mod((is),(ns+1))))
        do 8517 i = max(1,(is+1)-ns), (is+1)-1
          call cwsax (fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))),fwk(
     &       iqrqlw+iparm(3)*((mod((is),(ns+1))))), fwk(iqrqlw+iparm(3)*
     &       ((mod((i-1),(ns+1))))), -fwk((iu + mod((i)-1,(ns+1))))*fwk(
     &       (iwf + mod((i-1),(ns+1))))/fwk((iwf + mod((is),(ns+1)))), 
     &       iparm , fparm , iwk , fwk , ier )
 8517   continue
        fwk((iwf + mod((is),(ns+1)))) = fwk((iwf + mod((is),(ns+1))))/
     &     ucpr
*
        if (is .eq. 0) then
          zold = (0e0,0.0e0)
          zbar = vnold
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'zbar                ', zbar
        endif
          endif
          if (((mod(iparm(15)/1,2).eq.1) .or. iparm(12).eq.-2 .or. 
     &       iparm(12).eq.1 .or. iparm(12).eq.5)) then
          call cwsax (u,u, fwk(iqrqlw+iparm(3)*((mod((is),(ns+1))))), 
     &       zbar*fwk((iwf + mod((is),(ns+1)))), iparm , fparm , iwk , 
     &       fwk , ier )
          endif
        else
          zbold = zbar
          zold = conjg(fwk((icos + mod((is),ns))))*zbold
          zbar = - fwk((isin + mod((is),ns)) )*zbold
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'z                   ', zold
        endif
        if (ipme .eq. 0) then
          write (iparm(1),500) 'zbar                ', zbar
        endif
          endif
          if (((mod(iparm(15)/1,2).eq.1) .or. iparm(12).eq.-2 .or. 
     &       iparm(12).eq.1 .or. iparm(12).eq.5)) then
          call cwsax (u,u, fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), 
     &       (zold-zbold*ucfrol/ucprol)*fwk((iwf + mod((is-1),(ns+1)))),
     &        iparm , fparm , iwk , fwk , ier )
          call cwsax (u,u, fwk(iqrqlw+iparm(3)*((mod((is ),(ns+1))))), (
     &       zbar) *fwk((iwf + mod((is ),(ns+1)))), iparm , fparm , iwk 
     &       , fwk , ier )
          else
          call cwsax (u,u, fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), 
     &       (zold) *fwk((iwf + mod((is-1),(ns+1)))), iparm , fparm , 
     &       iwk , fwk , ier )
          endif
        endif
*
        if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &     /2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
          call cwscl ( fwk(ir), fwk(ip+iparm(3)*((mod((is+1),(ns+1))))),
     &        -vnorm*zbar/ucpr*fwk((ipf + mod((is+1),(ns+1)))), iparm , 
     &       fparm , iwk , fwk , ier )
        endif
*
        if (((mod(iparm(15)/4,2).eq.1) .or. iparm(12).eq.3 .or. iparm(
     &     12).eq.7) .or. ((.not.((iparm(13).eq.1).or.(iparm(13).eq.3)))
     &     .and.((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. 
     &     iparm(12).eq.6)) .or. ((.not.((iparm(13).eq.2).or.(iparm(13)
     &     .eq.3))).and.((mod(iparm(15)/8,2).eq.1) .or. iparm(12).eq.4 
     &     .or. iparm(12).eq.8))) then
          call cwscl ( fwk(iqlr), fwk(iqlp+iparm(3)*((mod((is+1),(ns+1))
     &       ))), -vnorm*zbar/ucpr*fwk((ipf + mod((is+1),(ns+1)))), 
     &       iparm , fparm , iwk , fwk , ier )
        endif
*
        if (((iparm(13).eq.2).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &     /8,2).eq.1) .or. iparm(12).eq.4 .or. iparm(12).eq.8)) then
          call cwscl ( fwk(iqrqlr), fwk(iqrqlp+iparm(3)*((mod((is+1),(
     &       ns+1))))), -vnorm*zbar/ucpr*fwk((ipf + mod((is+1),(ns+1))))
     &       , iparm , fparm , iwk , fwk , ier )
        endif
*
        rdot = (vnorm*zbar/ucpr)**2
        rnorm = sqrt(rdot)
*
        in = in + 1
        iparm(5) = in
        is = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a,i7,a/)') '     Truncated IOM Method has c
     &onverged in ', iparm(5), ' iterations.'
        endif
      endif
*
*-------------------------------terminate-------------------------------
*
  900 continue
*
      if (is.ne.0 .and. .not.((mod(iparm(15)/1,2).eq.1) .or. iparm(12)
     &   .eq.-2 .or. iparm(12).eq.1 .or. iparm(12).eq.5)) then
          call cwsax (u,u, fwk(iqrqlw+iparm(3)*((mod((is-1),(ns+1))))), 
     &       zbar*fwk((iwf + mod((is-1),(ns+1)))), iparm , fparm , iwk ,
     &        fwk , ier )
      endif
*
      if (iclstg .ne. 1) then
        call cckstg (-1, iwkstg, iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5611
                 go to 5612
 5611  continue
      call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call cwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5614
                 go to 5615
 5614  continue
          call cwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5616
 5615 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2032
      go to 1500
 2032 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
 5616 continue
          call cwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5617
                 go to 5618
 5617  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5619
 5618 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2033
      go to 1500
 2033 continue
       if (ijob .eq. -1) go to 900
 5619 continue
          call cwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call cwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2034
      go to 1500
 2034 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5620
                 go to 5621
 5620  continue
          call cwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5622
 5621 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2035
      go to 1500
 2035 continue
       if (ijob .eq. -1) go to 900
 5622 continue
          call cwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5623
                 go to 5624
 5623  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5625
 5624 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2036
      go to 1500
 2036 continue
       if (ijob .eq. -1) go to 900
 5625 continue
          call cwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ciomr' , iparm , 'Value of RELERR ma
     &y be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ciomr' , iparm , 'Value of RELRSD ma
     &y be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlrd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10
     &,2x,1pg20.10)') fparm(8)
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10
     &,2x,1pg20.10)') fparm(7)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (istab2,8, iparm , fparm , iwk , fwk , ier )
      call cffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5613
 5612 continue
 5613 continue
*
      call cffre (iu ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call cffre (isin ,ns+1, iparm , fparm , iwk , fwk , ier )
      call cffre (icos ,ns+1, iparm , fparm , iwk , fwk , ier )
      call cffre (iwf ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call cffre (ipf ,(ns+1), iparm , fparm , iwk , fwk , ier )
      call cffre (iv2 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iv1 ,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call cffre (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
      call cffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)/
     &   2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
      call cffre (ip,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , ier 
     &   )
      call cffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      call cffre (iqrqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
      call cffre (iqlp,iparm(3)*((ns+1)), iparm , fparm , iwk , fwk , 
     &   ier )
      call cffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call cffre (iftab,14, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,30, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
  910 continue
      if (iparm(27) .eq. 0) then
        call cifppr ( -1 , iparm, fparm, ier )
      endif
*
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'ciomr' , iparm , 'Values of ijob and
     & iparm(iptr) incompatible' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
        iitab = iwk(iitab+0)
        iftab = iwk(iitab+1)
        istab = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in = iwk(iitab+5)
        is = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ir = iwk(iitab+15)
        iqlr = iwk(iitab+16)
        iqrqlr = iwk(iitab+17)
        ip = iwk(iitab+18)
        iqlp = iwk(iitab+19)
        iqrqlp = iwk(iitab+20)
        iv1 = iwk(iitab+21)
        iv2 = iwk(iitab+22)
        iqrqlw = iwk(iitab+23)
        ipf = iwk(iitab+24)
        iwf = iwk(iitab+25)
        icos = iwk(iitab+26)
        isin = iwk(iitab+27)
        iu = iwk(iitab+28)
        ns = iwk(iitab+29)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot = fwk(iftab+2)
        rnorm = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        vnorm = fwk(iftab+5)
        vnold = fwk(iftab+6)
        zold = fwk(iftab+7)
        zbar = fwk(iftab+8)
        zbold = fwk(iftab+9)
        ucpr = fwk(iftab+10)
        ucprol = fwk(iftab+11)
        ucfr = fwk(iftab+12)
        ucfrol = fwk(iftab+13)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'ciomr' , iparm , 'Argument ijob inva
     &lid' )
      endif
*
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,
     &   2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,
     &   2023,2024,2025,2026,2027,2028,2029,2030,2031,2032,2033,2034,
     &   2035,2036), iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
        iwk(iitab+0) = iitab
        iwk(iitab+1) = iftab
        iwk(iitab+2) = istab
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in
        iwk(iitab+6) = is
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ir
        iwk(iitab+16) = iqlr
        iwk(iitab+17) = iqrqlr
        iwk(iitab+18) = ip
        iwk(iitab+19) = iqlp
        iwk(iitab+20) = iqrqlp
        iwk(iitab+21) = iv1
        iwk(iitab+22) = iv2
        iwk(iitab+23) = iqrqlw
        iwk(iitab+24) = ipf
        iwk(iitab+25) = iwf
        iwk(iitab+26) = icos
        iwk(iitab+27) = isin
        iwk(iitab+28) = iu
        iwk(iitab+29) = ns
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot
        fwk(iftab+3) = rnorm
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = vnorm
        fwk(iftab+6) = vnold
        fwk(iftab+7) = zold
        fwk(iftab+8) = zbar
        fwk(iftab+9) = zbold
        fwk(iftab+10) = ucpr
        fwk(iftab+11) = ucprol
        fwk(iftab+12) = ucfr
        fwk(iftab+13) = ucfrol
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10,2x,1pg20.10 )
*
      end
