************************************************************************
**  ^ROUTINE: WGLADD - Global sum of vectors.
**                       (^)
**
      subroutine cgladd ( nelts, vec, vwork, iparm , fparm , iwk , fwk ,
     &    ier )
**
**  ^DESCRIPTION:
**
**    This routine computes the elementwise global sum of elements in the
**    vector vec.  For 1\leq i\leq nelts, vec(i) is globally summed across
**    processors.
**    vwork is a work vector of the same dimension as vec.
**    This is a global operation and therefore must be executed on
**    all nodes before execution may continue.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:58 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS: vwork is a work array
**
**  ^ALGORITHM:
**    Chosen from the following:
**      - Bidirectional exchange
**      - Send all to node zero, operate, broadcast
**      - System subroutine call
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
*#    BASICAL - (^)
       complex vwork(*)
       complex vec(*)
      integer nelts
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer i
      integer ineqv
      external ineqv
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:58 1996 $
*     $Id: gladd.fm4,v 1.9 1994/04/30 04:39:07 joubert Exp $
*     $Revision: 1.9 $
************************************************************************
      if (nelts .le. 0) return
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
          call gssum (vec,nelts*2,vwork)
  900 continue
      return
      end
