************************************************************************
**  ^ROUTINE: WFFRE - routine to free floating point memory. (^)
**
      subroutine cffre ( iptr, nwords, iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    This routine is the general purpose floating point memory
**    deallocator.  It calls either the Fortran or the **    deallocator.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    BASICAL - (^)
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
      integer iptr
      integer nwords
*
         integer memtmp
         integer mtmp2
      integer fused
      integer imem
*     external imem
      integer cmem
*     external cmem
      integer iequiv
      complex requiv
      equivalence (iequiv,requiv)
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:02:00 1996 $
*     $Id: ffre.fm4,v 1.1 1994/04/21 01:37:10 joubert Exp $
************************************************************************
*
      if (iptr .eq. (iparm(6))) go to 900
      if (nwords .le. 0) go to 900
*
         if (iparm(6) .eq. 1) then
           call cffree (fwk,iptr)
           requiv=fwk(1)
           fused=iequiv
           fused = fused - (nwords) - 2
           iequiv=fused
           fwk(1)=requiv
         else
           call cmfree (fwk,iptr)
           requiv=fwk(1)
           fused=iequiv
           fused = fused - (nwords) - 2
           iequiv=fused
           fwk(1)=requiv
*
         endif
*
  900 continue
*
      iptr = (iparm(6))
*
      return
      end
