************************************************************************
**  ^ROUTINE: WCGS2R - Reverse communication level routine for
**                     CGSTAB2 acceleration. (^)
**
      subroutine ccgs2r ( ijob , ireq , u , uexact , b , iva , ivql , 
     &   ivqr , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    Preconditioned CGSTAB2 acceleration routine.  This is
**    Gutknecht's modification of van der Vorst's CGSTAB algorithm,
**    designed to improve its handling of matrices with complex
**    spectra.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    CGS
**
**  ^REFERENCES:
**   ``Variants of BiCGStab for Matrices with Complex Spectrum,''
**   Martin H. Gutknecht, IPS Research Report No. 91--14,
**   Interdisciplinary Project Center for Supercomputing, ETH--Zentrum,
**   CH--8092, Zurich, August 1991.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHRAL        - (^)
      integer ijob
      integer ireq
      integer ier
       integer iwk(*)
       integer iparm(*)
       complex fwk(*)
       complex fparm(*)
       complex u(*)
       complex uexact(*)
       complex b(*)
      integer ivql
      integer iva
      integer ivqr
*
        integer itimer
        double precision tc1, tr1, tc2, tr2
      integer iitab
      integer iftab
      integer iwkstg
      integer iclstg
      integer in
      integer is
      integer iretlb
      integer ivitmp, ivotmp
      integer iv1tst, iv2tst
      integer istab1, istab2, istab
      integer ib1,ib2, iu1,iu2
      integer iud
      parameter (iud =0)
      integer ibd
      parameter (ibd =1)
      integer ilbd
      parameter (ilbd =2)
      integer irlbd
      parameter (irlbd=3)
      integer ied
      parameter (ied =4)
      integer ird
      parameter (ird =5)
      integer ilrd
      parameter (ilrd =6)
      integer irlrd
      parameter (irlrd=7)
      complex urndf
      complex top
      complex bot
      parameter (urndf=.1)
      complex mydot1, mydot2
      external cargck
      external cckstg
      external cwrnd
      external cifppr
      external citput
      external xtimer
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      external ximini
      external ximal
      external xifre
      external cfmini
      external cfmal
      external cffre
*     integer imv1, imv2        ! temporaries - for matvec
      integer iqlr
      integer ix
      integer irt
      integer ilw
      integer ilarlw
      integer irls
      integer ilarls
      integer irlt
      integer ilarlt
      integer ilwh
      integer iv1
      integer ir
      integer iarls
      integer iarlt
      integer iwh
      integer iw
      integer iarlw
      integer iqrqlr
      integer irlrls
      integer irlrlt
      integer irlwh
      integer irlw
      integer irlrlw
      complex rdot
      complex rnorm
      complex r0norm
      complex delta
      complex deltol
      complex phi
      complex psi
      complex omega
      complex omegol
      complex xi
      complex eta
      complex uudot, uexdt
      complex mydot, b11, b12, b21, b22, a1, a2, det
*
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:02:04 1996 $
*     $Id: cgs2r.fm4,v 1.10 1994/11/22 05:20:16 joubert Exp $
*     $Revision: 1.10 $
*     $Log: cgs2r.fm4,v $
*     Revision 1.10  1994/11/22  05:20:16  joubert
*     misc changes for release 1.0
*
*     Revision 1.9  1994/09/28  19:24:42  joubert
*     mods to stats and ntest options
*
*     Revision 1.8  1994/07/06  05:52:21  joubert
*     mods to it meths
*
*     Revision 1.7  1994/07/05  22:20:39  joubert
*     lanczos/orthores acceleration; some cleanup of iterative methods
*
*     Revision 1.6  1994/06/24  18:20:38  joubert
*     t3d version mods; installed iom it meth
*
*     Revision 1.5  1994/06/07  17:40:07  joubert
*     installed orthores iterative method
*
*     Revision 1.4  1994/06/02  21:55:03  joubert
*     installed CM random vector routine
*
*     Revision 1.3  1994/05/19  05:47:07  joubert
*     added simplified qmr acceleration
*
*     Revision 1.2  1994/05/18  07:58:20  joubert
*     cgs2 fully functional
*
*     Revision 1.1  1994/05/17  18:08:58  joubert
*     added CGSTAB(2) acceleration
************************************************************************
*
      iitab = (iparm(6))
      iftab = (iparm(6))
      ix = (iparm(6))
      irt = (iparm(6))
      iv1 = (iparm(6))
      ir = (iparm(6))
      iqlr = (iparm(6))
      iqrqlr = (iparm(6))
      irls = (iparm(6))
      iarls = (iparm(6))
      ilarls = (iparm(6))
      irlrls = (iparm(6))
      irlt = (iparm(6))
      ilarlt = (iparm(6))
      iarlt = (iparm(6))
      irlrlt = (iparm(6))
      iwh = (iparm(6))
      ilwh = (iparm(6))
      irlwh = (iparm(6))
      iw = (iparm(6))
      ilw = (iparm(6))
      irlw = (iparm(6))
      iarlw = (iparm(6))
      ilarlw = (iparm(6))
      irlrlw = (iparm(6))
*
*
      if (ijob .ne. 1) go to 1000
*
      iclstg = 1
      itimer = 0
      in = 0
      iparm(5) = in
      is = 0
*
      iu1 = (iparm(6))
      iu2 = (iparm(6))
      ib1 = (iparm(6))
      ib2 = (iparm(6))
      istab1 = (iparm(6))
      istab2 = (iparm(6))
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(27) .eq. 0) iparm(27) = 0
      if (iparm(27) .eq. 0) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
      call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
        call cargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 0) then
        call cifppr ( 1 , iparm, fparm, ier)
           if (ier .lt. 0) go to 900
      endif
*
      call ximal (iitab,38, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iftab,13, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/''     CGSTAB2 Method.''/)')
        endif
      endif
*
      call cfmal (ix,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilarlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irls,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilarls,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilarlt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ilwh,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iv1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &     12).eq.6)) then
      call cfmal (ir,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iarls,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iarlt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iwh,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iarlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        else
          ir = iv1
          iarls = iv1
          iarlw = iv1
        endif
      else
        ir = iqlr
        iarls = ilarls
        iarlt = ilarlt
        iwh = ilwh
        iw = ilw
        iarlw = ilarlw
      endif
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call cfmal (iqrqlr,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlrls,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlrlt,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlwh,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (irlrlw,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else
        iqrqlr = iqlr
        irlrls = ilarls
        irlrlt = ilarlt
        irlwh = ilwh
        irlw = ilw
        irlrlw = ilarlw
      endif
*
      if (iparm(14) .eq. -2 ) then
          call cwfil (u,(0e0,0.0e0), iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(14) .eq. 2 .or. iparm(14) .eq. -1) go to 5500
                 go to 5501
 5500  continue
          call cwrdot (mydot1,b, b, iparm , fparm , iwk , fwk , ier )
        call cwrnd (u, iparm , fparm , iwk , fwk , ier )
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = irt
       ireq = 3
      iretlb = 2000
      go to 1500
 2000 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwrdot (mydot2,fwk(irt), fwk(irt), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwscl ( u, u, urndf*sqrt(mydot1/mydot2), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5502
 5501 continue
 5502 continue
*
      if (iparm(14) .eq. 3) go to 5503
                 go to 5504
 5503  continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = irt
       ireq = 3
      iretlb = 2001
      go to 1500
 2001 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(irt), b, fwk(irt), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwrdot (mydot1,fwk(irt), fwk(irt), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwset (fwk(irt),u, iparm , fparm , iwk , fwk , ier )
        call cwrnd (u, iparm , fparm , iwk , fwk , ier )
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = iqlr
       ireq = 3
      iretlb = 2002
      go to 1500
 2002 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwrdot (mydot2,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk 
     &       , fwk , ier )
          call cwsax (u,fwk(irt), u, -urndf*sqrt(mydot1/mydot2), iparm ,
     &        fparm , iwk , fwk , ier )
                go to 5505
 5504 continue
 5505 continue
          call cwset (fwk(ix+iparm(3)*((mod(0,2)))),u, iparm , fparm , 
     &       iwk , fwk , ier )
*
      if (iparm(21) .eq. 1) go to 5506
                 go to 5507
 5506  continue
      call cfmal (istab1,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (istab2,8, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        istab = istab1
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call cwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5509
                 go to 5510
 5509  continue
          call cwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5511
 5510 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2003
      go to 1500
 2003 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5511 continue
          call cwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5512
                 go to 5513
 5512  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5514
 5513 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2004
      go to 1500
 2004 continue
       if (ijob .eq. -1) go to 900
 5514 continue
          call cwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call cwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2005
      go to 1500
 2005 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5515
                 go to 5516
 5515  continue
          call cwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5517
 5516 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2006
      go to 1500
 2006 continue
       if (ijob .eq. -1) go to 900
 5517 continue
          call cwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5518
                 go to 5519
 5518  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5520
 5519 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2007
      go to 1500
 2007 continue
       if (ijob .eq. -1) go to 900
 5520 continue
          call cwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
                go to 5508
 5507 continue
 5508 continue
*
      if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5521
                 go to 5522
 5521  continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5524
                 go to 5525
 5524  continue
          call cwset (fwk(ir),b, iparm , fparm , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5527
                 go to 5528
 5527  continue
          call cwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5529
 5528 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2008
      go to 1500
 2008 continue
       if (ijob .eq. -1) go to 900
 5529 continue
                go to 5526
 5525 continue
          call cwset (fwk(iqlr),b, iparm , fparm , iwk , fwk , ier )
 5526 continue
                go to 5523
 5522 continue
        if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5530
                 go to 5531
 5530  continue
          ivqr = ix + iparm(3)*((mod(0,2)))
          iva = ir
       ireq = 3
      iretlb = 2009
      go to 1500
 2009 continue
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ir), b, fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5533
                 go to 5534
 5533  continue
          call cwset (fwk(iqlr),fwk(ir), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5535
 5534 continue
          iva = ir
          ivql = iqlr
       ireq = 5
      iretlb = 2010
      go to 1500
 2010 continue
       if (ijob .eq. -1) go to 900
 5535 continue
                go to 5532
 5531 continue
          ivqr = ix + iparm(3)*((mod(0,2)))
          iva = iqlr
       ireq = 3
      iretlb = 2011
      go to 1500
 2011 continue
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(iqlr), b, fwk(ir), iparm , fparm , iwk , fwk 
     &       , ier )
 5532 continue
 5523 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5536
                 go to 5537
 5536  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5539
                 go to 5540
 5539  continue
          call cwset (fwk(iqrqlr),fwk(iqlr), iparm , fparm , iwk , fwk ,
     &        ier )
                go to 5541
 5540 continue
          ivql = iqlr
          ivqr = iqrqlr
       ireq = 7
      iretlb = 2012
      go to 1500
 2012 continue
       if (ijob .eq. -1) go to 900
 5541 continue
                go to 5538
 5537 continue
 5538 continue
*
          call cwrdot (rdot,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
      rnorm = sqrt(abs(rdot))
      r0norm = rnorm
*
*---------------------------iteration loop------------------------------
*
  100 continue
*
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'QL r norm           ', rnorm
        endif
        endif
*
        if (iparm(12).eq.-3) go to 5542
                 go to 5543
 5542  continue
          if ((mod(iparm(15)/1,2).eq.1)) then
          call cwset (u,fwk(ix+iparm(3)*((mod(in,2)))), iparm , fparm , 
     &       iwk , fwk , ier )
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          iva = ir
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          ivql = iqlr
          endif
          if ((mod(iparm(15)/8,2).eq.1)) then
          ivqr = iqrqlr
          endif
          ireq = 9
      iretlb = 2013
      go to 1500
 2013 continue
          if ((mod(iparm(15)/8,2).eq.1)) then
          endif
          if ((mod(iparm(15)/4,2).eq.1)) then
          endif
          if ((mod(iparm(15)/2,2).eq.1)) then
          endif
          if ((mod(iparm(15)/1,2).eq.1)) then
          endif
          if (ier .ge. 0) then
            call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          endif
          if (ijob .eq. -1) then
            if (iparm(2).ge.3 .and. iparm(27).eq.0) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a/)') ' User-requested termination of itera
     &tive method.'
        endif
            endif
            go to 900
          endif
                go to 5544
 5543 continue
 5544 continue
        if (iparm(12) .gt. 1) go to 5545
                 go to 5546
 5545  continue
          if (iparm(12) .eq. 1 ) then
          call cwset (u,fwk(ix+iparm(3)*((mod(in,2)))), iparm , fparm , 
     &       iwk , fwk , ier )
            if (iparm(5) .eq. 0) then
              if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ccgs2r' , iparm , '19 and 12 incompa
     &tible' )
                go to 900
              endif
          call cwdot (bot, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
              top = bot
            else
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call cwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
          endif
          if (iparm(12) .eq. 2 ) then
            if (iparm(5) .eq. 0) then
          call cwdot (bot, b, b, iparm , fparm , iwk , fwk , ier )
              top = bot
            else
          call cwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            endif
          endif
          if (iparm(12) .eq. 3) go to 5548
                 go to 5549
 5548  continue
            if (iparm(5) .eq. 0) go to 5551
                 go to 5552
 5551  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5554
                 go to 5555
 5554  continue
          call cwdot (bot, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5556
 5555 continue
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5557
                 go to 5558
 5557  continue
          call cwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5559
 5558 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2014
      go to 1500
 2014 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5559 continue
          call cwdot (bot, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5556 continue
              top = bot
                go to 5553
 5552 continue
          call cwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
 5553 continue
                go to 5550
 5549 continue
 5550 continue
          if (iparm(12) .eq. 4) go to 5560
                 go to 5561
 5560  continue
            if (iparm(5) .eq. 0) go to 5563
                 go to 5564
 5563  continue
              if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) go to 5566
                 go to 5567
 5566  continue
          call cwdot (bot, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
                go to 5568
 5567 continue
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cfmal (iv2tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5569
                 go to 5570
 5569  continue
          call cwset (fwk(iv1tst),b, iparm , fparm , iwk , fwk , ier )
                go to 5571
 5570 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = iv1tst
       ireq = 5
      iretlb = 2015
      go to 1500
 2015 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
       if (ijob .eq. -1) go to 900
 5571 continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5572
                 go to 5573
 5572  continue
          call cwset (fwk(iv2tst),fwk(iv1tst), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5574
 5573 continue
          ivql = iv1tst
          ivqr = iv2tst
       ireq = 7
      iretlb = 2016
      go to 1500
 2016 continue
       if (ijob .eq. -1) go to 900
 5574 continue
          call cwdot (bot, fwk(iv2tst), fwk(iv2tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv2tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 5568 continue
              top = bot
                go to 5565
 5564 continue
          call cwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
 5565 continue
                go to 5562
 5561 continue
 5562 continue
          if (iparm(12) .eq. 1 ) then
          call cwset (u,fwk(ix+iparm(3)*((mod(in,2)))), iparm , fparm , 
     &       iwk , fwk , ier )
            if (iparm(19) .eq. 0) then
                ier = -5
                call xersho ( ier, 'ccgs2r' , iparm , '19 and 12 incompa
     &tible' )
                go to 900
            endif
            if (((iparm(14).eq.0).or.(iparm(14).eq.-2))) then
          call cwdot (top, uexact, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
            else
      call cfmal (iv1tst,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          call cwsub ( fwk(iv1tst), u, uexact, iparm , fparm , iwk , 
     &       fwk , ier )
          call cwdot (top, fwk(iv1tst), fwk(iv1tst), iparm , fparm , 
     &       iwk , fwk , ier )
      call cffre (iv1tst,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
            endif
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 6) then
          call cwdot (top, fwk(ir), fwk(ir), iparm , fparm , iwk , fwk ,
     &        ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 7) then
          call cwdot (top, fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (iparm(12) .eq. 8) then
          call cwdot (top, fwk(iqrqlr), fwk(iqrqlr), iparm , fparm , 
     &       iwk , fwk , ier )
            if (iparm(5) .eq. 0) bot = top
          endif
          if (real(top) .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ccgs2r' , iparm , 'Attempt to take s
     &qrt of negative number' )
                go to 900
          endif
          if (real(bot) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ccgs2r' , iparm , 'Attempt to divide
     & by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(top)/real(bot))
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
                go to 5547
 5546 continue
 5547 continue
*
        if (iparm(12) .eq. -1) then
          if (r0norm .eq. (0e0,0.0e0)) then
                ier = -10
                call xersho ( ier, 'ccgs2r' , iparm , 'Attempt to divide
     & by zero' )
                go to 900
          endif
          fparm(5) = rnorm/r0norm
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*
        if (iparm(12) .eq. -2) then
          call cwsub ( fwk(iv1), fwk(ix+iparm(3)*((mod(in,2)))), uexact,
     &        iparm , fparm , iwk , fwk , ier )
          call cwrdot (uudot,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwrdot (uexdt,uexact, uexact, iparm , fparm , iwk , fwk ,
     &        ier )
          if (real(uudot) .lt. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ccgs2r' , iparm , 'Attempt to take s
     &qrt of negative number' )
                go to 900
          endif
          if (real(uexdt) .le. real((0e0,0.0e0))) then
                ier = -10
                call xersho ( ier, 'ccgs2r' , iparm , 'Attempt to divide
     & by zero' )
                go to 900
          endif
          fparm(5) = sqrt(real(uudot)/real(uexdt))
          call citput ( in , is , iparm , fparm , iwk , fwk , ier )
          if (real(fparm(5)) .le. real(fparm(4))) go to 2500
        endif
*
        if (in .ge. iparm(4)) then
                ier = 2
                call xersho ( ier, 'ccgs2r' , iparm , ' ' )
          go to 900
        endif
*
        call cckstg ( iclstg, iwkstg, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
*-----------------------proceed with iteration--------------------------
*
      if (in .eq. 0) then
          call cwset (fwk(irt ),fwk(iqlr), iparm , fparm , iwk , fwk , 
     &       ier )
        if (iparm(20) .eq. 1) then
          delta = rdot
        else
          call cwcdot (delta, fwk(irt), fwk(iqlr), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
        endif
      else
        deltol = delta
          call cwcdot (delta, fwk(irt), fwk(iqlr), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
      endif
      if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'delta               ', delta
        endif
      endif
*
*     ---s----------
*
      if (mod(in,2) .eq. 0) go to 5575
                 go to 5576
 5575  continue
        if (in .eq. 0) go to 5578
                 go to 5579
 5578  continue
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5581
                 go to 5582
 5581  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5584
                 go to 5585
 5584  continue
          call cwset (fwk(irls+iparm(3)*((mod(in,2)))),fwk(iqlr), iparm 
     &       , fparm , iwk , fwk , ier )
                go to 5586
 5585 continue
          ivql = iqlr
          ivqr = irls + iparm(3)*((mod(in,2)))
       ireq = 7
      iretlb = 2017
      go to 1500
 2017 continue
       if (ijob .eq. -1) go to 900
 5586 continue
                go to 5583
 5582 continue
          call cwset (fwk(irls+iparm(3)*((mod(in,2)))),fwk(iqlr), iparm 
     &       , fparm , iwk , fwk , ier )
 5583 continue
                go to 5580
 5579 continue
          if (deltol .eq. (0e0,0.0e0) .or. eta .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ccgs2r' , iparm , ' ' )
                go to 900
          endif
          psi = (omega*delta)/(deltol*eta)
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'psi                 ', psi
        endif
          endif
          call cwsax (fwk(irls+iparm(3)*((mod(in,2)))),fwk(iqrqlr), fwk(
     &       irlt), -psi*((1e0,0.0e0)-xi ), iparm , fparm , iwk , fwk , 
     &       ier )
          call cwsax (fwk(irls+iparm(3)*((mod(in,2)))),fwk(irls+iparm(3)
     &       *((mod(in,2)))), fwk(irls+iparm(3)*((mod(in-1,2)))), -psi*(
     &        xi ), iparm , fparm , iwk , fwk , ier )
          call cwsax (fwk(irls+iparm(3)*((mod(in,2)))),fwk(irls+iparm(3)
     &       *((mod(in,2)))), fwk(irlrls), -psi*( eta), iparm , fparm , 
     &       iwk , fwk , ier )
 5580 continue
                go to 5577
 5576 continue
          if (deltol .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ccgs2r' , iparm , 'delta is zero' )
                go to 900
          endif
          if (eta .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ccgs2r' , iparm , 'chi is zero' )
                go to 900
          endif
          psi = -(omega*delta)/(deltol*eta)
          if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'psi                 ', psi
        endif
          endif
          call cwsax (fwk(irls+iparm(3)*((mod(in,2)))),fwk(iqrqlr), fwk(
     &       irls+iparm(3)*((mod(in-1,2)))), -psi , iparm , fparm , iwk 
     &       , fwk , ier )
          call cwsax (fwk(irls+iparm(3)*((mod(in,2)))),fwk(irls+iparm(3)
     &       *((mod(in,2)))), fwk(irlrls), -psi*(-eta), iparm , fparm , 
     &       iwk , fwk , ier )
*
*         ---t----------
*
          call cwsax (fwk(irlt),fwk(irlw), fwk(irls+iparm(3)*((mod(in-1,
     &       2)))), -psi, iparm , fparm , iwk , fwk , ier )
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(
     &       15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) 
     &       then
          call cwsax (fwk(iarlt),fwk(iarlw), fwk(iarls), -psi, iparm , 
     &       fparm , iwk , fwk , ier )
          endif
          call cwsax (fwk(ilarlt),fwk(ilarlw), fwk(ilarls), -psi, iparm 
     &       , fparm , iwk , fwk , ier )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwsax (fwk(irlrlt),fwk(irlrlw), fwk(irlrls), -psi, iparm 
     &       , fparm , iwk , fwk , ier )
          endif
 5577 continue
*
*     ---As----------
*
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5587
                 go to 5588
 5587  continue
          ivqr = irls + iparm(3)*((mod(in,2)))
          iva = iarls
       ireq = 3
      iretlb = 2018
      go to 1500
 2018 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5590
                 go to 5591
 5590  continue
          call cwset (fwk(ilarls),fwk(iarls), iparm , fparm , iwk , fwk 
     &       , ier )
                go to 5592
 5591 continue
          iva = iarls
          ivql = ilarls
       ireq = 5
      iretlb = 2019
      go to 1500
 2019 continue
       if (ijob .eq. -1) go to 900
 5592 continue
                go to 5589
 5588 continue
          ivqr = irls + iparm(3)*((mod(in,2)))
          iva = ilarls
       ireq = 3
      iretlb = 2020
      go to 1500
 2020 continue
       if (ijob .eq. -1) go to 900
 5589 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5593
                 go to 5594
 5593  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5596
                 go to 5597
 5596  continue
          call cwset (fwk(irlrls),fwk(ilarls), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5598
 5597 continue
          ivql = ilarls
          ivqr = irlrls
       ireq = 7
      iretlb = 2021
      go to 1500
 2021 continue
       if (ijob .eq. -1) go to 900
 5598 continue
                go to 5595
 5594 continue
 5595 continue
*
*     ---phi, omega----------
*
          call cwcdot (phi, fwk(irt), fwk(ilarls), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
      if (delta .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ccgs2r' , iparm , ' ' )
                go to 900
      endif
      phi = phi / delta
      if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'phi                 ', phi
        endif
      endif
      if (phi .eq. (0e0,0.0e0)) then
                ier = -7
                call xersho ( ier, 'ccgs2r' , iparm , ' ' )
                go to 900
      endif
      omegol = omega
      omega = (1e0,0.0e0)/phi
      if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'omega               ', omega
        endif
      endif
*
*     ---wh----------
*
      if (mod(in,2) .eq. 1) then
          if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(
     &       15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) 
     &       then
          call cwsax (fwk(iwh),fwk(iw), fwk(iarlt), -omega, iparm , 
     &       fparm , iwk , fwk , ier )
          endif
          call cwsax (fwk(ilwh),fwk(ilw), fwk(ilarlt), -omega, iparm , 
     &       fparm , iwk , fwk , ier )
          if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwsax (fwk(irlwh),fwk(irlw), fwk(irlrlt), -omega, iparm ,
     &        fparm , iwk , fwk , ier )
          endif
      endif
*
*     ---w----------
*
      if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)/
     &   2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
          call cwsax (fwk(iw),fwk(ir), fwk(iarls), -omega, iparm , 
     &       fparm , iwk , fwk , ier )
      endif
          call cwsax (fwk(ilw),fwk(iqlr), fwk(ilarls), -omega, iparm , 
     &       fparm , iwk , fwk , ier )
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwsax (fwk(irlw),fwk(iqrqlr), fwk(irlrls), -omega, iparm 
     &       , fparm , iwk , fwk , ier )
      endif
*
*     ---Aw----------
*
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5599
                 go to 5600
 5599  continue
          ivqr = irlw
          iva = iarlw
       ireq = 3
      iretlb = 2022
      go to 1500
 2022 continue
       if (ijob .eq. -1) go to 900
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5602
                 go to 5603
 5602  continue
          call cwset (fwk(ilarlw),fwk(iarlw), iparm , fparm , iwk , fwk 
     &       , ier )
                go to 5604
 5603 continue
          iva = iarlw
          ivql = ilarlw
       ireq = 5
      iretlb = 2023
      go to 1500
 2023 continue
       if (ijob .eq. -1) go to 900
 5604 continue
                go to 5601
 5600 continue
          ivqr = irlw
          iva = ilarlw
       ireq = 3
      iretlb = 2024
      go to 1500
 2024 continue
       if (ijob .eq. -1) go to 900
 5601 continue
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5605
                 go to 5606
 5605  continue
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5608
                 go to 5609
 5608  continue
          call cwset (fwk(irlrlw),fwk(ilarlw), iparm , fparm , iwk , 
     &       fwk , ier )
                go to 5610
 5609 continue
          ivql = ilarlw
          ivqr = irlrlw
       ireq = 7
      iretlb = 2025
      go to 1500
 2025 continue
       if (ijob .eq. -1) go to 900
 5610 continue
                go to 5607
 5606 continue
 5607 continue
*
*     ---u, r----------
*
      if (mod(in,2) .eq. 0) then
          call cwrdot (mydot,fwk(ilarlw), fwk(ilarlw), iparm , fparm , 
     &       iwk , fwk , ier )
        if (mydot .eq. (0e0,0.0e0)) then
                ier = -6
                call xersho ( ier, 'ccgs2r' , iparm , ' ' )
                go to 900
        endif
          call cwcdot (eta, fwk(ilarlw), fwk(ilw), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
        eta = eta / mydot
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'eta                 ', eta
        endif
        endif
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in,2)) )), fwk(irls+iparm(3)*((mod(in,2)))), omega, 
     &       iparm , fparm , iwk , fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(irlw), eta, iparm , fparm , iwk , fwk 
     &       , ier )
        if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &     /2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
          call cwsax (fwk(ir),fwk(iw), fwk(iarlw), -eta, iparm , fparm ,
     &        iwk , fwk , ier )
        endif
          call cwsax (fwk(iqlr),fwk(ilw), fwk(ilarlw), -eta, iparm , 
     &       fparm , iwk , fwk , ier )
        if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwsax (fwk(iqrqlr),fwk(irlw), fwk(irlrlw), -eta, iparm , 
     &       fparm , iwk , fwk , ier )
        endif
      else
          call cwsub ( fwk(iv1), fwk(ilw), fwk(ilwh), iparm , fparm , 
     &       iwk , fwk , ier )
          call cwrdot (b11,fwk(iv1), fwk(iv1), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwcdot (b12, fwk(iv1), fwk(ilarlw), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
        b21 = conjg(b12)
          call cwrdot (b22,fwk(ilarlw), fwk(ilarlw), iparm , fparm , 
     &       iwk , fwk , ier )
        det = b11*b22 - b12*b21
        if (det .eq. (0e0,0.0e0)) then
                ier = -6
                call xersho ( ier, 'ccgs2r' , iparm , '2x2 matrix is sin
     &gular' )
                go to 900
        endif
          call cwcdot (a1, fwk(iv1), fwk(ilw), iparm(20), iparm , fparm 
     &       , iwk , fwk , ier )
          call cwcdot (a2, fwk(ilarlw), fwk(ilw), iparm(20), iparm , 
     &       fparm , iwk , fwk , ier )
        xi = - (a1*b22-a2*b12)/det
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'xi                  ', xi
        endif
        endif
        eta = - (a2*b11-a1*b21)/det
        if (iparm(2) .ge. 5) then
        if (ipme .eq. 0) then
          write (iparm(1),500) 'eta                 ', eta
        endif
        endif
          call cwscl ( fwk(ix+iparm(3)*((mod(in+1,2)))), fwk(ix+iparm(3)
     &       *((mod(in-1,2)))), ((1e0,0.0e0)-xi), iparm , fparm , iwk , 
     &       fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(irls+iparm(3)*((mod(in-1,2)))), ((1e0,
     &       0.0e0)-xi)*omegol, iparm , fparm , iwk , fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(irlt), ((1e0,0.0e0)-xi)*omega, iparm ,
     &        fparm , iwk , fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(ix+iparm(3)*((mod(in,2)))), xi, iparm 
     &       , fparm , iwk , fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(irls+iparm(3)*((mod(in,2)))), xi*
     &       omega, iparm , fparm , iwk , fwk , ier )
          call cwsax (fwk(ix+iparm(3)*((mod(in+1,2)))),fwk(ix+iparm(3)*(
     &       (mod(in+1,2)))), fwk(irlw), -eta, iparm , fparm , iwk , 
     &       fwk , ier )
        if (((iparm(13).eq.1).or.(iparm(13).eq.3)) .and. ((mod(iparm(15)
     &     /2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(12).eq.6)) then
          call cwscl ( fwk(ir), fwk(iwh), ((1e0,0.0e0)-xi), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwsax (fwk(ir),fwk(ir), fwk(iw), xi, iparm , fparm , iwk 
     &       , fwk , ier )
          call cwsax (fwk(ir),fwk(ir), fwk(iarlw), eta, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call cwscl ( fwk(iqlr), fwk(ilwh), ((1e0,0.0e0)-xi), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwsax (fwk(iqlr),fwk(iqlr), fwk(ilw), xi, iparm , fparm ,
     &        iwk , fwk , ier )
          call cwsax (fwk(iqlr),fwk(iqlr), fwk(ilarlw), eta, iparm , 
     &       fparm , iwk , fwk , ier )
        if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call cwscl ( fwk(iqrqlr), fwk(irlwh), ((1e0,0.0e0)-xi), iparm 
     &       , fparm , iwk , fwk , ier )
          call cwsax (fwk(iqrqlr),fwk(iqrqlr), fwk(irlw), xi, iparm , 
     &       fparm , iwk , fwk , ier )
          call cwsax (fwk(iqrqlr),fwk(iqrqlr), fwk(irlrlw), eta, iparm ,
     &        fparm , iwk , fwk , ier )
        endif
      endif
*
          call cwrdot (rdot,fwk(iqlr), fwk(iqlr), iparm , fparm , iwk , 
     &       fwk , ier )
        rnorm = sqrt(abs(rdot))
*
        in = in + 1
        iparm(5) = in
        is = is + 1
*
      go to 100
*
 2500 continue
      if (iparm(2) .ge. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),'(/a,i7,a/)') '     CGSTAB2 Method has converg
     &ed in ', iparm(5), ' iterations.'
        endif
      endif
*
*-------------------------------terminate-------------------------------
*
  900 continue
*
*     ---set u last time----------
*
      if (.not.(iparm(12).eq.-3.and.(mod(iparm(15)/1,2).eq.1))) then
          call cwset (u,fwk(ix+iparm(3)*((mod(in,2)))), iparm , fparm , 
     &       iwk , fwk , ier )
      endif
*
      if (iclstg .ne. 1) then
        call cckstg (-1, iwkstg, iparm , fparm , iwk , fwk , ier )
      endif
*
      if (iparm(21).eq.1 .and. ier.ge.0) go to 5611
                 go to 5612
 5611  continue
      call cfmal (ib1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (ib2,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (iu1,iparm(3), iparm , fparm , iwk , fwk , ier )
      call cfmal (iu2,iparm(3), iparm , fparm , iwk , fwk , ier )
        istab = istab2
        if (iparm(19) .eq. 1) then
          call cwdot (fwk(istab+iud), uexact, uexact, iparm , fparm , 
     &       iwk , fwk , ier )
        endif
          call cwdot (fwk(istab+ibd ), b, b, iparm , fparm , iwk , fwk ,
     &        ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5614
                 go to 5615
 5614  continue
          call cwset (fwk(ib2),b, iparm , fparm , iwk , fwk , ier )
                go to 5616
 5615 continue
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          iva = ivitmp
          call cwset (fwk(iva),b, iparm , fparm , iwk , fwk , ier )
          ivql = ib2
       ireq = 5
      iretlb = 2026
      go to 1500
 2026 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
 5616 continue
          call cwdot (fwk(istab+ilbd), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5617
                 go to 5618
 5617  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5619
 5618 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2027
      go to 1500
 2027 continue
       if (ijob .eq. -1) go to 900
 5619 continue
          call cwdot (fwk(istab+irlbd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          call cwsub ( fwk(iu1), u, uexact, iparm , fparm , iwk , fwk , 
     &       ier )
          call cwdot (fwk(istab+ied), fwk(iu1), fwk(iu1), iparm , fparm 
     &       , iwk , fwk , ier )
        endif
      call cfmal (ivitmp,iparm(3), iparm , fparm , iwk , fwk , ier )
          ivqr = ivitmp
          call cwset (fwk(ivqr),u, iparm , fparm , iwk , fwk , ier )
          iva = ib1
       ireq = 3
      iretlb = 2028
      go to 1500
 2028 continue
      call cffre (ivitmp,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
       if (ijob .eq. -1) go to 900
          call cwsub ( fwk(ib1), b, fwk(ib1), iparm , fparm , iwk , fwk 
     &       , ier )
          call cwdot (fwk(istab+ird), fwk(ib1), fwk(ib1), iparm , fparm 
     &       , iwk , fwk , ier )
         if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) go to 5620
                 go to 5621
 5620  continue
          call cwset (fwk(ib2),fwk(ib1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5622
 5621 continue
          iva = ib1
          ivql = ib2
       ireq = 5
      iretlb = 2029
      go to 1500
 2029 continue
       if (ijob .eq. -1) go to 900
 5622 continue
          call cwdot (fwk(istab+ilrd ), fwk(ib2), fwk(ib2), iparm , 
     &       fparm , iwk , fwk , ier )
          call cwset (fwk(iu1),fwk(ib2), iparm , fparm , iwk , fwk , 
     &       ier )
         if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) go to 5623
                 go to 5624
 5623  continue
          call cwset (fwk(iu2),fwk(iu1), iparm , fparm , iwk , fwk , 
     &       ier )
                go to 5625
 5624 continue
          ivql = iu1
          ivqr = iu2
       ireq = 7
      iretlb = 2030
      go to 1500
 2030 continue
       if (ijob .eq. -1) go to 900
 5625 continue
          call cwdot (fwk(istab+irlrd), fwk(iu2), fwk(iu2), iparm , 
     &       fparm , iwk , fwk , ier )
        if (iparm(19) .eq. 1) then
          if (fwk(istab1+ied) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ccgs2r' , iparm , 'Value of RELERR m
     &ay be inaccurate' )
          else
            fparm(8) = sqrt(fwk(istab2+ied)/fwk(istab1+ied))
          endif
        endif
        if (fwk(istab1+ird) .eq. (0e0,0.0e0)) then
                ier = 4
                call xersho ( ier, 'ccgs2r' , iparm , 'Value of RELRSD m
     &ay be inaccurate' )
        else
          fparm(7) = sqrt(fwk(istab2+ird)/fwk(istab1+ird))
        endif
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final iteration statistics'')')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of uexact            '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+iud))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of b                 '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ibd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*b              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilbd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*b           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlbd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of error             '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ied))
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of residual          '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ird))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Ql*r              '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+ilrd))
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''2-norm of Qr*Ql*r           '',1pg20.10
     &,2x,1pg20.10)') sqrt(fwk(istab+irlrd))
        endif
        if (iparm(19) .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of error    '',1pg20.10
     &,2x,1pg20.10)') fparm(8)
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Relative 2-norm of residual '',1pg20.10
     &,2x,1pg20.10)') fparm(7)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        endif
      call cffre (iu2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iu1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ib2,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ib1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (istab2,8, iparm , fparm , iwk , fwk , ier )
      call cffre (istab1,8, iparm , fparm , iwk , fwk , ier )
                go to 5613
 5612 continue
 5613 continue
*
      if (((iparm(13).eq.2).or.(iparm(13).eq.3))) then
      call cffre (irlrlw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irlw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irlwh,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irlrlt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irlrls,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iqrqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      endif
      if (((iparm(13).eq.1).or.(iparm(13).eq.3))) then
        if (((mod(iparm(15)/2,2).eq.1) .or. iparm(12).eq.2 .or. iparm(
     &     12).eq.6)) then
      call cffre (iarlw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iwh,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iarlt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iarls,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ir,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
        endif
      endif
      call cffre (iv1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ilwh,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ilarlt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irlt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ilarls,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irls,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
      call cffre (ilarlw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ilw,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (iqlr,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (irt,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call cffre (ix,iparm(3)*(2), iparm , fparm , iwk , fwk , ier )
*
*
*
*
      call cffre (iftab,13, iparm , fparm , iwk , fwk , ier )
      call xifre (iitab,38, iparm , fparm , iwk , fwk , ier )
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(1) = fparm(1) + (tc2-tc1)
        fparm(2) = fparm(2) + (tr2-tr1)
      endif
*
  910 continue
      if (iparm(27) .eq. 0) then
        call cifppr ( -1 , iparm, fparm, ier )
      endif
*
      if (iparm(27) .eq. 0) iparm(27) = 0
      iparm(11) = (iparm(6))
      ireq = -1
      return
*
*-------------------------------brancher--------------------------------
*
*
 1000 continue
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      iitab = iparm(11)
      if (iitab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
*
      if (iparm(11) .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'ccgs2r' , iparm , 'Values of ijob an
     &d iparm(iptr) incompatible' )
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
*
        iitab = iwk(iitab+0)
        iftab = iwk(iitab+1)
        istab = iwk(iitab+2)
        iwkstg = iwk(iitab+3)
        iclstg = iwk(iitab+4)
        in = iwk(iitab+5)
        is = iwk(iitab+6)
        itimer = iwk(iitab+7)
        iretlb = iwk(iitab+8)
        ivitmp = iwk(iitab+9)
        ivotmp = iwk(iitab+10)
        iv1tst = iwk(iitab+11)
        iv2tst = iwk(iitab+12)
        istab1 = iwk(iitab+13)
        istab2 = iwk(iitab+14)
        ix = iwk(iitab+15)
        irt = iwk(iitab+16)
        iv1 = iwk(iitab+17)
        ir = iwk(iitab+18)
        iqlr = iwk(iitab+19)
        iqrqlr = iwk(iitab+20)
        irls = iwk(iitab+21)
        iarls = iwk(iitab+22)
        ilarls = iwk(iitab+23)
        irlrls = iwk(iitab+24)
        irlt = iwk(iitab+25)
        ilarlt = iwk(iitab+26)
        iarlt = iwk(iitab+27)
        irlrlt = iwk(iitab+28)
        iwh = iwk(iitab+29)
        ilwh = iwk(iitab+30)
        irlwh = iwk(iitab+31)
        iw = iwk(iitab+32)
        ilw = iwk(iitab+33)
        irlw = iwk(iitab+34)
        iarlw = iwk(iitab+35)
        ilarlw = iwk(iitab+36)
        irlrlw = iwk(iitab+37)
        top = fwk(iftab+0)
        bot = fwk(iftab+1)
        rdot = fwk(iftab+2)
        rnorm = fwk(iftab+3)
        r0norm = fwk(iftab+4)
        delta = fwk(iftab+5)
        deltol = fwk(iftab+6)
        phi = fwk(iftab+7)
        psi = fwk(iftab+8)
        omega = fwk(iftab+9)
        omegol = fwk(iftab+10)
        xi = fwk(iftab+11)
        eta = fwk(iftab+12)
*
      if (ijob.ne.3 .and. ijob.ne.-1) then
                ier = -4
                call xersho ( ier, 'ccgs2r' , iparm , 'Argument ijob inv
     &alid' )
      endif
*
      go to (2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,
     &   2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,
     &   2023,2024,2025,2026,2027,2028,2029,2030), iretlb - 2000 + 1
*
*---------------------------request of caller---------------------------
*
*
 1500 continue
      iparm(11) = iitab
        iwk(iitab+0) = iitab
        iwk(iitab+1) = iftab
        iwk(iitab+2) = istab
        iwk(iitab+3) = iwkstg
        iwk(iitab+4) = iclstg
        iwk(iitab+5) = in
        iwk(iitab+6) = is
        iwk(iitab+7) = itimer
        iwk(iitab+8) = iretlb
        iwk(iitab+9) = ivitmp
        iwk(iitab+10) = ivotmp
        iwk(iitab+11) = iv1tst
        iwk(iitab+12) = iv2tst
        iwk(iitab+13) = istab1
        iwk(iitab+14) = istab2
        iwk(iitab+15) = ix
        iwk(iitab+16) = irt
        iwk(iitab+17) = iv1
        iwk(iitab+18) = ir
        iwk(iitab+19) = iqlr
        iwk(iitab+20) = iqrqlr
        iwk(iitab+21) = irls
        iwk(iitab+22) = iarls
        iwk(iitab+23) = ilarls
        iwk(iitab+24) = irlrls
        iwk(iitab+25) = irlt
        iwk(iitab+26) = ilarlt
        iwk(iitab+27) = iarlt
        iwk(iitab+28) = irlrlt
        iwk(iitab+29) = iwh
        iwk(iitab+30) = ilwh
        iwk(iitab+31) = irlwh
        iwk(iitab+32) = iw
        iwk(iitab+33) = ilw
        iwk(iitab+34) = irlw
        iwk(iitab+35) = iarlw
        iwk(iitab+36) = ilarlw
        iwk(iitab+37) = irlrlw
        fwk(iftab+0) = top
        fwk(iftab+1) = bot
        fwk(iftab+2) = rdot
        fwk(iftab+3) = rnorm
        fwk(iftab+4) = r0norm
        fwk(iftab+5) = delta
        fwk(iftab+6) = deltol
        fwk(iftab+7) = phi
        fwk(iftab+8) = psi
        fwk(iftab+9) = omega
        fwk(iftab+10) = omegol
        fwk(iftab+11) = xi
        fwk(iftab+12) = eta
      call xtimer (tc2,tr2,iparm(22),0)
      fparm(1) = fparm(1) + (tc2-tc1)
      fparm(2) = fparm(2) + (tr2-tr1)
      return
*
*
*--------------------------------end------------------------------------
*
  500 format ( 1x, a, 1pg20.10,2x,1pg20.10 )
*
      end
