C
C     This is regress.f  $Revision: 1.6 $
C
C     See the LICENSE file for conditions of usage 
C


C
C     The purpose of this program is, to test the correctness
C     of code generated by the codegen.pl tool.
C

C
C     The strategy is:
C     
C     *) Generate a random system matrix.
C     *) Zero out elements, so we maintain the structure for
C        which the solver was generated.
C     *) Solve system  Ax=b  using FastQR
C     *) Test that ||A*x - b|| < err
C

      PROGRAM regress

      implicit none
      integer maxdim, nruns, dim
      parameter(maxdim = 60, nruns = 10000)
      
      double precision A(maxdim,maxdim), B(maxdim), X(maxdim)
      double precision A1(maxdim,maxdim), B1(maxdim)
      double precision S(maxdim,maxdim)
      double precision error, errorsum

      integer i,j,test

      open(10,file='regress.system')
      read(10,*) dim, dim
      CALL readstruct(S,dim)

      print *,'Regression testing...'

C
C     Generate a nice Hilbert matrix and a random
C     right-side
C
      error = 0.d0
      errorsum = 0.d0

      do j = 1,maxdim
         do i = 1,maxdim
            A(i,j) = 1.d0 / (1.d0 * (i + j - 1))
         end do
         B(j) = rand() * 10.d0
         if(rand().GT.0.6d0) then
            B(j) = -B(j)
         end if
      end do

C     
C     Correct matrix structure
C     
      CALL correctstruct(S,A,dim)


C
C     Build alternate matrices
C
         do i=1,dim
            do j=1,dim
               if( A(i,j) > 1.d-6 .OR. A(i,j) < -1.d-6) then
                  A1(i,j) = A(i,j) + 5. - rand() * 10.d0
               else
                  A1(i,j) = 0.
               end if
            end do
         end do


         do i=1,dim
            B1(i) = B(i) + 5. - rand() * 10.d0
         end do

C     
C     Call fastqr solver
C     

      CALL fastqr(A,X,B)

C     
C     Multiply A with found X and compare with B
C     

      CALL checkresult(A,X,B,dim,error,errorsum)

      print *,'Regression test passed.'
      print *,'Maximum error was ',error
      errorsum = errorsum / (1.d0 * nruns)
      print *,'Mean error was    ',errorsum

      print *,'Benchmarking...'

C
C     Benchmark
C
      do test=1,nruns

         CALL fastqr(A,X,B)
         CALL fastqr(A1,X,B1)

      end do

      print *,'Done'

      STOP
      END


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     Utility routines
C     and stuff...




C
C     readstruct
C

      SUBROUTINE readstruct(S,dim)
      implicit none
      integer dim
      integer S(dim,dim)

      print *,'System has dimension',dim
      read(10,*) S
      close(10)

      RETURN
      END

C
C     correctstructC

      SUBROUTINE correctstruct(S,A,dim)
      implicit none
      integer dim
      double precision A(dim,dim)
      integer S(dim,dim)
      integer i,j

      do i=1,dim
         do j=1,dim
            if( S(j,i) .EQ. 0 ) then
               A(i,j) = 0.d0
            else
               A(i,j) = A(i,j) * 10.d0
            end if
         end do
      end do

      RETURN
      END

C
C     Checkresult
C

      SUBROUTINE checkresult(A,X,B,dim,error,errorsum)
      implicit none
      integer dim
      double precision A(dim,dim), X(dim), B(dim), P(dim)
      integer i,j,pass
      double precision error, errorsum, localesum, lerr

C
C     Multiply A and X into P
C
      do i=1,dim
         P(i) = 0.d0
         do j=1,dim
            P(i) = P(i) + A(i,j) * X(j)
         end do
      end do
      
C
C     Compare P and X
C

      localesum = 0.d0
      pass = 0
      do i=1,dim
         lerr = ABS(P(i) - B(i))
         localesum = localesum + lerr
         if(lerr .GT. error) then
            if(ABS(B(i)).GT.0.0001) then
               error = lerr/ABS(B(i))
            else
               error = lerr
            end if
         endif
         if( lerr .GT. 0.0001) then
            if(pass.EQ.0) then
               print *,'Index P (actual result) and B (expected result)'
            endif
            print *,i,P(i),B(i)
            pass = pass + 1
         endif
      end do
      if(pass.NE.0) then
         print *,'Max error: ',error
         print *,'Regression test FAILED!'
         stop
      endif

      localesum = localesum / (1.d0 * dim)
      errorsum = errorsum + localesum

      RETURN
      END
