/* printsys $Revision: 1.2 $      */

/* This will print the system matrix in a file in the
 * following format:
 *     ------------------------------
 *     m n
 *     a00 a01 a02    ...    a0(n-1)
 *     .  .  .    
 *     am0 am1 am2    ...    amn
 *     ------------------------------
 * where a is either ``0'' or ``x'' depending on whether
 * the element is zero or non-zero
 */

#include "optimqr.h"
#include <stdio.h>

void printsys(matrix_t *matrix, char* filename) {
  FILE* file;
  unsigned line,elem;

  file = fopen(filename,"w");
  if(!file) fatal("Couldn't open output file");

  fprintf(file, "%u %u\n", dim1, dim2);
  
  for(line = 0; line < dim1; line++) {
    for(elem = 0; elem < dim2; elem++) {
      char a;
      switch (matrix->elements[line][elem]) {
      case 0 : a = '0'; break;
      case 1 : a = 'x'; break;
      default: fatal("Internal error caught in printsys()"); a = 0;
      }
      fprintf(file, "%c ", a);
    }
    fprintf(file,"\n");
  }
  
  fclose(file);
}
