#!/usr/bin/perl -w
#
# This is gensys.pl $Revision: 1.5 $
#
# Used to generate systems for testing optimqr
#

if($#ARGV < 2) {
    print "Usage:  ./gensys.pl <type string> <size> "
	."<output file> [nz probability] [% of triangle to fill]\n";
    print "\nSupported type string fields:\n";
    print " r  random content\n";
    print " u  fill upper left triangle\n";
    print " c  a diagonal cross\n";
    print "\n";
    die;
}

my $tstring = $ARGV[0];
my $size = $ARGV[1];
my $outname = $ARGV[2];
my $TOLERANCE = 2; # Tolerance on final sparsity in %
my $MAXITER = 10; # Max. number of iterations
my $prob;
my $tpct;

my %content = ();

my $argptr = 3;

if($tstring =~ /r/) { 
    $content{'r'} = 1;
    $prob = $ARGV[$argptr++];
} else { $content{'r'}  = 0 }

if($tstring =~ /u/) { 
    $content{'u'} = 1;
    $tpct = $ARGV[$argptr++];
} else { $content{'u'}  = 0 }

if($tstring =~ /c/) { $content{'c'} = 1 }
else { $content{'c'}  = 0 }

if($content{'r'} && $size*$prob/100 < 1) { die "Probability too small" }

print "Generating ";
$| = 1;

my $iter = 0;
my $totnz = 0;
do {
    $iter++;
    print "+" if $totnz != 0;
    open(OUTF,">$outname") or die "Couldn't create output file!";
    print OUTF "$size $size\n";
    $totnz = 0;
    my ($i,$j);
    for($i = 0; $i < $size; $i++) {
	if(($i % ($size/10+1)) == 0) { print "." }
	my $rnz = 0;
	my $str = "";
	do {
	    print "," if $rnz != 0;
	    $rnz = 0;
	    $str = "";
	    for($j = 0; $j < $size; $j++) {
		my $elm = "0";
		if($content{'r'}) {
		    if(rand(100) < ($prob - 1/$size) || $j == $i) {
			$elm = "x";
		    }
		}
		if($content{'u'}) {
		    if($j <= ($size*$tpct/100 - $i - 1)) { $elm = "x" }
		}		
		if($content{'c'}) {
		    if($j == ($size - $i - 1)) { $elm = "x" }
		}		

		$rnz++ if ($elm eq "x");
		$str .= "$elm ";
	    }
	} while ($rnz < 1);
	$totnz += $rnz;
	print OUTF $str."\n";
    }
    close(OUTF);
} while (abs($totnz*100/($size*$size) - $prob > $TOLERANCE) 
	 && $iter < $MAXITER);

print "\n";
printf("Final probability: %6.3f %%\n", $totnz*100/($size*$size));
