#include "gemmw.h"


/***********************************************************************
 *
 * winolap
 *
 * This routine checks to see if the active part of a matrix M1 overlaps
 * with the active part of some other matrix op(M2).  This returns 0 if
 * the two matrices do not overlap and 1 if they do.  This is used by
 * _gemmw to see if C can be used for auxiliary storage without destroying
 * either A or B.
 *
 * This is an internal routine that is not intended to be called
 * directly by the users of _gemmw.
 *
 **********************************************************************/

INT winolap ( mat1, lda1, nseg1, lseg1, mat2, lda2, nseg2, lseg2 )
               char* mat1;          /* Address of 1st byte of matrix 1       */
               INT   lda1;          /* Byte lda of matrix 1                  */
               INT   nseg1;         /* Number of contiguous segments         */
               INT   lseg1;         /* Byte length of each segment           */
               char* mat2;          /* Address of 1st byte of matrix 2       */
               INT   lda2;          /* Byte lda of matrix 2                  */
               INT   nseg2;         /* Number of contiguous segments         */
               INT   lseg2;         /* Byte length of each segment           */

{   if ( mat1 + ( nseg1 - 1 ) * lda1 + lseg1 <= mat2 ||    
         mat2 + ( nseg2 - 1 ) * lda2 + lseg2 <= mat1  )
        return( 0 );
         
    while ( nseg1 > 0 && nseg2 > 0 )
    {   if ( mat1 <= mat2 )
        {   if ( mat1 + lseg1 > mat2 ) return( 1 ); 
            mat1 += lda1;
            nseg1--;
        }
        else
        {   if ( mat2 + lseg2 > mat1 ) return( 1 ); 
            mat2 += lda2;
            nseg2--;
        }
    }
    return( 0 );
}

