/* testz.f -- translated by f2c (version of 17 January 1992  0:17:58).
   You must link the resulting object file with the libraries:
        -lF77 -lI77 -lm -lc   (in that order)
*/

#include "f2c.h"

#ifndef N_MAX
#define N_MAX       1826
#endif
#define N_MAX_2     N_MAX * N_MAX
#define AUX_SIZE    4 * N_MAX_2

#ifdef FortNames_Cap
#define GEMMW   ZGEMMW
#define GEMM    ZGEMM
#define GEMMS   ZGEMMS
#define GEMUL3  ZGEMUL3
#define SECOND  SECOND
#define URAND   SURAND
#endif

#ifdef FortNames_Under
#define GEMMW   zgemmw_
#define GEMM    zgemm_
#define GEMMS   zgemms_
#define GEMUL3  zgemul3_
#define SECOND  second_
#define URAND   surand_
#endif

#ifndef GEMMW
#define GEMMW   zgemmw
#define GEMM    zgemm
#define GEMMS   zgemms
#define GEMUL3  zgemul3
#define SECOND  second
#define URAND   surand
#endif

/* Table of constant values */

static integer c__1 = 1;
static integer c_b10 = AUX_SIZE;
static doublecomplex c_b22 = {1.,0.};
static doublecomplex c_b23 = {0.,0.};

/* Main program */
main()
{
    /* Initialized data */

    static integer nn[17] = { 100,120,144,172,206,247,355,426,511,613,735,882,
            1000,1058,1269,1522,1826 };
    static char names[8*4+1] = "ZGEMMS  ZGEMM   ZGEMMW  ZGEMUL3 ";
    static char name1[8*4+1];

    /* System generated locals */
    doublereal d__1;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();

    /* Local variables */
    extern /* Subroutine */ int doit_();
    static doublecomplex a[N_MAX_2]     /* was [1826][1826] */, b[N_MAX_2]      
            /* was [1826][1826] */, c[N_MAX_2]  /* was [1826][1826] */;
    static integer n, which;
    static doublereal t1;
    static integer in;
    static doublereal aux[AUX_SIZE];


/* ----------------------------------------------------------------------- */
/* Loop through various values of N */
/* ----------------------------------------------------------------------- */
    for (in = 1; in <= 17 && nn[in-1] <= N_MAX; ++in) {
        n = nn[in - 1];
        if (n <= 0) {
            goto L5001;
        }
        printf( "-------\nN = %4d\n", n );
        for (which = 1; which <= 4; ++which) {
            doit_(&which, &n, a, b, c, aux, &c_b10, &t1);
/* ----------------------------------------------------------------------- */
/* Print out the timings */
/* ----------------------------------------------------------------------- */
/*               flops = 2.0d0 * (dfloat(n)**3) */
/*               flops = 8.0d0 * (dfloat(n)**3) */
            if ( t1 >= 0 ) {
                d__1 = t1 * 1e-6;
                strcpy( name1, names + (which - 1 << 3) );
                name1[8] = '\0';
                printf( "%s%10.3e\n", name1, d__1 );
                }
/* L5000: */
        }
L5001:
        ;
    }
} /* MAIN__ */

/* Subroutine */
int doit_(which, n, a, b, c, aux, naux, t1)
integer *which, *n;
doublecomplex *a, *b, *c;
doublereal *aux;
integer *naux;
doublereal *t1;
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
            i__3, i__4;
    doublecomplex z__1;

    /* Local variables */
    static doublereal seed;
    static integer i, j;
    static doublereal t0;
    extern doublereal SECOND();
    extern /* Subroutine */ int URAND(), GEMMW(), GEMUL3();

/* ----------------------------------------------------------------------- */
/* Initialixze A, B, and C */
/* ----------------------------------------------------------------------- */
    /* Parameter adjustments */
    --aux;
    c_dim1 = *n;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    b_dim1 = *n;
    b_offset = b_dim1 + 1;
    b -= b_offset;
    a_dim1 = *n;
    a_offset = a_dim1 + 1;
    a -= a_offset;

    /* Function Body */
    seed = (float)759150100.;
    i__1 = (*n << 1) * *n;
    URAND (&seed, &i__1, &a[a_offset]);

    /****** COMMENT OUT THIS LINE IF YOU ARE USING ESSL */
    seed = 0.0;

    i__1 = (*n << 1) * *n;
    URAND (&seed, &i__1, &b[b_offset]);
    i__1 = (*n << 1) * *n;
    URAND (&seed, &i__1, &c[c_offset]);
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
        i__2 = *n;
        for (i = 1; i <= i__2; ++i) {
            i__3 = i + j * a_dim1;
            i__4 = i + j * a_dim1;
            z__1.r = a[i__4].r - .5, z__1.i = a[i__4].i - .5;
            a[i__3].r = z__1.r, a[i__3].i = z__1.i;
            i__3 = i + j * b_dim1;
            i__4 = i + j * b_dim1;
            z__1.r = b[i__4].r - .5, z__1.i = b[i__4].i - .5;
            b[i__3].r = z__1.r, b[i__3].i = z__1.i;
            i__3 = i + j * c_dim1;
            i__4 = i + j * c_dim1;
            z__1.r = c[i__4].r - .5, z__1.i = c[i__4].i - .5;
            c[i__3].r = z__1.r, c[i__3].i = z__1.i;
        }
    }
/* ----------------------------------------------------------------------- */
/* Compute C = A * B */
/* ----------------------------------------------------------------------- */
    *t1 = -1.0;
    if (*which == 1) {
        t0 = SECOND();
        GEMMS (&a[a_offset], n, "N", &b[b_offset], n, "N", &c[c_offset], n, 
               n, n, n, &aux[1], naux, 1L, 1L);
        *t1 = SECOND() - t0;
    } else if (*which == 2) {
        t0 = SECOND();
        GEMM ("N", "N", n, n, n, &c_b22, &a[a_offset], n, &b[b_offset], n,
               &c_b23, &c[c_offset], n, 1L, 1L);
        *t1 = SECOND() - t0;
    } else if (*which == 3) {
        t0 = SECOND();
        GEMMW ("N", "N", n, n, n, &c_b22, &a[a_offset], n, &b[b_offset], n,
               &c_b23, &c[c_offset], n, &aux[1], naux, 1L, 1L);
        *t1 = SECOND() - t0;
    } else if (*which == 4) {
        t0 = SECOND();
        GEMUL3 (&a[a_offset], n, "N", &b[b_offset], n, "N", &c[c_offset], n, 
                n, n, n, &aux[1], naux, 1L, 1L);
        *t1 = SECOND() - t0;
    }
    return 0;
} /* doit_ */
