/******************************************************************************
 *
 * Last modified:    August 20, 1993
 *
 * This is the header file for gemmw.  It is known to work with ANSI C or
 * truly BSD 4.3 compatible C compilers.  If your compiler does not accept
 * this file, there is an older one, gemmwh.yuk, which you can try instead
 * by defining Use_GEMMWH_YUK, e.g.,
 *
 *      cc -c -DUse_GEMMWH_YUK gemmw.c
 *
 *****************************************************************************/
#ifdef Use_GEMMWH_YUK
#include "gemmwh.yuk"
#else
 
#include <stdio.h>
 
/******************************************************************************
 *
 * This defines the data types for this compilation.
 *
 * INT defaults to int.  On some machines INT needs to be long. 
 * Compiling this with a compile line flag defeats the default:
 *
 *      cc -c -DINT=long gemmw.c
 *
 * Floating point is another matter entirely.  There are 4 cases:
 *
 *   FLOAT_TYPE     FLOAT
 *   ----------     -----
 *   1              double          (the default)
 *   2              float
 *   3              dcmplx
 *   4              cmplx
 *
 * Compiling this with a compile line flag defeats the default:
 *
 *      cc -c -DFLOAT_TYPE=2 gemmw.c
 *
 * (This is for single precision real numbers.)
 *
 * The miserable number scheme is imposed by deficiencies in the design of the
 * C preprocessor, cpp.
 *
 * REAL is defined to be the floating point type corresponding to the complex
 * case.
 *
 *****************************************************************************/
 
#ifndef INT
#define INT int
#endif
 
#ifndef FLOAT_TYPE
#define FLOAT_TYPE 1
#endif
 
#if FLOAT_TYPE == 1
#define FLOAT   double
#define REAL    double
#endif
#if FLOAT_TYPE == 2
#define FLOAT   float
#define REAL    float
#endif
#if FLOAT_TYPE == 3
#define FLOAT   dcmplx
#define REAL    double
#endif
#if FLOAT_TYPE == 4
#define FLOAT   cmplx
#define REAL    float
#endif
 
/******************************************************************************
 *
 * These two definitions for complex and double complex may have to be
 * tailored to your machine or commented out.
 *
 *****************************************************************************/

typedef union { struct { float  __re, __im; } __data; }  cmplx;
typedef union { struct { double __re, __im; } __data; } dcmplx;

#define RE(x)   ((x).__data.__re)
#define IM(x)   ((x).__data.__im)

/******************************************************************************
 *
 * The minimum sized matrix that the Strassen algorithm will actually be used
 * on.  The standard matrix-matrix multiply algorithm is used for smaller
 * matrices.   For most machines, 32 is the right choice.  However, for
 * IBM mainframes (with vectors) and RISC System/6000's 192 is preferred.
 * On single processor Cray-2's, 128 is preferred.
 *
 *****************************************************************************/

#ifndef mindim

#ifdef _AIX
#define  mindim   192
#endif
#ifdef cray
#define  mindim   128
#endif
#ifdef __hpux
#define  mindim   96
#endif
#ifdef sparc
#define  mindim   96
#endif
#ifndef mindim
#define  mindim   32
#endif

#endif  /* mindim */

/******************************************************************************
 *
 * Actually define the subroutine names including the library routines
 * which WINOS calls.  There are three options depending on how the
 * Fortran and C compilers produce internal names, namely, for
 *
 *      subroutine foobar
 *          ...
 *      end
 *
 * a C program may have to reference foobar as
 *
 *      foobar      (default)
 *      foobar_     (Under)     
 *      FOOBAR      (Cap)       
 *
 * On most UNIX systems, the underscore is normal.  Compiling this with
 * a compile line flag defeats the default:
 *
 *      cc -c -DFortNames_Cap gemmw.c
 *
 * (This works on a Cray, for example.)
 *
 * A concatenation operator is needed (XCat).  It relies on another definition
 * (Cat) to do the macro expansions correctly.  The blame for this stupidity
 * belongs to the authors of the ANSI C standard.  The non-ANSI definition
 * relies on a bug in the C preprocessor introduced at Berkely (possibly
 * intentionally) many years ago.  Not all C compilers have this bug, so you
 * may have to use the GNU cpp to compile this correctly.  Check the man pages
 * on your system to see how to substitute one phase of the compiler.
 *
 *****************************************************************************/

#ifdef __STDC__
#define Cat(a,b) a ## b
#else
#define Cat(a,b) a/**/b
#endif
#define XCat(a,b) Cat(a,b)

#ifdef FortNames_Cap
#define NameIt(n,c)  c
#define NameItL(n,c) c
#else
#ifdef FortNames_Under
#define NameIt(n,c)  XCat(n,_)
#define NameItL(n,c) n
#else
#define NameIt(n,c)  n
#define NameItL(n,c) n
#endif
#endif /* of Fortran naming convention */

/******************************************************************************
 *
 * Name the routines based on the definition of FLOAT.  The first letter in
 * the BLAS definition is used here.  To perform weird arithmetic tricks in
 * the complex case, the corresponding real first letter is also needed.
 *
 *****************************************************************************/

#if FLOAT_TYPE == 1             /* Double precision real */
#define BLAS_LETTER   NameItL(d,D)
#define BLAS_LETTER_R NameItL(d,D)
#endif
#if FLOAT_TYPE == 2             /* Single precision real */
#define BLAS_LETTER   NameItL(s,S)
#define BLAS_LETTER_R NameItL(s,S)
#endif
#if FLOAT_TYPE == 3             /* Double precision complex */
#define BLAS_LETTER   NameItL(z,Z)
#define BLAS_LETTER_R NameItL(d,D)
#endif
#if FLOAT_TYPE == 4             /* Single precision complex */
#define BLAS_LETTER   NameItL(c,C)
#define BLAS_LETTER_R NameItL(s,S)
#endif /* First letter of names */

#define GEMMB       XCat(BLAS_LETTER,NameIt(gemmb,GEMMW))
#define GEMMW       XCat(BLAS_LETTER,NameIt(gemmw,GEMMW))
#define GEMMW3      XCat(BLAS_LETTER,NameIt(gemmw3,GEMMW3))
#define WINOS       XCat(BLAS_LETTER,winos)
#define GEMMW_R     XCat(BLAS_LETTER_R,NameIt(gemmw,GEMMW))

/******************************************************************************
 *
 * Definitions used in classical complex matrix multiplication with the
 * faster algorithm.
 *
 *****************************************************************************/

#if defined(Use_GEMUL3) && ( FLOAT_TYPE == 3 || FLOAT_TYPE == 4 )
#define MATMUL_name     XCat(BLAS_LETTER,NameIt(gemul3,GEMUL3)) 
#define MATMUL(a,lda,forma,b,ldb,formb,c,ldc,l,m,n,aux,naux) \
        MATMUL_name (a,lda,forma,b,ldb,formb,c,ldc,l,m,n,aux,naux)
#endif

/******************************************************************************
 *
 * Definitions used by the standard BLAS or IBM ESSL routines.
 *
 *****************************************************************************/

#if defined(Library_BLAS) || defined(Library_ESSL)
#define VCOPY_name      XCat(BLAS_LETTER,NameIt(copy,COPY))
#define VAXPY_name      XCat(BLAS_LETTER,NameIt(axpy,AXPY))
#define VCOPY_name_R    XCat(BLAS_LETTER_R,NameIt(copy,COPY))
#define VAXPY_name_R    XCat(BLAS_LETTER_R,NameIt(axpy,AXPY))
#endif

#if defined(Library_BLAS)
#define VYAX_name       XCat(BLAS_LETTER,NameIt(yax,YAX))
#define MATADD_name     XCat(BLAS_LETTER,NameIt(geadd,GEADD))
#define MATSUB_name     XCat(BLAS_LETTER,NameIt(gesub,GESUB))
#ifndef MATMUL
#define MATMUL_name     XCat(BLAS_LETTER,NameIt(gemm,GEMM)) 
#endif
#endif

#if defined(Library_ESSL)
#define VYAX_name       XCat(BLAS_LETTER,NameIt(yax,YAX)) 
#define MATADD_name     XCat(BLAS_LETTER,NameIt(geadd,GEADD)) 
#define MATSUB_name     XCat(BLAS_LETTER,NameIt(gesub,GESUB)) 
#ifndef MATMUL
#define MATMUL_name     XCat(BLAS_LETTER,NameIt(gemul,GEMUL)) 
#endif
#endif

#if defined(Library_BLAS) || defined(Library_ESSL)
#define VCOPY(n,x,incx,y,incy)\
        VCOPY_name (n,x,incx,y,incy)
#define VAXPY(n,alpha,x,incx,y,incy)\
        VAXPY_name (n,alpha,x,incx,y,incy)
#define VCOPY_R(n,x,incx,y,incy)\
        VCOPY_name_R (n,x,incx,y,incy)
#define VAXPY_R(n,alpha,x,incx,y,incy)\
        VAXPY_name_R (n,alpha,x,incx,y,incy)
#define VYAX(n,alpha,x,incx,y,incy) \
        VYAX_name (n,alpha,x,incx,y,incy)
#define MATADD(a,lda,forma,b,ldb,formb,c,ldc,m,n) \
        MATADD_name (a,lda,forma,b,ldb,formb,c,ldc,m,n)
#define MATSUB(a,lda,forma,b,ldb,formb,c,ldc,m,n) \
        MATSUB_name (a,lda,forma,b,ldb,formb,c,ldc,m,n)
#endif

#ifndef MATMUL
#if defined(Library_BLAS)
#define MATMUL(a,lda,forma,b,ldb,formb,c,ldc,l,m,n,aux,naux) \
        MATMUL_name (forma,formb,l,n,m,pos1,a,lda,b,ldb,zero,c,ldc)
#endif

#if defined(Library_ESSL)
#define MATMUL(a,lda,forma,b,ldb,formb,c,ldc,l,m,n,aux,naux) \
        MATMUL_name (a,lda,forma,b,ldb,formb,c,ldc,l,m,n)
#endif
#endif

/******************************************************************************
 *
 * Definitions used by NAG routines (Mark 14).
 * (My NAG guide tells me that if routine X ends in F it is double
 *  precision and that the single precision version ends in E.  I
 *  have found no copy of NAG on any machine that actually does this.
 *  They all have 2 copies of the library, one double and one single
 *  precision with the same names (ending in F).  You figure it.)
 *
 *****************************************************************************/

#if defined(Library_NAG)

#if FLOAT_TYPE == 1 || FLOAT_TYPE == 2  /* Real */
#define VCOPY_name      NameIt(f06eff,F06EFF)
#define VAXPY_name      NameIt(f06ecf,F06ECF)
#define VCOPY_name_R    NameIt(f06eff,F06EFF)
#define VAXPY_name_R    NameIt(f06ecf,F06ECF)
#define VYAX_name       NameIt(f06fdf,F06FDF)
#define MATADD_name     NameIt(f01ctf,F01CTF)
#define MATSUB_name     NameIt(f01ctf,F01CTF)
#define MATMUL_name     NameIt(f06yaf,F06YAF)
#endif
#if FLOAT_TYPE == 3 || FLOAT_TYPE == 4  /* Complex */
#define VCOPY_name      NameIt(f06gff,F06GFF)
#define VAXPY_name      NameIt(f06gcf,F06GCF)
#define VCOPY_name_R    NameIt(f06eff,F06EFF)
#define VAXPY_name_R    NameIt(f06ecf,F06ECF)
#define VYAX_name       NameIt(f06hdf,F06HDF)
#define MATADD_name     NameIt(f01cwf,F01CWF)
#define MATSUB_name     NameIt(f01cwf,F01CWF)
#ifndef MATMUL
#define MATMUL_name     NameIt(f06zaf,F06ZAF)
#endif
#endif
 
#define VCOPY(n,x,incx,y,incy)\
        VCOPY_name (n,x,incx,y,incy)
#define VAXPY(n,alpha,x,incx,y,incy)\
        VAXPY_name (n,alpha,x,incx,y,incy)
#define VCOPY_R(n,x,incx,y,incy)\
        VCOPY_name_R (n,x,incx,y,incy)
#define VAXPY_R(n,alpha,x,incx,y,incy)\
        VAXPY_name_R (n,alpha,x,incx,y,incy)
#define VYAX(n,alpha,x,incx,y,incy) \
        VYAX_name (n,alpha,x,incx,y,incy)
#define MATADD(a,lda,forma,b,ldb,formb,c,ldc,m,n) \
        MATADD_name\
            (forma,formb,m,n,pos1,a,lda,pos1,b,ldb,c,ldc,&ifail)
#define MATSUB(a,lda,forma,b,ldb,formb,c,ldc,m,n) \
        MATSUB_name\
            (forma,formb,m,n,pos1,a,lda,neg1,b,ldb,c,ldc,&ifail)
#ifndef MATMUL
#define MATMUL(a,lda,forma,b,ldb,formb,c,ldc,l,m,n,aux,naux) \
        MATMUL_name\
            (forma,formb,l,n,m,pos1,a,lda,b,ldb,zero,c,ldc)
#endif
 
#endif /* Library_NAG */

#endif /* Use_GEMMWH_YUK */
