      PROGRAM STEST
C
C
C     THIS PROGRAM, DATED 13 SEPTEMBER 1993, IS A
C     TEST EXAMPLE FOR THE
C     SINGLE PRECISION REAL IMPLEMENTATION
C     OF THE MIXED BLOCK ELIMINATION METHOD FOR WIDER BORDERS
C     CALLED BEMW AND DUE TO W. GOVAERTS AND J. D. PRYCE.
C
C     SUBROUTINES CALLED ARE:
C
C            1. THE FOUR CORE BEMW SUBROUTINES FOR THE
C               SINGLE PRECISION REAL IMPLEMENTATION
C               OF BEMW, NAMELY
C                    SBEMSO
C                    SBEMFA
C                    SBEM1
C                    SBEM2
C               THE USER SHOULD NOT CHANGE THEM IN ANY WAY
C  
C            2. THE SUBROUTINES SSA1, SSAST1 
C                    (CONTAINED IN THIS FILE)
C              
C            3. THE BLAS SUBROUTINES SAXPY, SCOPY AND 
C               FUNCTION SDOT
C
C     THE PROBLEM IS TO SOLVE A LINEAR SYSTEM OF THE FORM
C
C                 ( A   B )
C                 (       )  Z = H
C                 ( C   D ) 
C    
C     
C     HERE A IS A SQUARE MATRIX OF ORDER 2 x 2 SUCH THAT
C     SOLVERS FOR BOTH A AND AT (=Atranspose) ARE GIVEN. ONLY
C     THESE SOLVERS ARE USED IN THE CODE, A IS NEVER
C     REFERRED TO.
C     B , C , D ARE 2 x 2, 2 x 2 AND 2 x 2 RESPECTIVELY
C     Z AND H ARE 4 - DIMENSIONAL COLUMN VECTORS.
C 
C                                                                           
      PARAMETER (N=2,M=2)


      REAL BDATA(1:N+M,1:M,0:1)
      REAL VDATA(1:N+M,1:M,0:1)
      
      REAL WORK(N+M),H(N+M)

      REAL WORK1(M)
      REAL TOL
      INTEGER IFLAG,IRETN,IREP

C     ALPHA, BETA ARE TWO PARAMETERS THAT CAN BE SET FOR TESTING
C     PURPOSES

      REAL ALPHA,BETA,DIFF

C
C     IN THIS EXAMPLE WE SOLVE THE SYSTEM
C    
C                     ( ALPHA 1 1 1 )     ( ALPHA+9)
C                     ( BETA  1 3 1 )     ( BETA+15)
C                     (             ) Z = (        )
C                     (   1   1 1 3 )     (   18   )
C                     (   1   2 3 4 )     (   30   )
C     
C     ,APPLYING SBEMW WITH N=2, M=2
C    
C     REMARK THAT THE EXACT SOLUTION IS ALWAYS (1,2,3,4)
C     AND THAT A IS SINGULAR IF AND ONLY IF ALPHA=BETA
C    
C     FOR ALPHA=BETA=1, A IS SINGULAR BUT THE FULL 4 BY 4 MATRIX 
C     IS NONSINGULAR
C
C     OUTPUT IS IN THE FILE BEMOUT 
C
C   
C
C     FILL IN THE DATA OF B, C, D IN BDATA
C
C
      DATA BDATA / 1.0, 3.0, 1.0, 1.0E+20,
     *             1.0, 1.0, 3.0, 4.0,
     *             1.0, 1.0, 1.0, 1.0E+20,
     *             1.0, 2.0, 3.0, 4.0 /

      OPEN(1,FILE='BEMOUT')
      ALPHA=2.0
      BETA=0.0

      DO 99 I=1,40

      ALPHA=1.0+(ALPHA-1.0)/2.0
      BETA=1.0+(BETA-1.0)/2
C
C
C     WITH INCREASING I ALPHA AND BETA TEND TO 1.0, I.E. TO
C     A SITUATION WITH A EXACTLY SINGULAR.
C     REMARK IN THE OUTPUT THAT
C        1) THE ACCURACY OF THE COMPUTED SOLUTION IS
C           UNAFFECTED BY THE ILL-CONDITIONING OF A
C        2) FAILURE OCCURS ONLY IN CASES THAT ARE REPORTED BY
C           IREP .NE. 0. THIS IS THE LIMIT CASE HERE
C           BECAUSE NOT ONLY A BUT ALSO ITS 1-BORDERED
C           EXTENSION
C                    (1  1  1)
C                    (1  1  3)
C                    (1  1  1)
C           IS SINGULAR.
C
C
      
      WRITE(1,*) 'ALPHA,BETA',ALPHA,BETA  
      H(1)=9.0+ALPHA
      H(2)=15.0+BETA
      H(3)=18.0
      H(4)=30.0

      TOL=1.0E-10
      IREP=0
      IFLAG=1
      IRETN=1

200   IF (IFLAG .NE. 0) THEN
      
      CALL SBEMFA(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1,TOL)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO WORK(1:N)
C
C
      CALL SSA1(WORK,ALPHA,BETA)

      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO WORK(1:N)
C
C
      CALL SSAST1(WORK,ALPHA,BETA)

      ENDIF
      GOTO 200
      ENDIF

      
C     SET IFLAG=1 TO SOLVE WITH THE BORDERED MATRIX
C     (WITH IFLAG=-1 WE SOLVE WITH ITS TRANSPOSE)
C 
      IFLAG=1
      CALL SBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO H
C
C
      CALL SSA1(H,ALPHA,BETA)

      
      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO H
C
C
      CALL SSAST1(H,ALPHA,BETA)

      ELSE
      WRITE (*,*) 'ERROR IN CALL TO SBEMSO'
      STOP
      ENDIF
      CALL SBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)

      DIFF=ALPHA - BETA
      WRITE (1,*) 'ALPHA - BETA',DIFF
      WRITE (1,*) 'SOLUTION VECTOR :',H
      WRITE (1,*) 'IREP :' ,IREP
99    CONTINUE
      END

      SUBROUTINE SSA1(WORK,ALPHA,BETA)
   
      REAL WORK(1),ALPHA,BETA
C
C     THIS IS THE SOLVER FOR A.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     A * X = WORK.
C
      REAL HELP,SHELP
      HELP=BETA-ALPHA
      IF (ABS(HELP) .LT. 1.0E-7) HELP=1.0E-7

      SHELP=WORK(1)
      WORK(1)=(WORK(2)-WORK(1))/HELP
      WORK(2)=SHELP-ALPHA*WORK(1)
      
      RETURN
      END

      SUBROUTINE SSAST1(WORK,ALPHA,BETA)
   
      REAL WORK(1),ALPHA,BETA
C
C     THIS IS THE SOLVER FOR At.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     At * X = WORK.
C
      REAL HELP,SHELP
      HELP=BETA-ALPHA
      IF (ABS(HELP) .LT. 1.0E-7) HELP=1.0E-7
      SHELP=WORK(2)
      WORK(2)=(WORK(1)-ALPHA*WORK(2))/HELP
      WORK(1)=SHELP-WORK(2)

      RETURN
      END
