      PROGRAM SSBEDR
C
C
C     THIS PROGRAM, DATED 13 SEPTEMBER 1993, IS A DRIVER
C     PROGRAM AND TEST EXAMPLE FOR AN IMPLEMENTATION
C     FOR SINGLE PRECISION REAL SYMMETRIC MATRICES
C     OF THE MIXED BLOCK ELIMINATION METHOD FOR WIDER BORDERS
C     CALLED BEMW AND DUE TO W. GOVAERTS AND J. D. PRYCE.
C
C
C     SUBROUTINES CALLED ARE:
C
C            1. THE FOUR CORE BEMW SUBROUTINES FOR THE
C               SINGLE PRECISION REAL IMPLEMENTATION
C               OF SBEMW, NAMELY
C                    SSBEMS
C                    SSBEMF
C                    SSBEM1
C                    SSBEM2
C               THE USER SHOULD NOT CHANGE THEM IN ANY WAY
C  
C            2. THE SUBROUTINE SSSA 
C               THIS SUBROUTINE MUST BE PROVIDED BY THE USER AND SOLVE 
C               LINEAR SYSTEMS WITH A REAL SYMMETRIC MATRIX A.
C 
C            3. THE BLAS SUBROUTINES SAXPY, SCOPY AND SDOT
C
C
C     FOR A DESCRIPTION OF THE ALGORITHM SEE 

C     REFERENCES:
C     W. GOVAERTS, STABLE SOLVERS AND BLOCK ELIMINATION FOR
C     BORDERED SYSTEMS, SIAM J. MATRIX ANAL. APPL. 
C     12 (1991) 469-483 
C     W. GOVAERTS AND J.D. PRYCE, MIXED BLOCK ELIMINATION FOR
C     LINEAR SYSTEMS WITH WIDER BORDERS, IMA J. NUM. ANAL.
C     13 (1993) 161-180.
C
C     IT IS WRITTEN IN REVERSE COMMUNICATION MODE, WHICH MEANS
C     THAT THE CHOICE OF THE SOLVER FOR A BASIC MATRIX A 
C     IS ENTIRELY LEFT TO THE USER AND A COLLECTION
C     OF SUBROUTINES IS GIVEN THAT ALLOWS THE CONSTRUCTION OF
C     SOLVERS FOR SYMMETRIC BORDERED FORMS OF A.
C
C     THE PROBLEM UNDER CONSIDERATION IS THE SOLUTION OF A LINEAR 
C     SYSTEM OF THE FORM
C
C                 ( A     B )
C                 (         )  Z = H
C                 ( B^T   D ) 
C    
C     WHERE A AND D ARE SYMMETRIC.
C     HERE A IS A SQUARE MATRIX OF ORDER N x N SUCH THAT
C     A SOLVER FOR A IS GIVEN. ONLY
C     THIS SOLVER IS USED IN THE CODE, A IS NEVER
C     REFERRED TO.
C     B , D ARE N x M AND M x M RESPECTIVELY
C     Z AND H ARE (N + M) -DIMENSIONAL COLUMN VECTORS.
C 
C     USE OF THE VARIABLES
C     --------------------
C     N : DIMENSION OF THE BASIC MATRIX A
C         UNCHANGED ON EXIT
C     M : NUMBER OF BORDERING ROWS AND COLUMNS
C         UNCHANGED ON EXIT
C     BDATA : REAL DIMENSION(1:N+M,1:M)
C             CONTAINS THE INFORMATION ON B, D.
C             ON ENTRY :
C     
C             BDATA(1:N,1:M)=B
C             BDATA(N+1:N+M,1:M)=D
C
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF D
C                  ARE NOT REFERRED TO.
C
C             ON EXIT : UNCHANGED
C     VDATA : REAL DIMENSION(1:N+M,1:M)
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT  : CONTAINS PROCESSED DATA FROM BDATA
C                        
C             VDATA IS FILLED IN A LOOP OF CALLS TO SSBEMF ALTERNATED
C             WITH APPLICATIONS OF THE SOLVER FOR A. 
C             THESE DATA ARE SUBSEQUENTLY USED BY SSBEMF TO SOLVE
C             LINEAR SYSTEMS WITH
C              
C                           (  A  B )
C                           (       )
C                           ( B^T D )
C        
C     WORK :  REAL WORK ARRAY OF DIMENSION N+M TO BE DECLARED BY THE
C             USER.
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT : IS FREE FOR OTHER USES AFTER THE
C             COMPLETION OF ALL CALLS TO SSBEMF   
C     WORK1 : REAL WORK ARRAY OF DIMENSION M
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT :IS FREE FOR OTHER USES AFTER ALL CALLS
C                      TO SSBEMF AND SSBEMS ARE FINISHED       
C     H     : ON ENTRY : CONTAINS THE RIGHT - HAND SIDE
C                         REAL (N+M) - VECTOR OF THE SYSTEM TO BE SOLVED
C             ON EXIT  : CONTAINS THE SOLUTION VECTOR
C     IFLAG : INTEGER VARIABLE THAT DIRECTS THE STREAM OF CALLS
C             TO SSBEMF AND SSBEMS. 
C             IS TO BE SET EQUAL TO 1 BEFORE FIRST CALLING SSBEMF 
C             AND AGAIN BEFORE FIRST CALLING SSBEMS.
C     IRETN : INTEGER VARIABLE THAT DIRECTS THE STREAM OF 
C             CALLS TO SSBEMF AND APPLICATIONS OF THE SOLVERS.
C             IS TO BE SET EQUAL TO 1 BEFORE FIRST CALLING SSBEMF.
C     TOL :   REAL VARIABLE INTRODUCED TO AVOID DIVIDING BY
C             A SCHUR COMPLEMENT EQUAL TO ZERO. IF A SCHUR
C             COMPLEMENT IS SMALLER THAN TOL IN ABSOLUTE VALUE,
C             IT IS REPLACED BY TOL.
C     IREP :  INTEGER VARIABLE INTRODUCED TO REPORT ON        
C             THE USE OF TOL. 
C             ON ENTRY : HAS TO BE ZERO
C             ON EXIT : 0 IF NO SCHUR COMPLEMENT WAS REPLACED.
C                     : +K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO CROUT DECOMPOSITION
C                          (APPEARING IN VDATA(N+K,K)) WAS
C                          FIRST TO BE CHANGED.
C                     
C             AN EXIT VALUE IREP DIFFERENT FROM ZERO INDICATES
C             THAT THE ALGORITHM MAY HAVE FAILED AND HELPS TO
C             DETECT CERTAIN PATHOLOGICAL CASES.
C
C     THE USER MUST:
C             -DECLARE THE ABOVE ARRAYS AND VARIABLES
C             -ASSIGN AN APPROPRIATE VALUE TO TOL (WE RECOMMEND
C                   ROUGHLY THE LARGEST ABSOLUTE VALUE OF THE ENTRIES
C                   OF A , B, C, D MULTIPLIED WITH THE MACHINE PRECISION)
C             -SET IREP=0
C             -FILL IN THE DATA IN B, D IN THE APPROPRIATE
C                   LOCATIONS OF BDATA
C             -PROVIDE THE SOLVER FOR A
C             -SET IFLAG=1 BEFORE CALLING SSBEMS
C
C     NOTE :
C     -------------
C     ONCE THE LOOP OF CALLS TO SSBEMF IS FINISHED
C     (WHICH REQUIRES M APPLICATIONS OF THE SOLVER FOR A),
C     THE SOLUTION OF A LINEAR SYSTEM WITH THE BORDERED MATRIX
C     REQUIRES ONE APPLICATION OF THE SOLVER PER RIGHT - HAND 
C     SIDE VECTOR.
C
C                                                                           
      PARAMETER (N=2,M=2)

C     REAL A(N,N)

      REAL BDATA(1:N+M,1:M)
      REAL VDATA(1:N+M,1:M)
      
      REAL WORK(N+M),H(N+M)

      REAL WORK1(M)
      REAL TOL
      INTEGER IFLAG,IRETN,IREP
      REAL ALPHA
      
C
C     IN THIS EXAMPLE WE SOLVE THE SYSTEM
C    
C                     (   1   ALPHA 1 1 )     ( 8 + 2 * ALPHA)
C                     ( ALPHA   1   3 1 )     (15 +  ALPHA   )
C                     (                 ) Z = (              )
C                     (   1     3   1 3 )     (22            )
C                     (   1     1   3 4 )     (28            )
C     ,APPLYING BEMW WITH N=2, M=2.
C
C
C     ALPHA IS A PARAMETER IN THIS DRIVING PROGRAM. FOR
C     ALPHA=0, A IS THE IDENTITY MATRIX; FOR ALPHA NEAR 1
C     A IS ILL - CONDITIONED; FOR ALPHA=1, A IS EXACTLY
C     SINGULAR BUT THE BORDERED EXTENSION IS STILL
C     WELL - CONDITIONED.
C     IF ALPHA IS CHANGED BOTH IN THE MAIN ROUTINE AND
C     IN THE SOLVER SUBROUTINE SSSA, THEN THE EXACT SOLUTION
C     VECTOR IS ALWAYS (1,2,3,4)^T.
C
C
C     FILL IN THE DATA OF B, C, D IN BDATA
C
C
      DATA BDATA / 1.0, 3.0, 1.0, 1.0E+20,
     *             1.0, 1.0, 3.0, 4.0 /

      DATA H / 8.0, 15.0, 22.0, 28.0 /
      
      ALPHA=0.999999999
      H(1)=H(1)+2.0*ALPHA
      H(2)=H(2)+ALPHA
      WRITE (*,*) 'RIGHT - HAND SIDE :',H

      TOL=1.0E-7
      IREP=0
      IFLAG=1
      IRETN=1

200   IF (IFLAG .NE. 0) THEN
      
      CALL SSBEMF(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1,TOL)

      IF (IFLAG .NE. 0) THEN
C
C
C     APPLY SOLVER FOR A TO WORK(1:N)
C
C
      CALL SSSA(WORK)
      ENDIF

      GOTO 200
      ENDIF

      
      IFLAG=1
      CALL SSBEMS(IFLAG,N,M,BDATA,VDATA,H,WORK1)

      IF (IFLAG .NE. 0) THEN
C
C
C     APPLY SOLVER FOR A TO H
C
C
      CALL SSSA(H)
      ELSE
      WRITE (*,*) 'ERROR IN CALL TO SSBEMS'
      STOP
      ENDIF
      CALL SSBEMS(IFLAG,N,M,BDATA,VDATA,H,WORK1)
      
      
      WRITE (*,*) 'SOLUTION VECTOR :',H
      WRITE (*,*) 'IREP :' ,IREP
      END


      SUBROUTINE SSBEMS(IFLAG,N,M,BDATA,VDATA,WORK,WORK1)

      INTEGER IFLAG,N,M,MP1
      REAL BDATA(1:N+M,1:M),VDATA(1:N+M,1:M),WORK(1),WORK1(1)

      MP1=M+1
      IF (IFLAG .NE. 1) GOTO 100      
      CALL SSBEM1(N,M,MP1,BDATA(1,1),VDATA(1,1),WORK1,WORK)
      IFLAG=2
      RETURN
100   IF (IFLAG .NE. 2) GOTO 400
      CALL SSBEM2(N,M,MP1,BDATA(1,1),VDATA(1,1),WORK1,WORK)
      IFLAG=0
      RETURN
400   WRITE (*,*) 'ILLEGAL CALL TO SSBEMS'
      STOP
      END


      SUBROUTINE SSBEMF(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1, 
     *                  TOL)

      INTEGER IFLAG,IRETN,IREP,K,N,M,NPM

      REAL BDATA(1:N+M,1:M),VDATA(1:N+M,1:M),WORK(1),WORK1(1),
     *                          TOL
      REAL DELTA
      SAVE K

      NPM=N+M
      GOTO (100,200) IRETN
      WRITE (*,*) 'ILLEGAL CALL TO SSBEMF'
      STOP
100   K=1

150   IF (K .GT. M) GOTO 400

      CALL SCOPY(NPM,BDATA(1,K),1,WORK,1)
      CALL SSBEM1(N,M,K,BDATA(1,1),VDATA(1,1),WORK1,WORK)
      IRETN=2
      IFLAG=1
      RETURN

200   CALL SSBEM2(N,M,K,BDATA(1,1),VDATA(1,1),WORK1,WORK)
      CALL SCOPY(NPM,WORK,1,VDATA(1,K),1)
      DELTA=BDATA(N+K,K)-SDOT(N+K-1,BDATA(1,K),1
     *,VDATA(1,K),1)
      IF (ABS(DELTA) .LT. TOL) THEN
      DELTA=TOL
      IF (IREP .EQ. 0) IREP = K
      ENDIF
      VDATA(N+K,K)=DELTA

      CALL SCOPY(NPM,BDATA(1,K),1,WORK,1)
      CALL SSBEM1(N,M,K,BDATA(1,1),VDATA(1,1),WORK1,WORK)
       
      K=K+1
      GOTO 150

400   IFLAG=0
      IRETN=0
      END

 


      SUBROUTINE SSBEM1(N,M,J,B,VSTAR,WORK1,WORK)

      INTEGER N,M,J,K
      REAL B(1),VSTAR(1),WORK1(1),WORK(1),STEMP

      DO 100 K=J-1,1,-1
      STEMP=(WORK(N+K)-SDOT(N+K-1,WORK,1,VSTAR(1+(N+M)*(K-1)),1))/
     *VSTAR((N+M)*(K-1)+N+K)
      CALL SAXPY(N+K,-STEMP,B(1+(N+M)*(K-1)),1,WORK,1)
      WORK1(K)=STEMP
100   CONTINUE

      END     

      SUBROUTINE SSBEM2(N,M,J,BSTAR,V,WORK1,WORK)

      INTEGER N,M,J,K
      REAL BSTAR(1),V(1),WORK1(1),WORK(1),STEMP

      DO 100 K=1,J-1
      STEMP=(WORK(N+K)-SDOT(N+K-1,WORK,1,BSTAR(1+(N+M)*(K-1)),1))/
     *V((N+M)*(K-1)+N+K)
      CALL SAXPY(N+K-1,-STEMP,V(1+(N+M)*(K-1)),1,WORK,1)
      WORK(N+K)=WORK1(K)+STEMP
100   CONTINUE

      END

      SUBROUTINE SSSA(WORK)
      INTEGER N
      REAL WORK(1)
C
C     THIS IS THE SOLVER FOR A.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     A * X = WORK.
C
      REAL ALPHA
      REAL HLP
      ALPHA=0.999999999
      HLP=1.0-ALPHA*ALPHA
      IF (HLP .EQ. 0) HLP=1.0E-7
      WORK(2)=(WORK(2)-ALPHA*WORK(1))/HLP
      WORK(1)=WORK(1)-ALPHA*WORK(2)      
      RETURN
      END
      
      REAL FUNCTION SDOT(N, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     FORMS THE DOT PRODUCT OF TWO VECTORS.
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1), STEMP
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      STEMP = 0.0E0
      SDOT = 0.0E0
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        STEMP = STEMP + SX(IX)*SY(IY)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      SDOT = STEMP
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,5)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        STEMP = STEMP + SX(I)*SY(I)
   30 CONTINUE
      IF (N.LT.5) GO TO 60
   40 MP1 = M + 1
      DO 50 I=MP1,N,5
        STEMP = STEMP + SX(I)*SY(I) + SX(I+1)*SY(I+1) + SX(I+2)*SY(I+2)
     *   + SX(I+3)*SY(I+3) + SX(I+4)*SY(I+4)
   50 CONTINUE
   60 SDOT = STEMP
      RETURN
C
C***********************************************************************
C
      END
      SUBROUTINE SAXPY(N, SA, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     CONSTANT TIMES A VECTOR PLUS A VECTOR.
C     USES UNROLLED LOOP FOR INCREMENTS EQUAL TO ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1), SA
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      IF (N.LE.0) RETURN
      IF (SA.EQ.0.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        SY(IY) = SY(IY) + SA*SX(IX)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,4)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        SY(I) = SY(I) + SA*SX(I)
   30 CONTINUE
      IF (N.LT.4) RETURN
   40 MP1 = M + 1
      DO 50 I=MP1,N,4
        SY(I) = SY(I) + SA*SX(I)
        SY(I+1) = SY(I+1) + SA*SX(I+1)
        SY(I+2) = SY(I+2) + SA*SX(I+2)
        SY(I+3) = SY(I+3) + SA*SX(I+3)
   50 CONTINUE
      RETURN
C
C***********************************************************************
C
      END


      SUBROUTINE SCOPY(N, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     COPIES A VECTOR, X, TO A VECTOR, Y.
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO 1.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1)
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        SY(IY) = SX(IX)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,7)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        SY(I) = SX(I)
   30 CONTINUE
      IF (N.LT.7) RETURN
   40 MP1 = M + 1
      DO 50 I=MP1,N,7
        SY(I) = SX(I)
        SY(I+1) = SX(I+1)
        SY(I+2) = SX(I+2)
        SY(I+3) = SX(I+3)
        SY(I+4) = SX(I+4)
        SY(I+5) = SX(I+5)
        SY(I+6) = SX(I+6)
   50 CONTINUE
      RETURN
C
C***********************************************************************
C
      END
