      PROGRAM SBEDR
C
C
C     THIS PROGRAM, DATED 13 SEPTEMBER 1993, IS A
C     DRIVER PROGRAM AND TEST EXAMPLE FOR THE
C     SINGLE PRECISION REAL IMPLEMENTATION
C     OF THE MIXED BLOCK ELIMINATION METHOD FOR WIDER BORDERS
C     CALLED BEMW AND DUE TO W. GOVAERTS AND J. D. PRYCE.
C
C     SUBROUTINES CALLED ARE:
C
C            1. THE FOUR CORE BEMW SUBROUTINES FOR THE
C               SINGLE PRECISION REAL IMPLEMENTATION
C               OF BEMW, NAMELY
C                    SBEMSO
C                    SBEMFA
C                    SBEM1
C                    SBEM2
C               THE USER SHOULD NOT CHANGE THEM IN ANY WAY
C  
C            2. THE SUBROUTINES SSA, SSASTA 
C               THESE MUST BE PROVIDED BY THE USER AND SOLVE 
C               LINEAR SYSTEMS WITH A MATRIX A AND ITS
C               TRANSPOSE
C 
C            3. THE BLAS SUBROUTINES SAXPY, SCOPY AND 
C               FUNCTION SDOT
C
C
C     FOR A DESCRIPTION OF THE ALGORITHM SEE 
C     
C     W. GOVAERTS, STABLE SOLVERS AND BLOCK ELIMINATION FOR
C     BORDERED SYSTEMS, SIAM J. MATRIX ANAL. APPL. 
C     12 (1991) 469-483 
C     W. GOVAERTS AND J.D. PRYCE, MIXED BLOCK ELIMINATION FOR
C     LINEAR SYSTEMS WITH WIDER BORDERS, IMA J. NUM. ANAL.
C     13 (1993) 161-180.
C   
C     THIS DRIVER PROGRAM IS WRITTEN IN REVERSE 
C     COMMUNICATION MODE, WHICH MEANS
C     THAT THE CHOICE OF THE SOLVER FOR A BASIC MATRIX A 
C     AND ITS TRANSPOSE IS ENTIRELY LEFT TO THE USER AND A COLLECTION
C     OF SUBROUTINES IS GIVEN THAT ALLOWS THE CONSTRUCTION OF
C     SOLVERS FOR BORDERED FORMS OF A AND ITS TRANSPOSE.
C
C     THE PROBLEM UNDER CONSIDERATION IS THE SOLUTION OF A LINEAR 
C     SYSTEM OF THE FORM
C
C                 ( A   B )
C                 (       )  Z = H
C                 ( C   D ) 
C    
C     AND THAT OF A LINEAR SYSTEM WITH THE TRANSPOSED MATRIX.
C     HERE A IS A SQUARE MATRIX OF ORDER N x N SUCH THAT
C     SOLVERS FOR BOTH A AND AT (=Atranspose) ARE GIVEN. ONLY
C     THESE SOLVERS ARE USED IN THE CODE, A IS NEVER
C     REFERRED TO.
C     B , C , D ARE N x M, M x N AND M x M RESPECTIVELY
C     Z AND H ARE (N + M) -DIMENSIONAL COLUMN VECTORS.
C 
C     USE OF THE VARIABLES
C     --------------------
C     N : DIMENSION OF THE BASIC MATRIX A
C         UNCHANGED ON EXIT
C     M : NUMBER OF BORDERING ROWS AND COLUMNS
C         UNCHANGED ON EXIT
C     BDATA : REAL DIMENSION(1:N+M,1:M,0:1)
C             CONTAINS THE INFORMATION ON B, C, D.
C             ON ENTRY :
C     
C             BDATA(1:N,1:M,0)=B
C             BDATA(N+1:N+M,1:M,0)=D
C
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF D
C                  ARE NOT REFERRED TO.
C
C             BDATA(1:N,1:M,1)=transpose OF C
C             BDATA(N+1:N+M,1:M,1)=transpose OF D 
C             
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF 
C                  THE transpose of D
C                  ARE NOT REFERRED TO.
C
C             REMARK THAT THE DIAGONAL OF D IS STORED TWICE.  
C    
C             ALSO M*(M-1) LOCATIONS IN BDATA ARE NEVER REFERRED TO
C             IF M>2.
C
C             ON EXIT : UNCHANGED
C     VDATA : REAL DIMENSION(1:N+M,1:M,0:1)
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT  : CONTAINS PROCESSED DATA FROM BDATA
C                        
C             VDATA IS FILLED IN A LOOP OF CALLS TO SBEMFA ALTERNATED
C             WITH APPLICATIONS OF THE SOLVERS FOR A AND AT. 
C             THESE DATA ARE SUBSEQUENTLY USED BY SBEMSO TO SOLVE
C             LINEAR SYSTEMS WITH
C              
C                           ( A B )
C                           (     )
C                           ( C D )
C             AND ITS TRANSPOSE.
C     WORK :  REAL WORK ARRAY OF DIMENSION N+M TO BE DECLARED BY THE
C             USER.
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT : IS FREE FOR OTHER USES AFTER THE
C             COMPLETION OF ALL CALLS TO SBEMFA   
C     WORK1 : REAL WORK ARRAY OF DIMENSION M
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT :IS FREE FOR OTHER USES AFTER ALL CALLS
C                      TO SBEMFA AND SBEMSO ARE FINISHED       
C     H     : ON ENTRY : CONTAINS THE RIGHT - HAND SIDE
C                         REAL (N+M) - VECTOR OF THE SYSTEM TO BE SOLVED
C             ON EXIT  : CONTAINS THE SOLUTION VECTOR
C     IFLAG : INTEGER VARIABLE TO BE USED TO SWITCH FROM THE SOLUTION
C             WITH THE BORDERED SYSTEM
C                     ( A B )
C                     (     )
C                     ( C D )
C             (IFLAG =1)  TO SOLUTION WITH THE TRANSPOSED MATRIX
C             (IFLAG =-1)
C             IS TO BE CHANGED BEFORE FIRST CALLING SBEMSO,
C             NOT TO BE TAMPERED WITH BEFORE CALLING SBEMFA.
C     IRETN : INTEGER VARIABLE THAT DIRECTS THE STREAM OF 
C             CALLS TO SBEMFA AND APPLICATIONS OF THE SOLVERS
C             WITH A AND AT.
C             IT NEEDS NO CHANGES BY THE USER.
C     TOL :   REAL VARIABLE INTRODUCED TO AVOID DIVIDING BY
C             A SCHUR COMPLEMENT EQUAL TO ZERO. IF A SCHUR
C             COMPLEMENT IS SMALLER THAN TOL IN ABSOLUTE VALUE,
C             IT IS REPLACED BY TOL.
C     IREP :  INTEGER VARIABLE INTRODUCED TO REPORT ON        
C             THE USE OF TOL. 
C             ON ENTRY : HAS TO BE ZERO
C             ON EXIT : 0 IF NO SCHUR COMPLEMENT WAS REPLACED.
C                     : +K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO CROUT DECOMPOSITION
C                          (APPEARING IN VDATA(N+K,K,0)) WAS
C                          FIRST TO BE CHANGED.
C                     : -K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO DOOLITTLE DECOMPOSITION
C                          (APPEARING IN VDATA(N+K,K,1)) WAS
C                          FIRST TO BE CHANGED.
C             AN EXIT VALUE IREP DIFFERENT FROM ZERO INDICATES
C             THAT THE ALGORITHM MAY HAVE FAILED AND HELPS 
C             TO DETECT CERTAIN PATHOLOGICAL CASES.
C
C     THE USER MUST:
C             -DECLARE THE ABOVE ARRAYS AND VARIABLES
C             -ASSIGN AN APPROPRIATE VALUE TO TOL (WE RECOMMEND
C                   ROUGHLY THE LARGEST ABSOLUTE VALUE OF THE ENTRIES
C                   OF A , B, C, D MULTIPLIED WITH THE MACHINE PRECISION)
C             -SET IREP=0
C             -FILL IN THE DATA IN B, C, D IN THE APPROPRIATE
C                   LOCATIONS OF BDATA
C             -PROVIDE THE SOLVERS FOR A AND AT
C             -SET IFLAG=1 OR IFLAG=-1 BEFORE CALLING
C                   SBEMSO ACCORDING TO WHETHER HE WANTS TO
C                   SOLVE WITH THE BORDERED MATRIX OR ITS
C                   TRANSPOSE.
C
C     NOTE :
C     -------------
C     ONCE THE LOOP OF CALLS TO SBEMFA IS FINISHED
C     (WHICH REQUIRES M APPLICATIONS OF THE SOLVER FOR A
C     AND M APPLICATIONS OF THE SOLVER FOR AT),
C     THE SOLUTION OF A LINEAR SYSTEM WITH THE BORDERED MATRIX
C     REQUIRES ONE APPLICATION OF THE SOLVER PER RIGHT - HAND 
C     SIDE VECTOR; THE SOLUTION OF A LINEAR SYSTEM WITH
C     THE TRANSPOSE OF THE BORDERED MATRIX REQUIRES ONE
C     APPLICATION OF THE SOLVER FOR THE TRANSPOSED MATRIX.
C
C                                                                           
      PARAMETER (N=2,M=2)

C     REAL A(N,N)

      REAL BDATA(1:N+M,1:M,0:1)
      REAL VDATA(1:N+M,1:M,0:1)
      
      REAL WORK(N+M),H(N+M)

      REAL WORK1(M)
      REAL TOL
      INTEGER IFLAG,IRETN,IREP

C
C     IN THIS EXAMPLE WE SOLVE THE SYSTEM
C    
C                     ( 1 0 1 1 )     ( 8 )
C                     ( 2 1 3 1 )     (17 )
C                     (         ) Z = (   )
C                     ( 1 1 1 3 )     (18 )
C                     ( 1 2 3 4 )     (30 )
C     ,APPLYING BEMW WITH N=2, M=2.
C
C     A(1,1)=1.0
C     A(1,2)=0.0
C     A(2,1)=2.0
C     A(2,2)=1.0
C
C     FILL IN THE DATA OF B, C, D IN BDATA
C
C
      DATA BDATA / 1.0, 3.0, 1.0, 1.0E+20,
     *             1.0, 1.0, 3.0, 4.0,
     *             1.0, 1.0, 1.0, 1.0E+20,
     *             1.0, 2.0, 3.0, 4.0 /

      DATA H / 8.0, 17.0, 18.0, 30.0 /
  

      WRITE (*,*) 'RIGHT - HAND SIDE :',H

      TOL=1.0E-7
      IREP=0
      IFLAG=1
      IRETN=1

200   IF (IFLAG .NE. 0) THEN
      
      CALL SBEMFA(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1,TOL)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO WORK(1:N)
C
C
      CALL SSA(WORK)

      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO WORK(1:N)
C
C
      CALL SSASTA(WORK)

      ENDIF
      GOTO 200
      ENDIF

      
C     SET IFLAG=1 TO SOLVE WITH THE BORDERED MATRIX
C     (WITH IFLAG=-1 WE SOLVE WITH ITS TRANSPOSE)
C 
      IFLAG=1
      CALL SBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO H
C
C
      CALL SSA(H)

      
      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO H
C
C
      CALL SSASTA(H)

      ELSE
      WRITE (*,*) 'ERROR IN CALL TO SBEMSO'
      STOP
      ENDIF
      CALL SBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)
      
      
      WRITE (*,*) 'SOLUTION VECTOR :',H
      WRITE (*,*) 'IREP :' ,IREP
      END


      SUBROUTINE SBEMSO(IFLAG,N,M,BDATA,VDATA,WORK,WORK1)

      INTEGER IFLAG,N,M,MP1
      REAL BDATA(1:N+M,1:M,0:1),VDATA(1:N+M,1:M,0:1),WORK(1),WORK1(1)

      MP1=M+1
      IF (IFLAG .NE. 1) GOTO 100      
      CALL SBEM1(N,M,MP1,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IFLAG=2
      RETURN
100   IF (IFLAG .NE. 2) GOTO 200
      CALL SBEM2(N,M,MP1,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IFLAG=0
      RETURN
200   IF (IFLAG .NE. -1) GOTO 300
      CALL SBEM1(N,M,MP1,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IFLAG=-2
      RETURN
300   IF (IFLAG .NE. -2) GOTO 400
      CALL SBEM2(N,M,MP1,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IFLAG=0
      RETURN
400   WRITE (*,*) 'ILLEGAL CALL TO SBEMSO'
      STOP
      END


      SUBROUTINE SBEMFA(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1, 
     *                  TOL)

      INTEGER IFLAG,IRETN,IREP,K,N,M,NPM

      REAL BDATA(1:N+M,1:M,0:1),VDATA(1:N+M,1:M,0:1),WORK(1),WORK1(1),
     *                          TOL
      REAL DELTA
      SAVE K

      NPM=N+M
      GOTO (100,200,300) IRETN
      WRITE (*,*) 'ILLEGAL CALL TO SBEMFA'
      STOP
100   K=1

150   IF (K .GT. M) GOTO 400

      CALL SCOPY(NPM,BDATA(1,K,0),1,WORK,1)
      CALL SBEM1(N,M,K,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IRETN=2
      IFLAG=1
      RETURN

200   CALL SBEM2(N,M,K,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      CALL SCOPY(NPM,WORK,1,VDATA(1,K,0),1)
      DELTA=BDATA(N+K,K,0)-SDOT(N+K-1,BDATA(1,K,1),1
     *,VDATA(1,K,0),1)
      IF (ABS(DELTA) .LT. TOL) THEN
      DELTA=TOL
      IF (IREP .EQ. 0) IREP = K
      ENDIF
      VDATA(N+K,K,0)=DELTA

      CALL SCOPY(NPM,BDATA(1,K,1),1,WORK,1)
      CALL SBEM1(N,M,K,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IRETN=3
      IFLAG=-1
      RETURN

300   CALL SBEM2(N,M,K,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      CALL SCOPY(NPM,WORK,1,VDATA(1,K,1),1)
      DELTA = BDATA(N+K,K,1)-SDOT(N+K-1,BDATA(1,K,0),1
     *,VDATA(1,K,1),1)
      IF (ABS(DELTA) .LT. TOL)  THEN
      DELTA = TOL
      IF (IREP .EQ. 0) IREP = -K
      ENDIF
      VDATA(N+K,K,1) = DELTA
       
      K=K+1
      GOTO 150

400   IFLAG=0
      IRETN=0
      END

 


      SUBROUTINE SBEM1(N,M,J,B,VSTAR,WORK1,WORK)

      INTEGER N,M,J,K
      REAL B(1),VSTAR(1),WORK1(1),WORK(1),STEMP

      DO 100 K=J-1,1,-1
      STEMP=(WORK(N+K)-SDOT(N+K-1,WORK,1,VSTAR(1+(N+M)*(K-1)),1))/
     *VSTAR((N+M)*(K-1)+N+K)
      CALL SAXPY(N+K,-STEMP,B(1+(N+M)*(K-1)),1,WORK,1)
      WORK1(K)=STEMP
100   CONTINUE

      END     

      SUBROUTINE SBEM2(N,M,J,BSTAR,V,WORK1,WORK)

      INTEGER N,M,J,K
      REAL BSTAR(1),V(1),WORK1(1),WORK(1),STEMP
      
      DO 100 K=1,J-1
      STEMP=(WORK(N+K)-SDOT(N+K-1,WORK,1,BSTAR(1+(N+M)*(K-1)),1))/
     *V((N+M)*(K-1)+N+K)
      CALL SAXPY(N+K-1,-STEMP,V(1+(N+M)*(K-1)),1,WORK,1)
      WORK(N+K)=WORK1(K)+STEMP
100   CONTINUE

      END

      SUBROUTINE SSA(WORK)
      INTEGER N
      REAL WORK(1)
C
C     THIS IS THE SOLVER FOR A.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     A * X = WORK.
C
      REAL HELP1,HELP2

      HELP1=WORK(1)
      HELP2=WORK(2)
      WORK(1)=HELP1
      WORK(2)=HELP2-2.0*HELP1
      
      RETURN
      END

      SUBROUTINE SSASTA(WORK)
      INTEGER N
      REAL WORK(1)
C
C     THIS IS THE SOLVER FOR At.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     At * X = WORK.
C
      REAL HELP1,HELP2
      HELP1=WORK(1)
      HELP2=WORK(2)
      WORK(1)=HELP1-2.0*HELP2
      WORK(2)=HELP2

      RETURN
      END

      
      REAL FUNCTION SDOT(N, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     FORMS THE DOT PRODUCT OF TWO VECTORS.
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1), STEMP
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      STEMP = 0.0E0
      SDOT = 0.0E0
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        STEMP = STEMP + SX(IX)*SY(IY)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      SDOT = STEMP
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,5)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        STEMP = STEMP + SX(I)*SY(I)
   30 CONTINUE
      IF (N.LT.5) GO TO 60
   40 MP1 = M + 1
      DO 50 I=MP1,N,5
        STEMP = STEMP + SX(I)*SY(I) + SX(I+1)*SY(I+1) + SX(I+2)*SY(I+2)
     *   + SX(I+3)*SY(I+3) + SX(I+4)*SY(I+4)
   50 CONTINUE
   60 SDOT = STEMP
      RETURN
C
C***********************************************************************
C
      END
      SUBROUTINE SAXPY(N, SA, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     CONSTANT TIMES A VECTOR PLUS A VECTOR.
C     USES UNROLLED LOOP FOR INCREMENTS EQUAL TO ONE.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1), SA
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      IF (N.LE.0) RETURN
      IF (SA.EQ.0.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        SY(IY) = SY(IY) + SA*SX(IX)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,4)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        SY(I) = SY(I) + SA*SX(I)
   30 CONTINUE
      IF (N.LT.4) RETURN
   40 MP1 = M + 1
      DO 50 I=MP1,N,4
        SY(I) = SY(I) + SA*SX(I)
        SY(I+1) = SY(I+1) + SA*SX(I+1)
        SY(I+2) = SY(I+2) + SA*SX(I+2)
        SY(I+3) = SY(I+3) + SA*SX(I+3)
   50 CONTINUE
      RETURN
C
C***********************************************************************
C
      END


      SUBROUTINE SCOPY(N, SX, INCX, SY, INCY)
C
C***********************************************************************
C
C
C     COPIES A VECTOR, X, TO A VECTOR, Y.
C     USES UNROLLED LOOPS FOR INCREMENTS EQUAL TO 1.
C     JACK DONGARRA, LINPACK, 3/11/78.
C
      REAL SX(1), SY(1)
      INTEGER I, INCX, INCY, IX, IY, M, MP1, N
C
      IF (N.LE.0) RETURN
      IF (INCX.EQ.1 .AND. INCY.EQ.1) GO TO 20
C
C        CODE FOR UNEQUAL INCREMENTS OR EQUAL INCREMENTS
C          NOT EQUAL TO 1
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (-N+1)*INCX + 1
      IF (INCY.LT.0) IY = (-N+1)*INCY + 1
      DO 10 I=1,N
        SY(IY) = SX(IX)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C        CODE FOR BOTH INCREMENTS EQUAL TO 1
C
C
C        CLEAN-UP LOOP
C
   20 M = MOD(N,7)
      IF (M.EQ.0) GO TO 40
      DO 30 I=1,M
        SY(I) = SX(I)
   30 CONTINUE
      IF (N.LT.7) RETURN
   40 MP1 = M + 1
      DO 50 I=MP1,N,7
        SY(I) = SX(I)
        SY(I+1) = SX(I+1)
        SY(I+2) = SX(I+2)
        SY(I+3) = SX(I+3)
        SY(I+4) = SX(I+4)
        SY(I+5) = SX(I+5)
        SY(I+6) = SX(I+6)
   50 CONTINUE
      RETURN
C
C***********************************************************************
C
      END

