      PROGRAM DBEDR
C
C
C     THIS PROGRAM, DATED 13 SEPTEMBER 1993, IS A DRIVER
C     PROGRAM AND TEST EXAMPLE FOR THE DOUBLE 
C     PRECISION IMPLEMENTATION OF THE MIXED BLOCK 
C     ELIMINATION METHOD FOR WIDER BORDERS
C     CALLED BEMW AND DUE TO W. GOVAERTS AND J. D. PRYCE.
C
C     SUBROUTINES CALLED ARE:
C
C            1. THE FOUR CORE BEMW SUBROUTINES FOR THE
C               DOUBLE PRECISION REAL IMPLEMENTATION
C               OF BEMW, NAMELY
C                    DBEMSO
C                    DBEMFA
C                    DBEM1
C                    DBEM2
C               THE USER SHOULD NOT CHANGE THEM IN ANY WAY
C  
C            2. THE SUBROUTINES DSA, DSASTA 
C               THESE MUST BE PROVIDED BY THE USER AND SOLVE 
C               LINEAR SYSTEMS WITH A MATRIX A AND ITS
C               TRANSPOSE
C 
C            3. THE BLAS SUBROUTINES DAXPY, DCOPY AND 
C               FUNCTION DDOT
C
C
C     FOR A DESCRIPTION OF THE ALGORITHM SEE 
C
C     W. GOVAERTS, STABLE SOLVERS AND BLOCK ELIMINATION FOR
C     BORDERED SYSTEMS, SIAM J. MATRIX ANAL. APPL. 
C     12 (1991) 469-483 
C     W. GOVAERTS AND J.D. PRYCE, MIXED BLOCK ELIMINATION FOR
C     LINEAR SYSTEMS WITH WIDER BORDERS, IMA J. NUM. ANAL.
C     13 (1993) 161-180.
C
C     IT IS WRITTEN IN REVERSE COMMUNICATION MODE, WHICH MEANS
C     THAT THE CHOICE OF THE SOLVER FOR A BASIC MATRIX A 
C     AND ITS TRANSPOSE IS ENTIRELY LEFT TO THE USER AND A COLLECTION
C     OF SUBROUTINES IS GIVEN THAT ALLOWS THE CONSTRUCTION OF
C     SOLVERS FOR BORDERED FORMS OF A AND ITS TRANSPOSE.
C
C     THE PROBLEM UNDER CONSIDERATION IS THE SOLUTION OF A LINEAR 
C     SYSTEM OF THE FORM
C
C                 ( A   B )
C                 (       )  Z = H
C                 ( C   D ) 
C    
C     AND THAT OF A LINEAR SYSTEM WITH THE TRANSPOSED MATRIX.
C     HERE A IS A SQUARE MATRIX OF ORDER N x N SUCH THAT
C     SOLVERS FOR BOTH A AND AT (=Atranspose) ARE GIVEN. ONLY
C     THESE SOLVERS ARE USED IN THE CODE, A IS NEVER
C     REFERRED TO.
C     B , C , D ARE N x M, M x N AND M x M RESPECTIVELY
C     Z AND H ARE (N + M) -DIMENSIONAL COLUMN VECTORS.
C 
C     USE OF THE VARIABLES
C     --------------------
C     N : DIMENSION OF THE BASIC MATRIX A
C         UNCHANGED ON EXIT
C     M : NUMBER OF BORDERING ROWS AND COLUMNS
C         UNCHANGED ON EXIT
C     BDATA : DOUBLE PRECISION DIMENSION(1:N+M,1:M,0:1)
C             CONTAINS THE INFORMATION ON B, C, D.
C             ON ENTRY :
C     
C             BDATA(1:N,1:M,0)=B
C             BDATA(N+1:N+M,1:M,0)=D
C
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF D
C                  ARE NOT REFERRED TO.
C
C             BDATA(1:N,1:M,1)=transpose OF C
C             BDATA(N+1:N+M,1:M,1)=transpose OF D 
C             
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF 
C                  THE transpose of D
C                  ARE NOT REFERRED TO.
C
C             REMARK THAT THE DIAGONAL OF D IS STORED TWICE.  
C    
C             ALSO M*(M-1) LOCATIONS IN BDATA ARE NEVER REFERRED TO
C             IF M>2.
C
C             ON EXIT : UNCHANGED
C     VDATA : DOUBLE PRECISION DIMENSION(1:N+M,1:M,0:1)
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT  : CONTAINS PROCESSED DATA FROM BDATA
C                        
C             VDATA IS FILLED IN A LOOP OF CALLS TO DBEMFA ALTERNATED
C             WITH APPLICATIONS OF THE SOLVERS FOR A AND AT. 
C             THESE DATA ARE SUBSEQUENTLY USED BY DBEMSO TO SOLVE
C             LINEAR SYSTEMS WITH
C              
C                           ( A B )
C                           (     )
C                           ( C D )
C             AND ITS TRANSPOSE.
C     WORK :  DOUBLE PRECISION WORK ARRAY OF DIMENSION N+M 
C             TO BE DECLARED BY THE USER.
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT : IS FREE FOR OTHER USES AFTER THE
C             COMPLETION OF ALL CALLS TO DBEMFA
C     WORK1 : DOUBLE PRECISION WORK ARRAY OF DIMENSION M
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT :IS FREE FOR OTHER USES AFTER ALL CALLS
C                      TO DBEMFA AND DBEMSO ARE FINISHED       
C     H     : ON ENTRY : CONTAINS THE RIGHT - HAND SIDE
C                         DOUBLE PRECISION (N+M) - VECTOR 
C                         OF THE SYSTEM TO BE SOLVED
C             ON EXIT  : CONTAINS THE SOLUTION VECTOR
C     IFLAG : INTEGER VARIABLE TO BE USED TO SWITCH FROM THE SOLUTION
C             WITH THE BORDERED SYSTEM
C                     ( A B )
C                     (     )
C                     ( C D )
C             (IFLAG =1)  TO SOLUTION WITH THE TRANSPOSED MATRIX
C             (IFLAG =-1)
C             IS TO BE CHANGED BEFORE FIRST CALLING DBEMSO,
C             NOT TO BE TAMPERED WITH BEFORE CALLING DBEMFA.
C     IRETN : INTEGER VARIABLE THAT DIRECTS THE STREAM OF 
C             CALLS TO DBEMFA AND APPLICATIONS OF THE SOLVERS
C             WITH A AND AT.
C             IT NEEDS NO CHANGES BY THE USER.
C     TOL :   DOUBLE PRECISION VARIABLE INTRODUCED TO AVOID DIVIDING BY
C             A SCHUR COMPLEMENT EQUAL TO ZERO. IF A SCHUR
C             COMPLEMENT IS SMALLER THAN TOL IN ABSOLUTE VALUE,
C             IT IS REPLACED BY TOL.
C     IREP :  INTEGER VARIABLE INTRODUCED TO REPORT ON        
C             THE USE OF TOL. 
C             ON ENTRY : HAS TO BE ZERO
C             ON EXIT : 0 IF NO SCHUR COMPLEMENT WAS REPLACED.
C                     : +K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO CROUT DECOMPOSITION
C                          (APPEARING IN VDATA(N+K,K,0)) WAS
C                          FIRST TO BE CHANGED.
C                     : -K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO DOOLITTLE DECOMPOSITION
C                          (APPEARING IN VDATA(N+K,K,1)) WAS
C                          FIRST TO BE CHANGED.
C             AN EXIT VALUE IREP DIFFERENT FROM ZERO INDICATES
C             THAT THE ALGORITHM MAY HAVE  FAILED AND HELPS
C             TO DETECT CERTAIN PATHOLOGICAL CASES.
C
C     THE USER MUST:
C             -DECLARE THE ABOVE ARRAYS AND VARIABLES
C             -ASSIGN AN APPROPRIATE VALUE TO TOL (WE RECOMMEND
C                   ROUGHLY THE LARGEST ABSOLUTE VALUE OF THE ENTRIES
C                   OF A , B, C, D MULTIPLIED WITH THE MACHINE PRECISION)
C             -SET IREP=0
C             -FILL IN THE DATA IN B, C, D IN THE APPROPRIATE
C                   LOCATIONS OF BDATA
C             -PROVIDE THE SOLVERS FOR A AND AT
C             -SET IFLAG=1 OR IFLAG=-1 BEFORE CALLING
C                   DBEMSO ACCORDING TO WHETHER HE WANTS TO
C                   SOLVE WITH THE BORDERED MATRIX OR ITS
C                   TRANSPOSE.
C
C     NOTE :
C     -------------
C     ONCE THE LOOP OF CALLS TO DBEMFA IS FINISHED
C     (WHICH REQUIRES M APPLICATIONS OF THE SOLVER FOR A
C     AND M APPLICATIONS OF THE SOLVER FOR AT),
C     THE SOLUTION OF A LINEAR SYSTEM WITH THE BORDERED MATRIX
C     REQUIRES ONE APPLICATION OF THE SOLVER PER RIGHT - HAND 
C     SIDE VECTOR; THE SOLUTION OF A LINEAR SYSTEM WITH
C     THE TRANSPOSE OF THE BORDERED MATRIX REQUIRES ONE
C     APPLICATION OF THE SOLVER FOR THE TRANSPOSED MATRIX.
C
C                                                                           
      PARAMETER (N=2,M=2)

C     DOUBLE PRECISION A(N,N)

      DOUBLE PRECISION BDATA(1:N+M,1:M,0:1)
      DOUBLE PRECISION VDATA(1:N+M,1:M,0:1)
      
      DOUBLE PRECISION WORK(N+M),H(N+M)

      DOUBLE PRECISION WORK1(M)
      DOUBLE PRECISION TOL
      INTEGER IFLAG,IRETN,IREP

C
C     IN THIS EXAMPLE WE SOLVE THE SYSTEM
C    
C                     ( 1 O 1 1 )     ( 8 )
C                     ( 2 1 3 1 )     (17 )
C                     (         ) Z = (   )
C                     ( 1 1 1 3 )     (18 )
C                     ( 1 2 3 4 )     (30 )
C     ,APPLYING BEMW WITH N=2, M=2.
C
C     A(1,1)=1.0
C     A(1,2)=0.0
C     A(2,1)=2.0
C     A(2,2)=1.0
C
C     FILL IN THE DATA OF B, C, D IN BDATA
C
C
      DATA BDATA / 1.0D0, 3.0D0, 1.0D0, 1.0D+20,
     *             1.0D0, 1.0D0, 3.0D0, 4.0D0,
     *             1.0D0, 1.0D0, 1.0D0, 1.0D+20,
     *             1.0D0, 2.0D0, 3.0D0, 4.0D0 /

      DATA H / 8.0D0, 17.0D0, 
     *        18.0D0, 30.0D0 /
  

      WRITE (*,*) 'RIGHT - HAND SIDE :',H

      TOL=1.0D-14
      IREP=0
      IFLAG=1
      IRETN=1

200   IF (IFLAG .NE. 0) THEN
      
      CALL DBEMFA(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1,TOL)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO WORK(1:N)
C
C
      CALL DSA(WORK)

      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO WORK(1:N)
C
C
      CALL DSASTA(WORK)

      ENDIF
      GOTO 200
      ENDIF

      
C     SET IFLAG=1 TO SOLVE WITH THE BORDERED MATRIX
C     (WITH IFLAG=-1 WE SOLVE WITH ITS TRANSPOSE)
C 
      IFLAG=1
      CALL DBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR A TO H
C
C
      CALL DSA(H)

      
      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR AT TO H
C
C
      CALL DSASTA(H)

      ELSE
      WRITE (*,*) 'ERROR IN CALL TO DBEMSO'
      STOP
      ENDIF
      CALL DBEMSO(IFLAG,N,M,BDATA,VDATA,H,WORK1)
      
      
      WRITE (*,*) 'SOLUTION VECTOR :',H
      WRITE (*,*) 'IREP :' ,IREP
      END


      SUBROUTINE DBEMSO(IFLAG,N,M,BDATA,VDATA,WORK,WORK1)

      INTEGER IFLAG,N,M,MP1
      DOUBLE PRECISION BDATA(1:N+M,1:M,0:1),
     *                 VDATA(1:N+M,1:M,0:1),WORK(1),WORK1(1)

      MP1=M+1
      IF (IFLAG .NE. 1) GOTO 100      
      CALL DBEM1(N,M,MP1,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IFLAG=2
      RETURN
100   IF (IFLAG .NE. 2) GOTO 200
      CALL DBEM2(N,M,MP1,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IFLAG=0
      RETURN
200   IF (IFLAG .NE. -1) GOTO 300
      CALL DBEM1(N,M,MP1,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IFLAG=-2
      RETURN
300   IF (IFLAG .NE. -2) GOTO 400
      CALL DBEM2(N,M,MP1,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IFLAG=0
      RETURN
400   WRITE (*,*) 'ILLEGAL CALL TO DBEMSO'
      STOP
      END


      SUBROUTINE DBEMFA(IFLAG,IRETN,IREP,N,M,BDATA,VDATA,WORK,WORK1, 
     *                  TOL)

      INTEGER IFLAG,IRETN,IREP,K,N,M,NPM

      DOUBLE PRECISION BDATA(1:N+M,1:M,0:1),
     *                 VDATA(1:N+M,1:M,0:1),WORK(1),WORK1(1),
     *                 DDOT,TOL
      DOUBLE PRECISION DELTA
      SAVE K

      NPM=N+M
      GOTO (100,200,300) IRETN
      WRITE (*,*) 'ILLEGAL CALL TO DBEMFA'
      STOP
100   K=1

150   IF (K .GT. M) GOTO 400

      CALL DCOPY(NPM,BDATA(1,K,0),1,WORK,1)
      CALL DBEM1(N,M,K,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      IRETN=2
      IFLAG=1
      RETURN

200   CALL DBEM2(N,M,K,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      CALL DCOPY(NPM,WORK,1,VDATA(1,K,0),1)
      DELTA=BDATA(N+K,K,0)-DDOT(N+K-1,BDATA(1,K,1),1
     *,VDATA(1,K,0),1)
      IF (DABS(DELTA) .LT. TOL) THEN
      DELTA=TOL
      IF (IREP .EQ. 0) IREP = K
      ENDIF
      VDATA(N+K,K,0)=DELTA

      CALL DCOPY(NPM,BDATA(1,K,1),1,WORK,1)
      CALL DBEM1(N,M,K,BDATA(1,1,1),VDATA(1,1,0),WORK1,WORK)
      IRETN=3
      IFLAG=-1
      RETURN

300   CALL DBEM2(N,M,K,BDATA(1,1,0),VDATA(1,1,1),WORK1,WORK)
      CALL DCOPY(NPM,WORK,1,VDATA(1,K,1),1)
      DELTA = BDATA(N+K,K,1)-DDOT(N+K-1,BDATA(1,K,0),1
     *,VDATA(1,K,1),1)
      IF (DABS(DELTA) .LT. TOL)  THEN
      DELTA = TOL
      IF (IREP .EQ. 0) IREP = -K
      ENDIF
      VDATA(N+K,K,1) = DELTA
       
      K=K+1
      GOTO 150

400   IFLAG=0
      IRETN=0
      END

 


      SUBROUTINE DBEM1(N,M,J,B,VSTAR,WORK1,WORK)

      INTEGER N,M,J,K
      DOUBLE PRECISION B(1),VSTAR(1),WORK1(1),WORK(1),STEMP,
     *                 DDOT
      DO 100 K=J-1,1,-1
      STEMP=(WORK(N+K)-DDOT(N+K-1,WORK,1,VSTAR(1+(N+M)*(K-1)),1))/
     *VSTAR((N+M)*(K-1)+N+K)
      CALL DAXPY(N+K,-STEMP,B(1+(N+M)*(K-1)),1,WORK,1)
      WORK1(K)=STEMP
100   CONTINUE

      END     

      SUBROUTINE DBEM2(N,M,J,BSTAR,V,WORK1,WORK)

      INTEGER N,M,J,K
      DOUBLE PRECISION BSTAR(1),V(1),WORK1(1),WORK(1),STEMP,
     *                 DDOT 
      DO 100 K=1,J-1
      STEMP=(WORK(N+K)-DDOT(N+K-1,WORK,1,BSTAR(1+(N+M)*(K-1)),1))/
     *V((N+M)*(K-1)+N+K)
      CALL DAXPY(N+K-1,-STEMP,V(1+(N+M)*(K-1)),1,WORK,1)
      WORK(N+K)=WORK1(K)+STEMP
100   CONTINUE

      END

      SUBROUTINE DSA(WORK)
      INTEGER N
      DOUBLE PRECISION WORK(1)
C
C     THIS IS THE SOLVER FOR A.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     A * X = WORK.
C
      DOUBLE PRECISION HELP1,HELP2

      HELP1=WORK(1)
      HELP2=WORK(2)
      WORK(1)=HELP1
      WORK(2)=HELP2-2.0D0*HELP1
      
      RETURN
      END

      SUBROUTINE DSASTA(WORK)
      INTEGER N
      DOUBLE PRECISION WORK(1)
C
C     THIS IS THE SOLVER FOR At.
C     IT OVERWRITES THE N - ARRAY WORK BY THE SOLUTION OF
C     At * X = WORK.
C
      DOUBLE PRECISION HELP1,HELP2
      HELP1=WORK(1)
      HELP2=WORK(2)
      WORK(1)=HELP1-2.0D0*HELP2
      WORK(2)=HELP2

      RETURN
      END

      double precision function ddot(n,dx,incx,dy,incy)
c
c     forms the dot product of two vectors.
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dy(1),dtemp
      integer i,incx,incy,ix,iy,m,mp1,n
c
      ddot = 0.0d0
      dtemp = 0.0d0
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dtemp = dtemp + dx(ix)*dy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      ddot = dtemp
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,5)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dtemp = dtemp + dx(i)*dy(i)
   30 continue
      if( n .lt. 5 ) go to 60
   40 mp1 = m + 1
      do 50 i = mp1,n,5
        dtemp = dtemp + dx(i)*dy(i) + dx(i + 1)*dy(i + 1) +
     *   dx(i + 2)*dy(i + 2) + dx(i + 3)*dy(i + 3) + dx(i + 4)*dy(i + 4)
   50 continue
   60 ddot = dtemp
      return
      end
      subroutine  dcopy(n,dx,incx,dy,incy)
c
c     copies a vector, x, to a vector, y.
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dy(1)
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dy(iy) = dx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,7)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dy(i) = dx(i)
   30 continue
      if( n .lt. 7 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,7
        dy(i) = dx(i)
        dy(i + 1) = dx(i + 1)
        dy(i + 2) = dx(i + 2)
        dy(i + 3) = dx(i + 3)
        dy(i + 4) = dx(i + 4)
        dy(i + 5) = dx(i + 5)
        dy(i + 6) = dx(i + 6)
   50 continue
      return
      end
      subroutine daxpy(n,da,dx,incx,dy,incy)
c
c     constant times a vector plus a vector.
c     uses unrolled loops for increments equal to one.
c     jack dongarra, linpack, 3/11/78.
c
      double precision dx(1),dy(1),da
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if (da .eq. 0.0d0) return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        dy(iy) = dy(iy) + da*dx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        dy(i) = dy(i) + da*dx(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        dy(i) = dy(i) + da*dx(i)
        dy(i + 1) = dy(i + 1) + da*dx(i + 1)
        dy(i + 2) = dy(i + 2) + da*dx(i + 2)
        dy(i + 3) = dy(i + 3) + da*dx(i + 3)
   50 continue
      return
      end
