      PROGRAM CBEDR
C
C
C     THIS PROGRAM, DATED 13 SEPTEMBER 1993, IS A 
C     DRIVER PROGRAM AND TEST EXAMPLE FOR AN IMPLEMENTATION
C     OF THE COMPLEX FORM OF THE MIXED BLOCK ELIMINATION METHOD
C     FOR WIDER BORDERS
C     CALLED BEMW AND DUE TO W. GOVAERTS AND J. D. PRYCE.
C
C
C     SUBROUTINES CALLED ARE:
C
C            1. THE FOUR CORE BEMW SUBROUTINES FOR THE
C               SINGLE PRECISION COMPLEX IMPLEMENTATION
C               OF BEMW, NAMELY
C                    CBEMSO
C                    CBEMFA
C                    CBEM1
C                    CBEM2
C               THE USER SHOULD NOT CHANGE THEM IN ANY WAY
C  
C            2. THE SUBROUTINES CSA, CSASTA 
C               THESE MUST BE PROVIDED BY THE USER AND SOLVE 
C               LINEAR SYSTEMS WITH A MATRIX A AND ITS
C               TRANSPOSE
C 
C            3. THE BLAS SUBROUTINES CAXPY, CCOPY AND 
C               FUNCTION CDOTU
C
C
C     FOR A DESCRIPTION OF THE ALGORITHM SEE 
C
C     W. GOVAERTS, STABLE SOLVERS AND BLOCK ELIMINATION FOR
C     BORDERED SYSTEMS, SIAM J. MATRIX ANAL. APPL. 
C     12 (1991) 469-483 
C     W. GOVAERTS AND J.D. PRYCE, MIXED BLOCK ELIMINATION FOR
C     LINEAR SYSTEMS WITH WIDER BORDERS, IMA J. NUM. ANAL.
C     13 (1993) 161-180.
C
C     IT IS WRITTEN IN REVERSE COMMUNICATION MODE, WHICH MEANS
C     THAT THE CHOICE OF THE SOLVER FOR A BASIC MATRIX A 
C     AND ITS TRANSPOSE IS ENTIRELY LEFT TO THE USER AND A COLLECTION
C     OF SUBROUTINES IS GIVEN THAT ALLOWS THE CONSTRUCTION OF
C     SOLVERS FOR BORDERED FORMS OF A AND ITS TRANSPOSE.
C
C     THE PROBLEM UNDER CONSIDERATION IS THE SOLUTION OF A LINEAR 
C     SYSTEM OF THE FORM
C
C                 ( CA   CB )
C                 (         )  CZ = CH
C                 ( CC   CD ) 
C    
C     AND THAT OF A LINEAR SYSTEM WITH THE TRANSPOSED MATRIX.
C     HERE CA IS A SQUARE MATRIX OF ORDER N x N SUCH THAT
C     SOLVERS FOR BOTH CA AND CAT (=Atranspose) ARE GIVEN. ONLY
C     THESE SOLVERS ARE USED IN THE CODE, CA IS NEVER
C     REFERRED TO.
C     CB , CC , CD ARE N x M, M x N AND M x M RESPECTIVELY
C     CZ AND CH ARE (N + M) -DIMENSIONAL COLUMN VECTORS.
C 
C     USE OF THE VARIABLES
C     --------------------
C     N : DIMENSION OF THE BASIC MATRIX CA
C         UNCHANGED ON EXIT
C     M : NUMBER OF BORDERING ROWS AND COLUMNS
C         UNCHANGED ON EXIT
C     CBDATA : COMPLEX DIMENSION(1:N+M,1:M,0:1)
C              CONTAINS THE INFORMATION ON CB, CC, CD.
C             ON ENTRY :
C     
C             CBDATA(1:N,1:M,0)=CB
C             CBDATA(N+1:N+M,1:M,0)=CD
C
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF CD
C                  ARE NOT REFERRED TO.
C
C             CBDATA(1:N,1:M,1)=transpose OF CC
C             CBDATA(N+1:N+M,1:M,1)=transpose OF CD 
C             
C                  HOWEVER, THE ELEMENTS BELOW THE DIAGONAL OF 
C                  THE transpose of CD
C                  ARE NOT REFERRED TO.
C
C             REMARK THAT THE DIAGONAL OF CD IS STORED TWICE.  
C    
C             ALSO M*(M-1) LOCATIONS IN CBDATA ARE NEVER REFERRED TO
C             IF M>2.
C
C             ON EXIT : UNCHANGED
C     CVDATA : REAL DIMENSION(1:N+M,1:M,0:1)
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT  : CONTAINS PROCESSED DATA FROM CBDATA
C                        
C             CVDATA IS FILLED IN A LOOP OF CALLS TO CBEMFA ALTERNATED
C             WITH APPLICATIONS OF THE SOLVERS FOR CA AND CAT. 
C             THESE DATA ARE SUBSEQUENTLY USED BY CBEMSO TO SOLVE
C             LINEAR SYSTEMS WITH
C              
C                           ( CA  CB )
C                           (        )
C                           ( CC  CD )
C             AND ITS TRANSPOSE.
C     CWORK :  COMPLEX WORK ARRAY OF DIMENSION N+M TO BE DECLARED BY THE
C              USER.
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT : IS FREE FOR OTHER USES AFTER THE
C             COMPLETION OF ALL CALLS TO CBEMFA   
C     CWORK1 : COMPLEX WORK ARRAY OF DIMENSION M
C             ON ENTRY : NO REQUIREMENTS
C             ON EXIT :IS FREE FOR OTHER USES AFTER ALL CALLS
C                      TO CBEMFA AND CBEMSO ARE FINISHED       
C     CH     : ON ENTRY : CONTAINS THE RIGHT - HAND SIDE
C                         REAL (N+M) - VECTOR OF THE SYSTEM TO BE SOLVED
C             ON EXIT  : CONTAINS THE SOLUTION VECTOR
C     IFLAG : INTEGER VARIABLE TO BE USED TO SWITCH FROM THE SOLUTION
C             WITH THE BORDERED SYSTEM
C                     ( CA CB )
C                     (       )
C                     ( CC CD )
C             (IFLAG =1)  TO SOLUTION WITH THE TRANSPOSED MATRIX
C             (IFLAG =-1)
C             IS TO BE CHANGED BEFORE FIRST CALLING CBEMSO,
C             NOT TO BE TAMPERED WITH BEFORE CALLING CBEMFA.
C     IRETN : INTEGER VARIABLE THAT DIRECTS THE STREAM OF 
C             CALLS TO CBEMFA AND APPLICATIONS OF THE SOLVERS
C             WITH CA AND CAT.
C             IT NEEDS NO CHANGES BY THE USER.
C     TOL :   REAL VARIABLE INTRODUCED TO AVOID DIVIDING BY
C             A SCHUR COMPLEMENT EQUAL TO ZERO. IF A SCHUR
C             COMPLEMENT IS SMALLER THAN TOL IN ABSOLUTE VALUE,
C             IT IS REPLACED BY TOL.
C     IREP :  INTEGER VARIABLE INTRODUCED TO REPORT ON        
C             THE USE OF TOL. 
C             ON ENTRY : HAS TO BE ZERO
C             ON EXIT : 0 IF NO SCHUR COMPLEMENT WAS REPLACED.
C                     : +K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO CROUT DECOMPOSITION
C                          (APPEARING IN CVDATA(N+K,K,0)) WAS
C                          FIRST TO BE CHANGED.
C                     : -K IF THE K - TH SCHUR COMPLEMENT
C                          CORRESPONDING TO DOOLITTLE DECOMPOSITION
C                          (APPEARING IN CVDATA(N+K,K,1)) WAS
C                          FIRST TO BE CHANGED.
C             AN EXIT VALUE IREP DIFFERENT FROM ZERO INDICATES
C             THAT THE ALGORITHM MAY HAVE FAILED AND HELPS
C             TO DETECT CERTAIN PATHOLOGICAL CASES.
C
C     THE USER MUST:
C             -DECLARE THE ABOVE ARRAYS AND VARIABLES
C             -ASSIGN AN APPROPRIATE VALUE TO TOL (WE RECOMMEND
C                   ROUGHLY THE LARGEST ABSOLUTE VALUE OF THE ENTRIES
C                   OF CA , CB, CC, CD MULTIPLIED WITH
C                     THE MACHINE PRECISION)
C             -SET IREP=0
C             -FILL IN THE DATA IN CB, CC, CD IN THE APPROPRIATE
C                   LOCATIONS OF BDATA
C             -PROVIDE THE SOLVERS FOR CA AND CAT
C             -SET IFLAG=1 OR IFLAG=-1 BEFORE CALLING
C                   CBEMSO ACCORDING TO WHETHER HE WANTS TO
C                   SOLVE WITH THE BORDERED MATRIX OR ITS
C                   TRANSPOSE.
C
C     NOTE :
C     -------------
C     ONCE THE LOOP OF CALLS TO CBEMFA IS FINISHED
C     (WHICH REQUIRES M APPLICATIONS OF THE SOLVER FOR CA
C     AND M APPLICATIONS OF THE SOLVER FOR CAT),
C     THE SOLUTION OF A LINEAR SYSTEM WITH THE BORDERED MATRIX
C     REQUIRES ONE APPLICATION OF THE SOLVER PER RIGHT - HAND 
C     SIDE VECTOR; THE SOLUTION OF A LINEAR SYSTEM WITH
C     THE TRANSPOSE OF THE BORDERED MATRIX REQUIRES ONE
C     APPLICATION OF THE SOLVER FOR THE TRANSPOSED MATRIX.
C
C                                                                           
      PARAMETER (N=2,M=2)

C     COMPLEX CA(N,N)

      COMPLEX CBDATA(1:N+M,1:M,0:1)
      COMPLEX CVDATA(1:N+M,1:M,0:1)
      
      COMPLEX CWORK(N+M),CH(N+M)

      COMPLEX CWORK1(M)
      REAL TOL
      INTEGER IFLAG,IRETN,IREP

C
C     IN THIS EXAMPLE WE SOLVE THE SYSTEM
C    
C                     ( 1+i 0 1   1 )      ( 8+i  )
C                     ( 2   1 3+i 1 )      (17+3i )
C                     (             ) CZ = (      )
C                     ( 1   1 1   3 )      (18    )
C                     ( 1   2 3   4 )      (30    )
C     ,APPLYING CBEMW WITH N=2, M=2.
C
C     CA(1,1)=1.0
C     CA(1,2)=0.0
C     CA(2,1)=2.0
C     CA(2,2)=1.0
C
C     FILL IN THE DATA OF CB, CC, CD IN CBDATA
C
C
      DATA CBDATA / (1.0,0.0),(3.0,1.0),(1.0,0.0),(1.0E+20,0.0),
     *              (1.0,0.0),(1.0,0.0),(3.0,0.0),(4.0,0.0),
     *              (1.0,0.0),(1.0,0.0),(1.0,0.0),
     *              (1.0E+20,0.0),(1.0,0.0),(2.0,0.0),
     *              (3.0,0.0),(4.0,0.0) /

      DATA CH / (8.0,1.0),(17.0,3.0),(18.0,0.0),(30.0,0.0) /
  

      WRITE (*,*) 'RIGHT - HAND SIDE :',CH

      TOL=1.0E-7
      IREP=0
      IFLAG=1
      IRETN=1

200   IF (IFLAG .NE. 0) THEN
      
      CALL CBEMFA(IFLAG,IRETN,IREP,N,M,CBDATA,CVDATA,CWORK,CWORK1,TOL)

     
      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR CA TO CWORK(1:N)
C
C
      CALL CSA(CWORK)

      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR CAT TO CWORK(1:N)
C
C
      CALL CSASTA(CWORK)

      ENDIF
      GOTO 200
      ENDIF

      
C     SET IFLAG=1 TO SOLVE WITH THE BORDERED MATRIX
C     (WITH IFLAG=-1 WE SOLVE WITH ITS TRANSPOSE)
C 
      IFLAG=1
      CALL CBEMSO(IFLAG,N,M,CBDATA,CVDATA,CH,CWORK1)

      IF (IFLAG .GT. 0) THEN
C
C
C     APPLY SOLVER FOR CA TO CH
C
C
      CALL CSA(CH)

      
      ELSE IF (IFLAG .LT. 0) THEN
C
C
C     APPLY SOLVER FOR CAT TO CH
C
C
      CALL CSASTA(CH)

      ELSE
      WRITE (*,*) 'ERROR IN CALL TO CBEMSO'
      STOP
      ENDIF
      CALL CBEMSO(IFLAG,N,M,CBDATA,CVDATA,CH,CWORK1)
      
      
      WRITE (*,*) 'SOLUTION VECTOR :',CH
      WRITE (*,*) 'IREP :' ,IREP
      END


      SUBROUTINE CBEMSO(IFLAG,N,M,CBDATA,CVDATA,CWORK,CWORK1)

      INTEGER IFLAG,N,M,MP1
      COMPLEX CBDATA(1:N+M,1:M,0:1),CVDATA(1:N+M,1:M,0:1),
     *        CWORK(1),CWORK1(1)

      MP1=M+1
      IF (IFLAG .NE. 1) GOTO 100      
      CALL CBEM1(N,M,MP1,CBDATA(1,1,0),CVDATA(1,1,1),CWORK1,CWORK)
      IFLAG=2
      RETURN
100   IF (IFLAG .NE. 2) GOTO 200
      CALL CBEM2(N,M,MP1,CBDATA(1,1,1),CVDATA(1,1,0),CWORK1,CWORK)
      IFLAG=0
      RETURN
200   IF (IFLAG .NE. -1) GOTO 300
      CALL CBEM1(N,M,MP1,CBDATA(1,1,1),CVDATA(1,1,0),CWORK1,CWORK)
      IFLAG=-2
      RETURN
300   IF (IFLAG .NE. -2) GOTO 400
      CALL CBEM2(N,M,MP1,CBDATA(1,1,0),CVDATA(1,1,1),CWORK1,CWORK)
      IFLAG=0
      RETURN
400   WRITE (*,*) 'ILLEGAL CALL TO CBEMSO'
      STOP
      END


      SUBROUTINE CBEMFA(IFLAG,IRETN,IREP,N,M,CBDATA,CVDATA,CWORK 
     *                  ,CWORK1,TOL)

      INTEGER IFLAG,IRETN,IREP,K,N,M,NPM

      COMPLEX CBDATA(1:N+M,1:M,0:1),CVDATA(1:N+M,1:M,0:1),
     *        CWORK(1),CWORK1(1)
      REAL TOL
      COMPLEX CDELTA
      COMPLEX CDOTU
      SAVE K

      NPM=N+M
      GOTO (100,200,300) IRETN
      WRITE (*,*) 'ILLEGAL CALL TO CBEMFA'
      STOP
100   K=1

150   IF (K .GT. M) GOTO 400

      CALL CCOPY(NPM,CBDATA(1,K,0),1,CWORK,1)
      CALL CBEM1(N,M,K,CBDATA(1,1,0),CVDATA(1,1,1),CWORK1,CWORK)
      IRETN=2
      IFLAG=1
      RETURN

200   CALL CBEM2(N,M,K,CBDATA(1,1,1),CVDATA(1,1,0),CWORK1,CWORK)
      CALL CCOPY(NPM,CWORK,1,CVDATA(1,K,0),1)
      CDELTA=CBDATA(N+K,K,0)-CDOTU(N+K-1,CBDATA(1,K,1),1
     *,CVDATA(1,K,0),1)
      IF (CABS(CDELTA) .LT. TOL) THEN
      CDELTA=TOL
      IF (IREP .EQ. 0) IREP = K
      ENDIF
      CVDATA(N+K,K,0)=CDELTA

      CALL CCOPY(NPM,CBDATA(1,K,1),1,CWORK,1)
      CALL CBEM1(N,M,K,CBDATA(1,1,1),CVDATA(1,1,0),CWORK1,CWORK)
      IRETN=3
      IFLAG=-1
      RETURN

300   CALL CBEM2(N,M,K,CBDATA(1,1,0),CVDATA(1,1,1),CWORK1,CWORK)
      CALL CCOPY(NPM,CWORK,1,CVDATA(1,K,1),1)
      CDELTA = CBDATA(N+K,K,1)-CDOTU(N+K-1,CBDATA(1,K,0),1
     *,CVDATA(1,K,1),1)
      IF (CABS(CDELTA) .LT. TOL)  THEN
      CDELTA = TOL
      IF (IREP .EQ. 0) IREP = -K
      ENDIF
      CVDATA(N+K,K,1) = CDELTA
       
      K=K+1
      GOTO 150

400   IFLAG=0
      IRETN=0
      END

 


      SUBROUTINE CBEM1(N,M,J,CB,CVSTAR,CWORK1,CWORK)

      INTEGER N,M,J,K
      COMPLEX CB(1),CVSTAR(1),CWORK1(1),CWORK(1),CSTEMP
      COMPLEX CDOTU
      DO 100 K=J-1,1,-1
      CSTEMP=(CWORK(N+K)-CDOTU(N+K-1,CWORK,1,CVSTAR(1+(N+M)*(K-1)),1))/
     *CVSTAR((N+M)*(K-1)+N+K)
      CALL CAXPY(N+K,-CSTEMP,CB(1+(N+M)*(K-1)),1,CWORK,1)
      CWORK1(K)=CSTEMP
100   CONTINUE

      END     

      SUBROUTINE CBEM2(N,M,J,CBSTAR,CV,CWORK1,CWORK)

      INTEGER N,M,J,K
      COMPLEX CBSTAR(1),CV(1),CWORK1(1),CWORK(1),CSTEMP
      COMPLEX CDOTU
      DO 100 K=1,J-1
      CSTEMP=(CWORK(N+K)-CDOTU(N+K-1,CWORK,1,CBSTAR(1+(N+M)*(K-1)),1))/
     *CV((N+M)*(K-1)+N+K)
      CALL CAXPY(N+K-1,-CSTEMP,CV(1+(N+M)*(K-1)),1,CWORK,1)
      CWORK(N+K)=CWORK1(K)+CSTEMP
100   CONTINUE

      END

      SUBROUTINE CSA(CWORK)
      INTEGER N
      COMPLEX CWORK(1)
C
C     THIS IS THE SOLVER FOR CA.
C     IT OVERWRITES THE N - ARRAY CWORK BY THE SOLUTION OF
C     CA * CX = CWORK.
C
      COMPLEX CHELP1,CHELP2

      CHELP1=CWORK(1)
      CHELP2=CWORK(2)
      CWORK(1)=CHELP1/(1.0,1.0)
      CWORK(2)=CHELP2-2.0*CWORK(1)
      
      RETURN
      END

      SUBROUTINE CSASTA(CWORK)
      INTEGER N
      COMPLEX CWORK(1)
C
C     THIS IS THE SOLVER FOR CAt.
C     IT OVERWRITES THE N - ARRAY CWORK BY THE SOLUTION OF
C     CAt * CX = CWORK.
C
      COMPLEX CHELP1,CHELP2
      CHELP1=CWORK(1)
      CHELP2=CWORK(2)
      CWORK(1)=(CHELP1-2.0*CHELP2)/(1.0,1.0)
      CWORK(2)=CHELP2

      RETURN
      END

      subroutine caxpy(n,ca,cx,incx,cy,incy)
c
c     constant times a vector plus a vector.
c     jack dongarra, linpack, 3/11/78.
c
      complex cx(1),cy(1),ca
      integer i,incx,incy,ix,iy,n
c
      if(n.le.0)return
      if (abs(real(ca)) + abs(aimag(ca)) .eq. 0.0 ) return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        cy(iy) = cy(iy) + ca*cx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
   20 do 30 i = 1,n
        cy(i) = cy(i) + ca*cx(i)
   30 continue
      return
      end
      complex function cdotu(n,cx,incx,cy,incy)
c
c     forms the dot product of two vectors.
c     jack dongarra, linpack, 3/11/78.
c
      complex cx(1),cy(1),ctemp
      integer i,incx,incy,ix,iy,n
c
      ctemp = (0.0,0.0)
      cdotu = (0.0,0.0)
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        ctemp = ctemp + cx(ix)*cy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      cdotu = ctemp
      return
c
c        code for both increments equal to 1
c
   20 do 30 i = 1,n
        ctemp = ctemp + cx(i)*cy(i)
   30 continue
      cdotu = ctemp
      return
      end
      subroutine  ccopy(n,cx,incx,cy,incy)
c
c     copies a vector, x, to a vector, y.
c     jack dongarra, linpack, 3/11/78.
c
      complex cx(1),cy(1)
      integer i,incx,incy,ix,iy,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        cy(iy) = cx(ix)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
   20 do 30 i = 1,n
        cy(i) = cx(i)
   30 continue
      return
      end
