function x=amli_recur(rhs,lvl_deg,Q,levels,lvl_coars,l,W_cyc)
% Solve one system with the AMLI preconditioner - the whole matrix
% x=inv(AMLI)rhs
% l = the current level number

global AK1  AK2  AK3  AK4  AK5  AK6  AK7  AK8 AK9 AK10 
global AK11 AK12 AK13 AK14 AK15 AK16
global BK1  BK2  BK3  BK4  BK5  BK6  BK7  BK8 BK9 BK10 
global BK11 BK12 BK13 BK14 BK15 BK16
global O1 O2 O3 O4 O5 O6 O7 O8 O9 O10 O11 O12 O13 O14 O15 O16
global W_cyc

s1=size(eval(['AK' int2str(l)]),1);
s2=size(eval(['AK' int2str(l-1)]),1);
s1=s1-s2;
W_cyc=[W_cyc;l];
eval(['A=AK' int2str(l) '(O' int2str(l) ',O' int2str(l) ');']); %permute
A11=A(1:s1,1:s1);
A12=A(1:s1,s1+1:s1+s2);
A21=A(s1+1:s1+s2,1:s1);
A22=A(s1+1:s1+s2,s1+1:s1+s2);
B11w=eval(['BK' int2str(l)]);
r=eval(['rhs(O' int2str(l) ')']); %permute
%disp(' going down --->')
r1=r(1:s1,1); r2=r(s1+1:s1+s2,:);
y1 = B11w*r1;
y2 = r2 - A21*y1;
l=l-1;
if l==lvl_coars,
   eval(['x2=AK' int2str(l) '\y2;'])
   W_cyc=[W_cyc;l];%disp('... at the bottom.')
else
   coef=-Q(l,lvl_deg(l)+1);
   x2=amli_recur(coef*y2,lvl_deg,Q,levels,lvl_coars,l,W_cyc);
   for i=1:lvl_deg(l)-1,
%       disp('amli:internal loop:'),i,lvl_deg(l)
       coef=-Q(l,lvl_deg(l)-i+1);
       wr=eval(['AK' int2str(l)])*x2 + coef*y2;
       x2=amli_recur(wr,lvl_deg,Q,levels,lvl_coars,l,W_cyc);
%       disp(' return from amli'),l
   end
end
l=l+1;
%disp(' <--- going up')
W_cyc=[W_cyc;l];
x1 = y1 - B11w*A12*x2;
eval(['x = amli_repermut([x1;x2],O' int2str(l) ');']); %repermute
return
	 

     
