% Generate 2D 5-point discretization matrix
% nx, ny - number of gridpoints in x- and y-directions
% column-wise ordering of the nodepoints
%------------------------------------------------------
function [m,e,w,n,s]=pattern(k,l,Ppls,Pmin,Qpls,Qmin,nx,ny)
global BC

e = -Ppls;
w = -Pmin;
n = -Qpls;
s = -Qmin;
m = Ppls + Pmin + Qpls + Qmin;
% ----------------------------------- internal point
if (k>1)&(k<nx)&(l>1)&(l<ny), return,end
% ----------------------------------- (next-to-a-)boundary point
% ----------------------------------- along x=0 without corner points	
if (k==1)&(l>1)&(l<ny),
   if BC(1)==1  ,      % Dirichlet b.c.
%     r = r - USOL(x-hstep,y)*w;
     w = 0.;
   else                % Neumann   b.c.
     m = Ppls + 0.5*Qmin + 0.5*Qpls;
     s = -0.5*Qmin;
     n = -0.5*Qpls;
     w = 0.;
   end
   return
end
% ----------------------------------- along x=1 without corner points
if (k==nx)&(l>1)&(l<ny) 
  if (BC(3)==1)  % Dirichlet b.c.
%    r = r - USOL(x+hstep,y)*e;
    e = 0.;
  else          % Neumann   b.c.
    m = Pmin + 0.5*Qmin + 0.5*Qpls;
    s = -0.5*Qmin;
    n = -0.5*Qpls;
    e = 0.;
  end
  return
end

% ----------------------------------- along y=0 without corner points
if (l==1)&(k>1)&(k<nx), 
  if (BC(4)==1)  % Dirichlet b.c.
%    r = r - USOL(x,y-hstep)*s;
    s = 0.;
  else                % Neumann   b.c.
    m = 0.5*Pmin + 0.5*Ppls + Qpls;
    w = -0.5*Pmin;
    e = -0.5*Ppls;
    s = 0.;
  end
  return
end
% ----------------------------------- along y=1 without corner points
if (l==ny)&(k>1)&(k<nx), 
  if (BC(2)==1)  % Dirichlet b.c.
%    r = r - USOL(x,y+hstep)*n;
    n = 0.;
  else                % Neumann   b.c.
    m = 0.5*Pmin + 0.5*Ppls + Qmin;
    w = -0.5*Pmin;
    e = -0.5*Ppls;
    n = 0.;
  end
  return
end
% ----------------------------------- x=0,y=0 (corner point)
if (k==1)&(l==1), 
  if (BC(1)==1)&(BC(4)==1), 
%    r = r - USOL(x-hstep,y)*w - USOL(x,y-hstep)*s;
    w = 0.;
    s = 0.;
    return
end
  if (BC(1)==1)&(BC(4)==0), 
    m = 0.5*Pmin + 0.5*Ppls + Qpls;
    e = -0.5*Ppls;
    s = 0.;
    w = 0.;
%    r = r + USOL(x-hstep,y)*0.5*Pmin;
    return
  end

  if (BC(1)==0)&(BC(4)==1), 
    m = Ppls + 0.5*Qmin + 0.5*Qpls;
    n = -0.5*Qpls;
    s = 0.;
    w = 0.;
%    r = r + USOL(x,y-hstep)*0.5*Qmin;
    return 
  end

  if (BC(1)==0)&(BC(4)==0), 
    m = 0.5*Ppls + 0.5*Qpls;
    e = -0.5*Ppls;
    n = -0.5*Qpls;
    s = 0.;
    w = 0.;
    return 
  end
end
% ----------------------------------- x=1,y=0 (corner point)
if (k==nx)&(l==1), 
  if (BC(3)==1)&(BC(4)==1),  
%    r = r - USOL(x+hstep,y)*e - USOL(x,y-hstep)*s;
    e = 0.;
    s = 0.;
    return
end
  if (BC(3)==1)&(BC(4)==0), 
    m = 0.5*Pmin + 0.5*Ppls + Qpls;
    w = -0.5*Pmin;
    s = 0.;
    e = 0.;
%    r = r + USOL(x+hstep,y)*0.5*Ppls;
    return
  end
  if (BC(3)==0)&(BC(4)==1), 
    m = Pmin + 0.5*Qmin + 0.5*Qpls;
    n = -0.5*Qpls;
    s = 0.;
    e = 0.;
%    r = r + USOL(x,y-hstep)*0.5*Qmin;
    return 
  end
  if (BC(3)==0)&(BC(4)==0), 
    m = 0.5*Pmin + 0.5*Qpls;
    w = -0.5*Pmin;
    n = -0.5*Qpls;
    s = 0.;
    e = 0.;
    return
  end
end
% ----------------------------------- x=0,y=1 (corner point)
if (k==1)&(l==ny), 
  if (BC(1)==1)&(BC(2)==1), 
%    r = r - USOL(x-hstep,y)*w - USOL(x,y+hstep)*n;
    w = 0.;
    n = 0.;
    return
end
  if (BC(1)==1)&(BC(2)==0), 
    m = 0.5*Pmin + 0.5*Ppls + Qmin;
    e = -0.5*Ppls;
    n = 0.;
    w = 0.;
%    r = r + USOL(x-hstep,y)*0.5*Pmin;
    return
  end
  if (BC(1)==0)&(BC(2)==1), 
    m = Ppls + 0.5*Qmin + 0.5*Qpls;
    s = -0.5*Qmin;
    n = 0.;
    w = 0.;
%    r = r + USOL(x,y+hstep)*0.5*Qpls;
    return 
  end
  if (BC(1)==0)&(BC(2)==0), 
    m = 0.5*Ppls + 0.5*Qmin;
    e = -0.5*Ppls;
    s = -0.5*Qmin;
    n = 0.;
    w = 0.;
    return 
  end
end
% ----------------------------------- x=1,y=1 (corner point)
if (k==nx)&(l==ny), 
  if (BC(2)==1)&(BC(3)==1), 
%    r = r - USOL(x+hstep,y)*e - USOL(x,y+hstep)*n;
    e = 0.;
    n = 0.;
    return
end
  if (BC(2)==1)&(BC(3)==0), 
    m = Pmin + 0.5*Qmin + 0.5*Qpls;
    s = -0.5*Qmin;
    n = 0.;
    e = 0.;
%    r = r + USOL(x,y+hstep)*0.5*Qpls;
    return
  end
  if (BC(2)==0)&(BC(3)==1), 
    m = 0.5*Pmin + 0.5*Ppls + Qmin;
    w = -0.5*Pmin;
    n = 0.;
    e = 0.;
%    r = r + USOL(x+hstep,y)*0.5*Ppls;
    return
  end
  if (BC(2)==0)&(BC(3)==0),
    m = 0.5*Pmin + 0.5*Qmin;
    w = -0.5*Pmin;
    s = -0.5*Qmin;
    n = 0.;
    e = 0.;
    return
  end
end
%
