function [lanmax,it]=amli_lanczos(Q,lvl_deg,levels,lvl_coars,l)
% Preconditioned Lanczos algorithm (AMLI preconditioning)
%
global AK1 AK2 AK3 AK4 AK5 AK6 AK7 AK8 AK9 AK10
global AK11 AK12 AK13 AK14 AK15 AK16
global O1 O2 O3 O4 O5 O6 O7 O8 O9 O10 O11 O12 O13 O14 O15 O16
global W_cyc

W_cyc=[];
eps_cmp=0.01;
lanmax=100000;
s=size(eval(['AK' int2str(l)]),1);
d(:,1)=rand(s,1); d(:,1)=d(:,1)/norm(d(:,1)); % normalized
eval(['g=AK' int2str(l) '*d(:,1);'])
h=amli_recur(g,lvl_deg,Q,levels,lvl_coars,l,W_cyc);
delta(1)=d(:,1)'*g;      %disp(['delta ',num2str(delta(1))])
alfa(1)=(h'*g)/delta(1); %disp(['alfa ',num2str(alfa(1))])
beta(1)=0;
d(:,2)=h-alfa(1)*d(:,1);
it=2; T(1,1)=alfa(1);
% ----------------------
while it<s,
     eval(['g=AK' int2str(l) '*d(:,it);'])
     h=amli_recur(g,lvl_deg,Q,levels,lvl_coars,l,W_cyc);
     delta(it)=d(:,it)'*g;      %disp(['delta ',num2str(delta(it))])
     alfa(it)=(h'*g)/delta(it); %disp(['alfa ',num2str(alfa(it))])
     beta(it)=delta(it)/delta(it-1);
     T(it,it)=alfa(it);T(it,it-1)=1;T(it-1,it)=beta(it);
     if it>1,
        clear e, e=sort(eig(T));
        if abs(lanmax-max(e))<eps_cmp, it=it-1;return, end
        lanmax = max(e);
     end
     d(:,it+1)=h-alfa(it)*d(:,it)-beta(it)*d(:,it-1);
     it=it+1;
end
it=it-1;
	 

     
