function amli_genmatr2D(nx,ny,h,lvl_total)
% Generate 2D 5-point discretization matrix
% nx, ny - number of gridpoints in x- and y-directions
% column-wise ordering of the nodepoints
%------------------------------------------------------
global AK1  AK2  AK3  AK4  AK5  AK6  AK7  AK8 AK9 AK10
global AK11 AK12 AK13 AK14 AK15 AK16

n=nx*ny;
hhalf=0.5*h;

for k=1:nx+1
  for l=1:ny+1
      x = amli_coX(k,h); 
      y = amli_coY(l,h);
      Ph(k,l) = 0.5*(amli_k(x-hhalf,y-hhalf)+amli_k(x-hhalf,y+hhalf));
      Qh(k,l) = 0.5*(amli_k(x-hhalf,y-hhalf)+amli_k(x+hhalf,y-hhalf));
  end
end

eval(['AK' int2str(lvl_total) '=spalloc(n,n,5*n);'])
for k=1:nx
  for l=1:ny
    ind=(k-1)*ny+l;
    [m,e,w,n,s]=amli_pattern(k,l,Ph(k+1,l),Ph(k,l),Qh(k,l+1),Qh(k,l),nx,ny);
%    disp([int2str(k) ',' int2str(l) ',' int2str(ind) ',' ...
%num2str(m) ',' num2str(e) ',' num2str(w) ',' ...
%num2str(n) ',' num2str(s)]),pause
% -----------------------------------------------  middle :
    eval(['AK' int2str(lvl_total) '(ind,ind)=m;'])
% -----------------------------------------------  west : 
    if w~=0, eval(['AK' int2str(lvl_total) '(ind,ind-ny)=w;']), end
% -----------------------------------------------  south:
    if s~=0, eval(['AK' int2str(lvl_total) '(ind,ind-1) =s;']), end
% -----------------------------------------------  north :
    if n~=0, eval(['AK' int2str(lvl_total) '(ind,ind+1) =n;']), end
% -----------------------------------------------  east :
    if e~=0, eval(['AK' int2str(lvl_total) '(ind,ind+ny)=e;']), end
  end
end
return

