function Q=amli_coeffs(levels,lvl_coars,lvl_deg,mju,nju)
% Compute the polynomial coefficients for each level
% using the Lanczos algorithm
Q=[ones(levels,1) zeros(levels,nju)];
disp('')
if (nju==1)&(mju==0 | mju==1),
   disp('The polynomial coefficients:')
   for i=lvl_coars+1:levels, Q(i,1)=1; Q(i,2)=-1; end
for k=lvl_coars+1:levels, ww='';for l=1:nju+1,ww=[ww,num2str(Q(k,l)),' '];end
disp(['level ',sprintf('%2i',k),' Q(k,:) ',ww]),end
return
end
%
eps_mov=0.01;upper = 1 + eps_mov/2;
disp('            The Lanczos process:')
disp(['level no.  ',': '...
  'iter./ smallest / largest  / cond.number'])

Q(lvl_coars,1)=1; Q(lvl_coars,2)=-1;
thigh=1;tlow=1;tlow_old=tlow;
 for levcur=lvl_coars+1:levels-1,
%%     if lvl_deg(levcur)==1, 
%%        Q(levcur,1)=1; Q(levcur,2)=-1; tlow=1;tlow_old=tlow;
%%     else
         tlow = 1 - Q(levcur-1,1);
         for k=2:lvl_deg(levcur-1)+1,
             tlow = tlow - Q(levcur-1,k)*(tlow_old^(k-1));
         end
         tlow_old=tlow;
         [thigh,lit] = amli_lanczos(Q,lvl_deg,levels,lvl_coars,levcur);
         thigh = thigh*upper;
         disp(['On level ',sprintf('%2i',levcur),': '...
  'it=' sprintf('%2i',lit) '/ ' ...
sprintf('%8.5f',tlow),' / ',sprintf('%8.5f',thigh),' / ',sprintf('%8.5f',thigh/tlow)])
%  num2str(tlow),' / ',num2str(thigh),' / ',num2str(thigh/tlow)])
         vecQ=amli_clcq(tlow,thigh,lvl_deg(levcur));
   if size(vecQ,2)<size(Q,2), vecQ=[vecQ zeros(1,size(Q,2)-size(vecQ,2))];end
         Q(levcur,:)=vecQ;
%     end
 end
%
disp('')
%disp('The polynomial coefficients:')
%for k=lvl_coars+1:levels, ww='';for l=1:nju+1,ww=[ww,num2str(Q(k,l)),' '];end
%disp(['level:',int2str(k),' Q(k,:) ',ww]),end
