function vecQ=amli_clcq(tlow,thigh,deg)
% Compute the polynomial coefficients 
% (normalized and shifted Chebyshev polynomials)
vecQ(1)=1.0;
if deg==1
   vecQ(2)=-1.0/thigh;
   return
end
b = thigh - tlow;
a = (thigh + tlow)/b;
c = amli_t(a,deg)+1.0;

if deg==2
   vecQ(2)=-8.0*a/(b*c);
   vecQ(3)= 8.0/(b^2*c);
   return
end
if deg==3
   vecQ(2) = -6.0/b*(4.0*a^2-1.0)/c;
   vecQ(3) =  48.0*a/(b^2*c);
   vecQ(4) = -32.0/(b^3*c);
end
%
