function [it,y,arf]=amli_amlpcg(A,rhs,Q,lvl_deg,levels,lvl_coars,eps_pcg)
%Implementation of the preconditioned Conjugate Gradient method
%with a matrix A and AMLI preconditioning
%Parameters: y0-initial guess; rhs-right_hand_side; y-the computed solution

global W_cyc

it=1; row=size(A,1);
% an extra step for the initial guess y0, computed as M*y0=rhs
%y0=amli_recur(rhs,lvl_deg,Q,levels,levels,W_cyc);
y0=zeros(row,1);
y=y0;
g=A*y-rhs;norm_r0=norm(g);
h=amli_recur(g,lvl_deg,Q,levels,lvl_coars,levels,W_cyc);
d=-h;
qq0=g'*h;
disp(['___________amlpcg_delta0:',num2str(qq0)])
ceps = eps_pcg*qq0;
qq1=100000;
    while ((it < row+1)&(qq1>eps_pcg)),
        h=A*d;
        tau=qq0/(d'*h);
        y=y+tau*d;
        g=g+tau*h;norm_r=norm(g);
        W_cyc=[];
        h=amli_recur(g,lvl_deg,Q,levels,lvl_coars,levels,W_cyc);
        qq1=g'*h;
        disp(['___________amlpcg_delta1:',num2str(qq1)])
        beta=qq1/qq0;
        d=-h+beta*d;
        it=it+1;
        qq0=qq1;
    end
it=it-1;arf=(norm_r/norm_r0)^(1/it);
end
plot(W_cyc),ylabel('level no.')	 

     
