%                Preconditioned conjugate gradient method 
%                             with
%      Algebraic Multilevel Iteration (AMLI) preconditioning
% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
% Test problem: Two-dimensional Laplacian on a unit square
%               Exact solution: xy(1-x)(1-y)exp(xy)
%-------------------------------------------------------------
%      Stages:
% I.   Preparation
%  1.  Generate the matrix on the finest level
%  2.  Generate the preconditioner
%  2.1 Generate the level matrices
%  2.2 Compute the polynomial coefficients
% II.  Solution of the system
% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
%      Input parameters:
% n:   discretization parameter (h=1/n)
% mju: number of levels with polynomials of degree one
% nju: polynomial degree to be used 
%
% -------------------------------------------------------------------------
clear A mju nju rhs u_sol h n s lvl_len lvl_deg Q
clear global

disp('              ===================================')
disp('                       AMLI preconditioning      ')
disp('              ===================================')

global BC W_cyc
lvl_coars = 1;
%BC=[1 1 1 1]; 
BC=[1 0 0 1];
%BC=[1 1 1 0];
%BC=[1 0 0 0];
fl=amli_bcprov; if fl==1, return, end

s=input('How many times to refine (in one direction)? <2^s> ');
n=2^s;
h=1/n; h2=h*h; 
nanrx=amli_xnode(n); nanry=amli_ynode(n);nall=nanrx*nanry;

% ------------- AKi - AMLI precond. submatrices for the whole matrix A
global AK1  AK2  AK3  AK4  AK5  AK6  AK7  AK8 AK9 AK10
global AK11 AK12 AK13 AK14 AK15 AK16
global BK1  BK2  BK3  BK4  BK5  BK6  BK7  BK8 BK9 BK10 
global BK11 BK12 BK13 BK14 BK15 BK16
global O1 O2 O3 O4 O5 O6 O7 O8 O9 O10 O11 O12 O13 O14 O15 O16

% -----------------create the matrix A on the finest level ----------
lvl_total=amli_deflvl(nall);
amli_genmatr2D(nanrx,nanry,h,lvl_total);

disp('Choose the degrees of the polynomials for AMLI:')
  mju=input('mju:? '); nju=input('nju:? ');

disp(' Constructing the preconditioner for PCG:')
[lvl_len]=amli_vectors(lvl_total,lvl_coars,nanrx,nanry);
disp('     AMLI matrices lengths:')
disp(['Level no.  :   A   A11   A22'])
for lv=lvl_total:-1:lvl_coars
    disp(['On level ',sprintf('%2i',lv),':',sprintf('%4i',lvl_len(lv,1)),' ',...
    sprintf('%4i',lvl_len(lv,2)),' ',sprintf('%4i',lvl_len(lv,3))])
end
amli_blocks(lvl_len,lvl_total,lvl_coars);
disp('The blocks of the preconditioner are ready.'),amli_wait

%-------------- Compute the polynomial_coefficients Q_PCG;
lvl_deg=ones(lvl_total,1);
for i=lvl_total-mju:-(mju+1):lvl_coars+1, 
    lvl_deg(i)=nju; end
Q=amli_coeffs(lvl_total,lvl_coars,lvl_deg,mju,nju);
disp('The polynomial coefficients computed.'),amli_wait
%
% -------------- Exact solution, rhs ....
for k=1:nanrx,
  x = amli_coX(k,h);
  for l=1:nanry,
     y = amli_coY(l,h);
     ind = (k-1)*nanry+l;
     u_sol(ind,1) = x*y*(1-x)*(1-y)*exp(x*y);
  end
end
eval(['rhs    = AK' int2str(lvl_total) '*u_sol;'])
% -------------- Now solve ....
eps_pcg = 10^(-12);
eval(['[it_pcg,u_iter,arf]=amli_amlpcg(AK' int2str(lvl_total) ...
      ',rhs,Q,lvl_deg,lvl_total,lvl_coars,eps_pcg);'])

disp('***********************************************************')
disp(['Number of PCG iterations :' int2str(it_pcg)])
disp(['         ||u_sol-u_iter||=' num2str(norm(u_sol-u_iter))])
disp(['Average reduction factor :' num2str(arf)])
disp('***********************************************************')
disp('                             Implemented by Maya Neytcheva ')
disp('                                     (neytchev@sci.kun.nl) ')
return
