#include <sys/types.h>
#include <netinet/in.h>

#include "../htool/tfnew.h"
#include "tfwrite.h"

int
tfwrite_section_hdr (fd, type, nrec, reclen, vers)
int fd, type, nrec, reclen, vers;
{
    struct section_hdr buf;

    buf.section_type = htonl (type);
    buf.record_count = htonl (nrec);
    buf.record_length = htonl (reclen);
    buf.version_number = htonl (vers);
    return (write (fd, &buf, sizeof buf));
}

int
tfwrite_hdr_rec (fd, s)
char *s;
{
    struct hdr_rec buf;

    strncpy (buf.version, s, sizeof (buf.version));
    buf.version[sizeof(buf.version) - 1] = '\0';
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_machine_rec (fd, m)
char *m;
{
    struct machine_rec buf;

    strncpy (buf.machine_name, m, sizeof (buf.machine_name));
    buf.machine_name[sizeof(buf.machine_name) - 1] = '\0';
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_subr_rec (fd, s)
char *s;
{
    struct subr_rec buf;

    strncpy (buf.subr_name, s, sizeof (buf.subr_name));
    buf.subr_name[sizeof(buf.subr_name) - 1] = '\0';
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_node_rec (fd, node_id, node_type, x, y, subr_number)
int fd, node_id, node_type, x, y, subr_number;
{
    struct node_rec buf;

    buf.node_number = htons ((unsigned short) node_id);
    buf.node_type = htons ((unsigned short) node_type);
    buf.x = htons ((unsigned short) x);
    buf.y = htons ((unsigned short) y);
    buf.subr_number = htons ((unsigned short) subr_number);
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_link_rec (fd, from_node, to_node)
int fd, from_node, to_node;
{
    struct link_rec buf;

    buf.from_node = htons ((unsigned short) from_node);
    buf.to_node = htons ((unsigned short) to_node);
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_cost_rec (fd, host, subr, cost)
int fd, host, subr, cost;
{
    struct cost_rec buf;

    buf.host_number = htons ((unsigned short) host);
    buf.subr_number = htons ((unsigned short) subr);
    buf.cost = htonl ((unsigned int) cost);
    return (write (fd, &buf, sizeof (buf)));
}

int
tfwrite_event_rec (fd, event)
struct event_rec *event;
{
    struct event_rec buf;

    buf.sequence = htonl (event->sequence);
    buf.seconds = htonl (event->seconds);
    buf.msec = htons (event->msec);
    buf.event_type = event->event_type;
    buf.state = event->state;
    buf.node_number = htons (event->node_number);
    buf.machine_number = htons (event->machine_number);
    buf.inst_number = htonl (event->inst_number);
    buf.lower_bound = htonl (event->lower_bound);
    buf.upper_bound = htonl (event->upper_bound);
    buf.num_running = htons (event->num_running);
    buf.num_idle = htons (event->num_idle);
    return (write (fd, &buf, sizeof (buf)));
}
