/*
 * $Source: /wayward/homes/moore/src/hence2/master/RCS/master.c,v $
 * $Revision: 1.2 $
 * $Date: 1994/06/11 21:03:05 $
 * $Author: moore $
 */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "dlist.h"
#include "rb.h"
#include "hence.h"

char *debug_host;
char *debug_subr;

fprint_usage(f)
FILE *f;
{
  fprintf(f, "Usage:\n");
  fprintf(f, "  master \n");
  fprintf(f, "    <graph-file>                 { or %s for standard input }\n",
          "\"-\"");
  fprintf(f, "    [ -cm <cost-matrix-file> ]   { default is cost.mat }\n");
  fprintf(f, "    [ -tf <trace-file> ]         { default (or \"-\") %s}\n",
             "is stdout. \"-2\" is stderr");
  fprintf(f, "    [ -nt ]                      { for no tracing }\n");
  fprintf(f, "    [ -trp ]                     { for tracing parameters }\n");
  fprintf(f, "    [ -trm ]                     { for tracing pvm messages }\n");
  fprintf(f, "    [ ? ]                        { To get this message }\n");
}

main(argc, argv)
int argc;
char **argv;
{
  int i;
  Graph G;
  char *getenv ();
  int verbose = 0;

  /* Make the graph structure */

  G = talloc(struct graph, 1);
  G->nlist = make_rb();
  G->heads = make_rb();
  G->numnodes = 0;
  G->numdone = 0;
  G->numexecuting = 0;
  G->cost_mat = CNULL;
  G->trace_file = CNULL;
  G->graph_file = CNULL;
  G->subroutines = make_rb();
  G->machines = make_rb();
  G->alive = make_rb();
  G->readyq = make_dl();
  G->trace_msgs = 0;

#ifndef POSTMORTEM
  (void) signal(SIGSEGV, segv_catch);
#endif

  /* Evaluate command line arguments */
  for (i = 1; i < argc; i++) {
    if (strcmp (argv[i], "-verbose") == 0) {
      verbose = 1;
      continue;
    }
    if (strcmp(argv[i], "-cm") == 0) {
      if (G->cost_mat != CNULL) {
        fprintf(stderr, "Error: two cost matrix names given: %s and %s\n\n",
                G->cost_mat, argv[i]);
        fprint_usage(stderr);
        exit(1);
      }
      i++;
      if (i == argc) {
        fprint_usage(stderr);
        exit(1);
      } else {
       G->cost_mat = argv[i];
      }
    } else if (strcmp(argv[i], "-tf") == 0) {
      if (G->trace_file != CNULL) {
        fprintf(stderr, "Error: two trace file names given: %s and %s\n\n",
                G->trace_file, argv[i]);
        fprint_usage(stderr);
        exit(1);
      }
      i++;
      if (i == argc) {
        fprint_usage(stderr);
        exit(1);
      } else {
	set_trace_on (1);
        G->trace_file = argv[i];
      }
    } else if (strcmp(argv[i], "-trm") == 0) {
      G->trace_msgs = 1;
      set_trace_msgs();
    } else if (strcmp(argv[i], "-trp") == 0) {
    } else if (strcmp(argv[i], "-trp") == 0) {
      set_trace_params(1);
    } else if (strcmp(argv[i], "?") == 0) {
      fprint_usage(stdout);
      exit(0);
    } else if (G->graph_file == CNULL) {
      G->graph_file = argv[i];
    } else {
      fprintf(stderr, "Error: two graph-file names given: %s and %s\n\n",
              G->graph_file, argv[i]);
      fprint_usage(stderr);
      exit(1);
    } 
  }

  if (G->graph_file == CNULL) {
    fprintf(stderr, "Error: No graph-file specified\n\n");
    fprint_usage(stderr);
    exit(1);
  } 

  /* XXX DEBUG HACK */

  if (getenv ("HENCE_DEBUG_HOST"))
      debug_host = getenv ("HENCE_DEBUG_HOST");
  if (getenv ("HENCE_DEBUG_SUBR"))
      debug_subr = getenv ("HENCE_DEBUG_SUBR");

  set_trace_file(G->trace_file);

  exp_initialize();
  arc_initialize();
  grparse(G);
  check_graph(G);
  if (verbose)
      print_nodes(G);
  else {
      Rb_node p;
      rb_traverse (p, G->heads) clear_flags ((Node) p->v.val);
  }
  read_cm(G);
  execute(G);  
  if (verbose)
      print_costs(G);
  exit(0);
  return 0;
}  

char *sl_id()
{
  return "Master: ";
}

