#include "CanvasP.h"


#include <Malloc.h>

/*	xgr_Init()
 *
 *	Must be called once at startup time
 *	Creates pixmaps and GCs used for drawing graphs.
 */

void
xgr_Init(w)
Widget w;
{
}

/*
 *	xgr_DrawGrf()
 *
 *	Redraw all nodes and arcs in a graph
 */

void
xgr_DrawGrf (win, g, tracemode)
Window win;
Graph g;
int tracemode;
{
    rbTree ntree = g->nlist;
    rbTree atree;
    rbNode tn, atn;
    rbNode n1, n2;

    for (tn = rb_First (ntree); !rb_Done (tn, ntree) ; tn = rb_Next (tn)) {
	xgr_DrawNode (win, (Node) rb_Value (tn), tracemode ? -1 : 1);
    }
    for (tn = rb_First (ntree); !rb_Done (tn, ntree); tn = rb_Next (tn)) {
	n1 = (Node) rb_Value(tn);
	atree = n1->children;
	for (atn = rb_First (atree); !rb_Done (atn, atree) ;
	     atn = rb_Next (atn)) {
	    n2 = (Node) rb_Value(atn);
	    xgr_DrawArc (win, n1, n2, 1);
	}
    }
#if 0
    /* XXX for debugging pair-finding */
    for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
	n1 = (Node)rb_Value(tn);
	if (n2 = n1->pair) {
	    if (n1->xy.set && n2->xy.set)
		XDrawLine(xDisp, win, gcs[GCNORMAL],
			  n1->xy.x + 10, n1->xy.y, n2->xy.x, n2->xy.y);
	}
    }
#endif
}


/*
 *	xgr_DrawNode()
 *
 *	Draw a node icon in a window.  abs(how) is
 *		0 to erase
 *		1 to draw
 *		2 to draw via xor
 *
 * If how is negative, it means to print trace info.
 */

void
xgr_DrawNode(win, node, how)
Window win;
Node node;
int how;
{
    int x = node->xy.x;
    int y = node->xy.y;
    int t = node->node_type;
    GC tgc;
    GC bgc;
    Pixmap npm;
    int tracing = 0;

    if (how < 0) {
	how = -how;
	tracing = 1;
    }

    if (how != 2) {
	if (how) {
	    tgc = gcs[GCNORMAL];
	    if (inColor)
		bgc = gcs[node->state];
	    else
		bgc = gcs[GCNORMAL];	/* XXX todo b&w */
	    
	} else {
	    tgc = gcs[GCCLEAR];
	    bgc = gcs[GCCLEAR];
	}
	
	if (t != NODE_NORMAL)
	    npm = nodeics[t].pmap;
	else {
	    switch (node->state) {
	    case ST_READY:
		npm = no_ready_pm;
		break;
	    case ST_RUNNING:
		if (click)
		    npm = no_run1_pm;
		else
		    npm = no_run2_pm;
		click = !click;
		break;
	    case ST_DONE:
		npm = no_done_pm;
		break;
	    case ST_DEAD:
		npm = no_dead_pm;
		break;
	    case ST_WARNING:
		npm = no_warn_pm;
		break;
	    case ST_ERROR:
		npm = no_error_pm;
		break;
	    default:
		bgc = gcs[GCNOTREADY];
		npm = no_pm;
		break;
	    }
	}
	xdraw_Bitmap (win, npm, bgc, nodeics[t].wd, nodeics[t].ht, x, y);

	if (node->nk.id >= 0) {
	    if (tracing) {
		if (node->nk.inst)
		    (void)sprintf(crud, "%s%s%s%d/%d",
				  node->sub_name ? "(" : "",
				  node->sub_name ? node->sub_name : "",
				  node->sub_name ? ") " : "",
				  node->nk.id, node->nk.inst);
		else
		    (void)sprintf(crud, "%s%s%s%d",
				  node->sub_name ? "(" : "",
				  node->sub_name ? node->sub_name : "",
				  node->sub_name ? ") " : "",
				  node->nk.id);
		
		xdraw_Text (win, tgc,
			    x - NODERADIUS - 4 - xdraw_StringWidth (tgc, crud),
			    y + xdraw_TextHeight (tgc) / 2, crud);
		if (node->node_type == NODE_NORMAL) {
		    sprintf (crud, "%dr,%di  ", node->numRunning,
			     node->numIdle);
		    xdraw_Text (win, tgc, x + NODERADIUS + 4,
				y + xdraw_TextHeight (tgc) / 2, crud);
		}
	    }
	    else {
		if (node->nk.inst)
		    (void)sprintf(crud, "%d/%d", node->nk.id, node->nk.inst);
		else
		    (void)sprintf(crud, "%d", node->nk.id);
		
		xdraw_Text (win, tgc,
			    x - NODERADIUS - 4 - xdraw_StringWidth (tgc, crud),
			    y +  xdraw_TextHeight (tgc) / 2, crud);
		if (node->node_type == NODE_NORMAL) {
		    if (node->sub_name) {
			xdraw_Text (win, tgc, x + NODERADIUS + 4,
				    y + xdraw_TextHeight (tgc) / 2,
				    node->sub_name);
		    }
		}
	    }
	}
    } else {	/* rubber drawing */
	xdraw_Bitmap (win, nodeics[t].pmap, gcs[GCXOR],
		      nodeics[t].wd, nodeics[t].ht, x, y);
    }
}
