/*
 * extension to UNIX system calls to handle tilde prefixes
 */

#include <stdio.h>		/* XXX get rid of this */
#include <pwd.h>

#include <X11/Xos.h>
#if defined(IMA_SYMM) || defined(IMA_RT) || defined(IMA_NEXT)
#include <sys/types.h>
#include <sys/dir.h>
#else
#include <dirent.h>
#endif

/*
 * from Bondo...
 */
#include <Errno.h>
#include <Malloc.h>

#ifdef strchr
#undef strchr
#endif
#ifdef strrchr
#undef strrchr
#endif

char *
texpand (filename)
char *filename;
{
    struct passwd *pw = NULL;
    static char namebuf[1025];

    if (filename == NULL)
	return NULL;
    if (*filename == '~') {
	char *ptr;
	char *strchr();

	if (filename[1] == '/' || filename[1] == '\0') {
	    pw = getpwuid (getuid ());
	    ptr = filename + 1;
	}
	else {
	    char buf[256];

	    ptr = strchr (filename + 1, '/');
	    if (ptr) {		/* ~user/stuff */
		strncpy (buf, filename + 1, ptr - (filename + 1));
		buf[ptr - (filename + 1)] = '\0';
	    }
	    else {		/* ~user (no trailing '/') */
		strncpy (buf, filename + 1, sizeof (buf));
		ptr = "";
	    }
	    pw = getpwnam (buf);
#if 1
	    if (pw == NULL)
		fprintf (stderr, "getpwnam (%s) failed\n", buf);
#endif
	}
	if (pw != NULL) {
	    strcpy (namebuf, pw->pw_dir);
	    strcat (namebuf, ptr);
	    return namebuf;
	}
    }
    strncpy (namebuf, filename, sizeof namebuf);
    return namebuf;
}

void *
topendir (dir)
char *dir;
{
    char *newdir = NULL;
    newdir = texpand (dir);
    return newdir ? (void *) opendir (newdir) : NULL;
}

int
tstat (file, sbuf)
char *file;
struct stat *sbuf;
{
    return stat (texpand (file), sbuf);
}

int
taccess (file, mode)
char *file;
int mode;
{
    return access (texpand (file), mode);
}

FILE *
tfopen (file, mode)
char *file, *mode;
{
    return fopen (texpand (file), mode);
}
