/*
 * htool version 2.x
 * Keith Moore
 *
 * $Id: pvm_panel.c,v 1.1 1994/02/17 21:35:05 moore Exp $
 *
 * $Log: pvm_panel.c,v $
 * Revision 1.1  1994/02/17  21:35:05  moore
 * Initial revision
 *
 */

#include <stdio.h>
#include <varargs.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "build.h"
#include "config.h"
#include "filenames.h"
#include "FileSelect.h"
#include "global.h"
#include "histo.h"
#include "menu.h"
#include "pvmglue.h"
#include "text_sink.h"

#ifdef USE_ASCII_TEXT_WIDGET
#include <X11/Xaw/AsciiText.h>
#else
#include "Canvas.h"
#endif

#include <Malloc.h>

#define XtVaCMW XtVaCreateManagedWidget

static void
set_trace_file (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    char traceFile[1024];
    FILE *fp;

    strcpy (traceFile, make_pretty (global.traceFile));
    if (fileVerify ("Save HeNCE execution trace data in...",
		    traceFile, sizeof (traceFile), "*.trace",
		    FS_RegularFile | FS_MustBeWritable) == 0) {
	strcpy (global.traceFile, traceFile);
	set_tracefile_label (make_pretty (global.traceFile), 0);
    }
}

static struct menu_entry pvm_build_menu[] = {
    { "c", "Build",		(XtCallbackProc) build_Everything, (void *)0 },
    { "c", "Build w/Debug",	(XtCallbackProc) build_Everything, (void *)1 },
    { "c", "Clean", },
#if 0
    { "c", "Write Wrappers",	(XtCallbackProc) build_WriteWrappers },
    { "c", "Write Makefile", 	(XtCallbackProc) build_WriteMakefile },
#endif
    { NULL, NULL, NULL },
};

static struct menu_entry pvm_run_menu[] = {
    { "c",	"Set Trace File", (XtCallbackProc) set_trace_file },
    { "c",     	"Run Program",	  (XtCallbackProc) pvm_RunProgram },
    { "e",	"Kill Program",	  (XtCallbackProc) pvm_KillProgram },
    { "e",	"Exit Run Mode",  (XtCallbackProc) pvm_ExitRunMode },
    { NULL, NULL},
};


static struct menu_entry pvm_pvm_menu[] = {
    { "c",	"Show Status",         (XtCallbackProc) pvm_Status },
    { "c",	"Show Config",         (XtCallbackProc) pvm_ShowConfig },
    { "c",	"Kill All Processes",  (XtCallbackProc) pvm_KillAll },
    { "c",	"Halt PVM",            (XtCallbackProc) pvm_Halt },
    { NULL, NULL },
};



void
make_pvm_panel (parent, height, width)
Widget parent;
{
    Widget pvmTitle, pvmPanel, w;
    char *modes;

    pvmTitle = XtVaCMW ("title", labelWidgetClass, parent,
			XtNlabel, "PVM console",
			XtNwidth, width,
			XtNresizable, False,
			XtNforeground, defaults.titleForeground,
			XtNbackground, defaults.titleBackground,
			/* form constraints */
			XtNtop, XtChainTop,
			XtNbottom, XtChainTop,
			XtNleft, XtChainLeft,
			XtNright, XtChainRight,
			NULL);

		 
#ifdef EXTRA_HELP_BUTTON
    w = XtVaCMW ("menu.help", commandWidgetClass, parent,
		 XtNlabel, "Help",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
		 NULL);
#endif

    modes = make_menu ("pvmFileMenu", pvm_file_menu);

    w = XtVaCMW ("menu.file", menuButtonWidgetClass, parent,
		 XtNlabel, "File",
		 XtNmenuName, "pvmFileMenu",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
#ifdef EXTRA_HELP_BUTTON
		 XtNfromHoriz, w,
#endif
		 NULL);
    mode_mark_widget (w, modes);

    modes = make_menu ("pvmEditMenu", pvm_edit_menu);

    w = XtVaCMW ("menu.edit", menuButtonWidgetClass, parent,
		 XtNlabel, "Edit",
		 XtNmenuName, "pvmEditMenu",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
		 XtNfromHoriz, w,
		 NULL);
    mode_mark_widget (w, modes);

    modes = make_menu ("pvmBuildMenu", pvm_build_menu);
	       
    w = XtVaCMW ("menu.build", menuButtonWidgetClass, parent,
		 XtNlabel, "Build",
		 XtNmenuName, "pvmBuildMenu",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
		 XtNfromHoriz, w,
		 NULL);
    mode_mark_widget (w, modes);

    modes = make_menu ("pvmRunMenu", pvm_run_menu);

    w = XtVaCMW ("menu.run", menuButtonWidgetClass, parent,
		 XtNlabel, "Run",
		 XtNmenuName, "pvmRunMenu",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
		 XtNfromHoriz, w,
		 NULL);
    mode_mark_widget (w, modes);

    modes = make_menu ("pvmPvmMenu", pvm_pvm_menu);

    w = XtVaCMW ("menu.pvm", menuButtonWidgetClass, parent,
		 XtNlabel, "PVM",
		 XtNmenuName, "pvmPvmMenu",
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainLeft,
		 XtNfromVert, pvmTitle,
		 XtNfromHoriz, w,
		 NULL);
    mode_mark_widget (w, modes);

    pvmPanel = XtVaCMW ("panel", panedWidgetClass, parent,
			XtNwidth, width,
			XtNheight, height,
			/* form constraints */
			XtNtop, XtChainTop,
			XtNbottom, XtChainBottom,
			XtNleft, XtChainLeft,
			XtNright, XtChainRight,
			XtNorientation, XtorientVertical,
			XtNfromVert, w,
			NULL);

    w = XtVaCMW ("config", formWidgetClass, pvmPanel,
		 XtNwidth, width,
		 XtNheight, 125,
		 NULL);
    make_config_panel (w, width, 125);

#ifdef USE_ASCII_TEXT_WIDGET
    w = XtVaCMW ("console", asciiTextWidgetClass, pvmPanel,
#ifdef DEMO
		 XtNeditType, XawtextEdit,
#else
		 XtNeditType, XawtextRead,
#endif
		 XtNtype, XawAsciiString,
		 XtNresize, XawtextResizeNever,
		 XtNscrollHorizontal, XawtextScrollWhenNeeded,
		 XtNscrollVertical, XawtextScrollAlways,
		 XtNuseStringInPlace, True,
		 XtNstring, "",
		 /* geometry */
		 XtNwidth, width,
		 XtNheight, 125,
		 /* pane constraints */
		 XtNpreferredPaneSize, 125,
		 NULL);
#else
    w = XtVaCMW ("console", canvasWidgetClass, pvmPanel,
		 /* geometry */
		 XtNwidth, width,
		 XtNheight, 125,
		 /* pane constraints */
		 XtNpreferredPaneSize, 125,
		 NULL);
#endif
    global.pvm_sink = ts_create (w, 40000);

    w =	XtVaCMW ("histogram", formWidgetClass, pvmPanel,
		 XtNwidth, width,
		 XtNheight, 125,
		 XtNborderWidth, 0,
		 XtNpreferredPaneSize, 125,
		 NULL);
    make_histogram (w, width, 125);
}
