/*
 * handle details of changing modes
 *
 * $Id: mode.c,v 1.1 1994/02/17 21:33:01 moore Exp $
 *
 * $Log: mode.c,v $
 * Revision 1.1  1994/02/17  21:33:01  moore
 * Initial revision
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "global.h"
#include "labels.h"
#include "mode.h"
#include "trace_new.h"

#include <Malloc.h>
#include <String.h>

static struct widget_list {
    Widget w;
    char *s;
    struct widget_list *next;
} *head = NULL;

static struct mode_hook {
    int (*hook)();
    int mode;
    struct mode_hook *next;
} *mode_hook_list = NULL;


/*
 * allow luser to specify a function to be called when entering/leaving
 * a mode.
 */

void
set_mode_hook (mode, hook)
int mode;
int (*hook)();
{
    struct mode_hook *ptr;

    ptr = TALLOC (1, struct mode_hook);
    ptr->mode = mode;
    ptr->hook = hook;
    ptr->next = mode_hook_list;
    mode_hook_list = ptr;
}

static void
call_mode_hooks (mode, flag)
int mode;
int flag;
{
    struct mode_hook *ptr;

    for (ptr = mode_hook_list; ptr; ptr = ptr->next)
	(*(ptr->hook))(mode, flag);
}

void
mode_mark_widget (w, s)
Widget w;
char *s;
{
    struct widget_list *ptr = TALLOC (1, struct widget_list);

    if (s == NULL)
	return;
    ptr->w = w;
    ptr->s = STRDUP (s);
    ptr->next = head;
    head = ptr;
}

void
mode_set_widgets (c)
int c;
{
    struct widget_list *ptr;
    char *strchr ();

    for (ptr = head; ptr != NULL; ptr = ptr->next)
	if (strchr (ptr->s, (char) c))
	    XtVaSetValues (ptr->w, XtNsensitive, True, NULL);
	else
	    XtVaSetValues (ptr->w, XtNsensitive, False, NULL);
}

void
set_mode (m)
int m;
{
    int c;
    char *s;

    if (global.mode == m)
	return;

    switch (m) {
    case MODE_COMPOSE:
	c = 'c';
	s = "compose";
	break;
    case MODE_EXECUTE:
	c = 'e';
	s = "execute";
	break;
    case MODE_TRACE:
	c = 't';
	s = "trace";
	break;
    case MODE_BUILD:
	c = 'b';
	s = "build";
	break;
    default:
	return;
    }
    call_mode_hooks (global.mode, 0); /* "leaving" mode hooks */
    mode_set_widgets (c);
    global.mode = m;
    call_mode_hooks (global.mode, 1); /* "entering" mode hooks */
    set_mode_label (s);
}
