/*
 * interface to the Xaw menu widgets for htool 2.x
 * Keith Moore
 *
 * $Id: menu.c,v 1.1 1994/02/17 21:32:48 moore Exp $
 *
 * $Log: menu.c,v $
 * Revision 1.1  1994/02/17  21:32:48  moore
 * Initial revision
 *
 */

#include <stdio.h>
#ifdef HAVE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "global.h"
#include "menu.h"
#include "mode.h"

#include <Malloc.h>

/*
 * make_simple_menu (name, callback_function, entry, entry, ..., NULL)
 */

Widget
#ifdef HAVE_STDARG
make_simple_menu (char *name, int (*callback)(), ...)
#else
make_simple_menu (va_alist)
va_dcl
#endif
{
    va_list arglist;
    char *name;
    char *ptr;
    XtCallbackProc proc;
    Widget w0, w;
    static XtCallbackRec callbacks[2];

#define XtVaCMW XtVaCreateManagedWidget

#ifdef HAVE_STDARG
    va_start(arglist, callback);
#else
    va_start(arglist);
#endif

    name = va_arg (arglist, char *);
    proc = va_arg (arglist, XtCallbackProc);

    w0 = w = XtVaCreatePopupShell (name, simpleMenuWidgetClass,
				   global.topLevel,
				   NULL);

    while ((ptr = va_arg (arglist, char *)) != NULL) {
	callbacks[0].callback = proc;
	callbacks[0].closure = (XtPointer) ptr;
	callbacks[1].callback = NULL;
	w = XtVaCMW (ptr, smeBSBObjectClass, w0,
		     XtNlabel, ptr,
		     XtNcallback, callbacks,
		     NULL);
    }

    va_end(arglist);
    return w0;
}


static void
do_nothing (w, p1, p2)
Widget w;
XtPointer p1, p2;
{
}

/*
 * create a menu, passing it a pre-initialized list of
 * (entry name, function to call, arg) triples
 * return the combined list of modes
 */

char *
make_menu (name, list)
char *name;
struct menu_entry *list;
{
    Widget w0;
    int i;
    unsigned char *ptr;
    static unsigned char combined_modes[256];
    char mode_set[16];
    int do_modes = 1;

    /*
     * initialize the mode set to the empty set
     */
    for (i = 0; i < 16; ++i)
	mode_set[i] = '\0';

    w0 = XtVaCreatePopupShell (name, simpleMenuWidgetClass,
			       global.topLevel,
			       NULL);

    /*
     * for each item in the list, create a simple menu entry widget
     * with appropriate label and callbacks.  also compute the union
     * of all modes used by all widgets.
     */
    for (i = 0; list[i].name != NULL; ++i) {
	XtCallbackRec *callbacks;

	callbacks = (XtCallbackRec *) MALLOC (2 * sizeof (*callbacks));
	if (list[i].proc) {
	    callbacks[0].callback = list[i].proc;
	    callbacks[0].closure = list[i].arg;
	}
	else {
	    callbacks[0].callback = do_nothing;
	    callbacks[0].closure = NULL;
	}
	callbacks[1].callback = NULL;
	list[i].w =  XtVaCreateManagedWidget (list[i].name,
					      smeBSBObjectClass, w0,
					      XtNlabel, list[i].name,
					      XtNcallback, callbacks,
					      NULL);
	if (callbacks[0].callback == do_nothing)
	    XtVaSetValues (list[i].w, XtNsensitive, False, NULL);
	else if (list[i].modes) {
	    mode_mark_widget (list[i].w, list[i].modes);
	    for (ptr = (unsigned char *) list[i].modes; *ptr; ++ptr)
		mode_set[*ptr / 8] |= 1 << (*ptr % 8);
	}
	else {
	    /*
	     * if any item in the menu is not constrained,
	     * the menu itself must be enabled in all modes
	     */
	    do_modes = 0;
	}
    }
    /*
     * compute the character string representation of the resulting
     * set of modes in which this menu should be sensitive.
     */
    if (do_modes) {
	ptr = combined_modes;
	for (i = 1; i < 256; ++i)
	    if (mode_set[i / 8] & (1 << (i % 8)))
		*ptr++ = (unsigned char) i;
	*ptr++ = '\0';
	return (char *) combined_modes;
    }
    else
	return (char *) NULL;
}
