/*
 * htool version 2.x
 * Keith Moore
 *
 * $Id: main.c,v 1.1 1994/02/17 21:32:37 moore Exp $
 *
 * $Log: main.c,v $
 * Revision 1.1  1994/02/17  21:32:37  moore
 * Initial revision
 *
 */

#include <stdio.h>
#include <varargs.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "costmat.h"
#include "dot_htool.h"
#include "global.h"
#include "graph.h"
#include "labels.h"
#include "menu.h"
#include "xtglue.h"

#include <Malloc.h>

struct defaults defaults;
struct globals global;

#define OFFSET(x) XtOffset(struct defaults *, x)

static XrmOptionDescRec options[] = {
    { "-mono", ".monochrome", XrmoptionNoArg, "on" },
    { "+mono", ".monochrome", XrmoptionNoArg, "off" },
};

static XtResource res_list[] = {
    { "monochrome", "Monochrome", XtRBool, sizeof(Bool),
	  OFFSET(monochrome), XtRString, "off" },
    { "titleBackground", XtCBackground, XtRPixel, sizeof(Pixel),
	  OFFSET(titleBackground), XtRString, XtDefaultBackground },
    { "titleForeground", XtCForeground, XtRPixel, sizeof(Pixel),
	  OFFSET(titleForeground), XtRString, XtDefaultForeground },
#if 0
    /*
     * these are now initialized in dot_htool.c
     * and not by X resources
     */
    { "editorCommand", "EditorCommand", XtRString, sizeof(String),
	  OFFSET(editorCommand), XtRString,
	  "xterm -title %s -e vi %s" },
    { "language", "Language", XtRString, sizeof(String),
	  OFFSET(language), XtRString, "C" },
    { "printCommand", "PrintCommand", XtRString, sizeof(String),
	  OFFSET(printCommand), XtRString, "lpr %s" },
    { "pvmHostFile", "PvmHostFile", XtRString, sizeof(String),
	  OFFSET(pvmHostFile), XtRString, NULL },
    { "subDefsFile", "SubDefsFile", XtRString, sizeof(String),
	  OFFSET(subDefsFile), XtRString, NULL },
    { "tmpDir", "TmpDir", XtRString, sizeof(String),
	  OFFSET(tmpDir), XtRString, "/tmp" },
#endif
    /*
     * colors for node states etc.
     * these are used by graph_draw.c
     */
    { "brokenColor", "BrokenColor", XtRPixel, sizeof(Pixel),
	  OFFSET(brokenColor), XtRString, "red" },
    { "deadColor", "DeadColor", XtRPixel, sizeof(Pixel),
	  OFFSET(deadColor), XtRString, "black" }, /* XXX is this used? */
#if 0
    { "disabledColor", "DisabledColor", XtRPixel, sizeof(Pixel),
	  OFFSET(disabledColor), XtRString, "gray" },
#endif
    { "doneColor", "DoneColor", XtRPixel, sizeof(Pixel),
	  OFFSET(doneColor), XtRString, "magenta" },
    { "errorColor", "ErrorColor", XtRPixel, sizeof(Pixel),
	  OFFSET(errorColor), XtRString, "red" },
    { "exitColor", "ExitColor", XtRPixel, sizeof(Pixel),
	  OFFSET(exitColor), XtRString, "maroon" },
    { "idleColor", "IdleColor", XtRPixel, sizeof(Pixel),
	  OFFSET(idleColor), XtRString, "yellow" },
    { "normalColor", "NormalColor", XtRPixel, sizeof(Pixel),
	  OFFSET(normalColor), XtRString, "white" },
    { "notReadyColor", "NotReadyColor", XtRPixel, sizeof(Pixel),
	  OFFSET(notReadyColor), XtRString, "blue" }, /* was grey */
    { "readyColor", "ReadyColor", XtRPixel, sizeof(Pixel),
	  OFFSET(readyColor), XtRString, "yellow" },
    { "runningColor", "RunningColor", XtRPixel, sizeof(Pixel),
	  OFFSET(runningColor), XtRString, "green" },
    { "warningColor", "WarningColor", XtRPixel, sizeof(Pixel),
	  OFFSET(warningColor), XtRString, "orange" },
};

/* Compose Canvas default translations */

#ifdef DEMO
static char canvas_translations[] =
"*graph.canvas.translations:\
!Ctrl<Btn1Down>:del-node()\\n\
!Shift<Btn1Down>:move-node(b)\\n\
<Btn1Down>:add-node()\\n\
<Btn1Motion>:move-node(d)\\n\
<Btn1Up>:move-node(f)\\n\
!<Btn2Down>:add-arc(b)\\n\
!Ctrl<Btn2Down>:del-arc()\\n\
!Shift<Btn2Down>:move-arc(b)\\n\
<Btn2Motion>:add-arc(d)move-arc(d)\\n\
<Btn2Up>:add-arc(f)move-arc(f)\\n\
<Leave>:move-arc(c)add-arc(c)move-node(c)\\n\
!<Btn3Down>:edit-node(p)\\n\
!Ctrl<Btn3Down>:change-color()\\n\
!Shift<Btn3Down>:edit-node(s)\\n\
";
#else
static char canvas_translations[] =
"*graph.canvas.translations:\
!Ctrl<Btn1Down>:del-node()\\n\
!Shift<Btn1Down>:move-node(b)\\n\
<Btn1Down>:add-node()\\n\
<Btn1Motion>:move-node(d)\\n\
<Btn1Up>:move-node(f)\\n\
!<Btn2Down>:add-arc(b)\\n\
!Ctrl<Btn2Down>:del-arc()\\n\
!Shift<Btn2Down>:move-arc(b)\\n\
<Btn2Motion>:add-arc(d)move-arc(d)\\n\
<Btn2Up>:add-arc(f)move-arc(f)\\n\
<Leave>:move-arc(c)add-arc(c)move-node(c)\\n\
!<Btn3Down>:edit-node(p)\\n\
!Shift<Btn3Down>:edit-node(s)\\n\
";
#endif

static char *fallbacks [] = {
    "*titleBackground: cyan",
    "*titleForeground: black",
/*  "*labels.version.foreground: red", */
/*  "*labels.version.font: -*-times-bold-r-*-*-20-*-*-*-*-*-iso8859-1", */
    "*labels.version.font: -*-helvetica-bold-r-*-*-20-*-*-*-*-*-iso8859-1",
/*  "*labels*font: -*-times-bold-r-*-*-14-*-*-*-*-*-iso8859-1", */
    "*labels*font: -*-helvetica-bold-r-*-*-14-*-*-*-*-*-iso8859-1",
    "*Label*Font: -*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-1",
    "*FileSelect*Font: -*-helvetica-bold-r-*-*-14-*-*-*-*-*-iso8859-1",
    "*MenuButton*Font: -*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-1",
    "*Command*Font: -*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-1",
/*  "*SimpleMenu*Font: -*-times-bold-r-*-*-*-100-*-*-*-*-iso8859-1", */
    "*SimpleMenu*Font: -*-helvetica-bold-r-*-*-*-100-*-*-*-*-iso8859-1", 
/*  "*Text*font: -*-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-1", */
    "*Text*font: -*-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-1",
    "*Canvas*font: -*-helvetica-bold-r-*-*-11-*-*-*-*-*-iso8859-1",
    "*help*Canvas*font: -*-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-1",
#if 1
    /*
     * XXX eventually write a real text sink widget and have its
     * own class for fonts (preferably fixed-width)
     */
    "*console.font: fixed",
    "*infoText.font: fixed",
#endif
    "*Matrix*font: -*-helvetica-bold-r-*-*-11-*-*-*-*-*-iso8859-1",
    "*histogram*font: -*-helvetica-bold-r-*-*-11-*-*-*-*-*-iso8859-1",
    "*Form.background: turquoise",
    "*Fileselect.background: NavajoWhite",
    canvas_translations,
    NULL
};

static void quit();

static XtActionsRec actions[] = {
    {"quit",    quit}
};

static Atom     wm_delete_window;

#define XtVaCMW XtVaCreateManagedWidget
#define XtVaCW XtVaCreateWidget
#define XtGCFSW XtGlueCreateFormSubWidget

static int
append_to_info_window (s)
char *s;
{
    ts_append (global.info_sink, s);
}

/*
 * This function gets the result of "pwd" when the current directory
 * is $HOME.  Why not just use getenv("HOME")?  Because automounters
 * play games with symlinks, and we need to be able to compare the
 * output of 'pwd' when in some other directory with that of 'pwd'
 * when at home.
 */

static void
get_home_dir (ptr, size)
char *ptr;
int size;
{
    FILE *fp;
    int c;

    fp = popen ("cd ; pwd", "r");
    while ((c = getc (fp)) != '\n' && c != EOF)
	*ptr++ = c;
    if (size-- > 0)
	*ptr++ = '\0';
    pclose (fp);
}


main (argc, argv)
int argc;
char **argv;
{
    Widget vPane;		/* pane widget separating top and bottom */
    Widget topHalf;		/* form widget for top half of display */
    Widget topLeft;		/* form widget for top left of display */
    Widget labelForm;		/* form widget for labels at top left */
    Widget infoForm;		/* form widget for information window */
    Widget bottomHalf;		/* pane widget between left and right bottom*/
    Widget graphForm;		/* form containing hence graph etc */
    Widget pvmForm;
    Dimension globalHeight;
    Dimension globalWidth;
    int topHeight;
    int bottomHeight;
    int labelWidth;
    int infoWidth;
    int canvasWidth;
    int pvmWidth;
    int i;

#ifdef SUN_DEBUG_MALLOC
    malloc_debug (2);
#endif

    /*
     * initialize toolkit and some global variables
     */

    global.topLevel = XtAppInitialize (&global.context, "htool",
				       options, XtNumber (options),
				       &argc, argv, fallbacks, NULL, 0);

    defaults.debugMaster = 0;
    for (i = 0; i < argc; ++i)
	if (strcmp (argv[i], "-debugMaster") == 0)
	    defaults.debugMaster = 1;

    XtAppAddActions
        (global.context, actions, XtNumber (actions));
    XtOverrideTranslations
        (global.topLevel,
	 XtParseTranslationTable ("<Message>WM_PROTOCOLS: quit()"));

    global.display = XtDisplay (global.topLevel);
    global.screen = DefaultScreen (global.display);
    global.rootWindow = RootWindow (global.display, global.screen);
    global.displayWidth = DisplayWidth (global.display, global.screen);
    global.displayHeight = DisplayHeight (global.display, global.screen);
    global.depth = DefaultDepth (global.display, global.screen);
    global.blackPixel = BlackPixel (global.display, global.screen);
    global.whitePixel = WhitePixel (global.display, global.screen);
    global.inColor = DisplayCells (global.display, global.screen) > 2;
    *global.costFile = '\0';
    *global.graphFile = '\0';
    strcpy (global.traceFile, "hence.trace");
    global.graph = gr_New ();
    global.traceGraph = gr_New ();
    global.costMatrix = cm_New ();
    global.mode = -1;
    global.traceClock.seconds = 0;
    global.traceClock.msec = 0;
    global.traceSequence = 0;

    /*
     * NOTE: it's important to call getcwd() before using the subprocess
     * package.  Any attempt to call getcwd() after running any other
     * subprocess will hang htool.
     */
    getcwd (global.currentDirectory, sizeof (global.currentDirectory) - 2);

    /*
     * get X resource definitions
     */

    XtGetApplicationResources (global.topLevel, &defaults,
			       res_list, XtNumber(res_list),
			       0, 0);

    /*
     * read in ~/.htool
     */
    dot_htool_init ();

    /*
     * XXX do pixel/bitmap setup here
     */

    if (defaults.monochrome == True)  /* force monochrome */
	global.inColor = False;

    if (!global.inColor) {
	defaults.titleBackground = global.whitePixel;
	defaults.titleForeground = global.blackPixel;

	defaults.deadColor = global.blackPixel;
	defaults.doneColor = global.blackPixel;
	defaults.errorColor = global.blackPixel;
	defaults.exitColor = global.blackPixel;
	defaults.notReadyColor = global.blackPixel;
	defaults.readyColor = global.blackPixel;
	defaults.runningColor = global.blackPixel;
	defaults.warningColor = global.blackPixel;
    }

    /*
     * divide space between the sub-windows based on the
     * geometry resource.
     *
     * XXX better to wait until we know what size we are before
     * laying out the sub-windows.
     */

    globalHeight = 700;
    globalWidth = 1000;
    topHeight = (globalHeight > 300) ? 150 : (globalHeight / 2);
    bottomHeight = globalHeight - topHeight - 1;
    labelWidth = (globalWidth > 400) ? 200 : (globalWidth / 2);
    infoWidth = globalWidth - labelWidth - 1;
    canvasWidth = (globalWidth - 1) / 2;
    pvmWidth = globalWidth - canvasWidth - 1;

    vPane =
	XtVaCMW ("vpane", panedWidgetClass, global.topLevel,
		 XtNwidth, globalWidth,
		 XtNheight, globalHeight,
		 XtNorientation, XtorientVertical,
		 NULL);
    topHalf =
	XtVaCMW ("top", panedWidgetClass, vPane,
		 XtNwidth, globalWidth,
		 XtNheight, topHeight,
		 XtNorientation, XtorientHorizontal,
		 XtNpreferredPaneSize, topHeight,
		 NULL);

    labelForm =
	XtVaCMW ("labels", formWidgetClass, topHalf,
		 XtNpreferredPaneSize, labelWidth,
		 XtNwidth, labelWidth,
		 NULL);

    make_label_window (labelForm, labelWidth);


    infoForm =
	XtVaCMW ("info", formWidgetClass, topHalf,
		 XtNwidth, infoWidth,
		 XtNheight, topHeight,
		 NULL);

    make_info_panel (infoForm, topHeight, infoWidth);
    
    bottomHalf =
	XtVaCMW ("bottom", panedWidgetClass, vPane,
		 XtNwidth, globalWidth,
		 XtNheight, bottomHeight,
		 XtNpreferredPaneSize, bottomHeight,
		 XtNorientation, XtorientHorizontal,
		 NULL);

    graphForm =
	XtVaCMW ("graph", formWidgetClass, bottomHalf,
		 XtNwidth, canvasWidth,
		 XtNheight, bottomHeight,
		 XtNpreferredPaneSize, canvasWidth,
		 NULL);


    make_graph_panel (graphForm, bottomHeight, canvasWidth);

    pvmForm =
	XtVaCMW ("pvm", formWidgetClass, bottomHalf,
		 XtNwidth, pvmWidth,
		 XtNpreferredPaneSize, pvmWidth,
		 NULL);

    make_pvm_panel (pvmForm, bottomHeight, pvmWidth);


    XtRealizeWidget (global.topLevel);

    msg_SetWriteFunction (append_to_info_window);
    get_home_dir (global.homeDirectory);
    set_directory_label (global.currentDirectory);
    set_mode (MODE_COMPOSE);
    ts_append (global.info_sink, "Welcome to HeNCE tool version 2.0\n");

    if (defaults.debugMaster)
	ts_append (global.info_sink, "(executioner debugging is ON)\n");
    /*
     * set language
     */
    if (strcasecmp (defaults.language, "c") == 0) {
	global.language = LANG_C;
	msg_Format ("current language is C\n");
    }
    else if (strcasecmp (defaults.language, "fortran") == 0) {
	global.language = LANG_FORTRAN;
	msg_Format ("current language is FORTRAN\n");
    }	
    else {
	msg_Format ("bogus language resource \"%s\" -- assuming C\n",
		    defaults.language);
	global.language = LANG_C;
    }
    set_language_label (global.language);
    set_tracefile_label (global.traceFile);

    wm_delete_window = XInternAtom (global.display, "WM_DELETE_WINDOW",
				    False);
    (void) XSetWMProtocols (global.display, XtWindow(global.topLevel),
                            &wm_delete_window, 1);
    XtAppMainLoop (global.context);
}


/*
 * XXX need to do cleanup of proxyd's, remote procs, hence executioner etc.
 * XXX need to offer to save graphs, cost matrices
 */

static void
quit(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    if (event->type == ClientMessage &&
        event->xclient.data.l[0] != wm_delete_window) {
        XBell(XtDisplay(w), 0);
    }
    else {
        XCloseDisplay(XtDisplay(w));
        exit(0);
    }
}
