/*
 * routines to manage the label panel
 *
 * $Id: labels.c,v 1.1 1994/02/17 21:32:17 moore Exp $
 *
 * $Log: labels.c,v $
 * Revision 1.1  1994/02/17  21:32:17  moore
 * Initial revision
 *
 */

#include <stdio.h>

/*
 * from bondo...
 */

#include <Errno.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>

#include "FileSelect.h"

#include "filenames.h"
#include "global.h"
#include "labels.h"
#include "menu.h"
#include "mode.h"
#include "subproc.h"
#include "xtglue.h"

#include <Malloc.h>

#define XtVaCMW XtVaCreateManagedWidget
#define XtVaCW XtVaCreateWidget
#define XtGCFSW XtGlueCreateFormSubWidget

static Widget versionLabel, modeLabel, dirLabel, graphLabel, costLabel,
    traceLabel, languageLabel;

void
set_directory_label (filename)
char *filename;
{
    char buf[1024];
    sprintf (buf, "directory: %s", basename (filename));
    XtVaSetValues (dirLabel, XtNlabel, buf, NULL);
}

void
set_graphfile_label (filename, modified)
char *filename;
int modified;
{
    char buf[1024];
    char *suffix = modified ? " *" : "";

    sprintf (buf, "graph: %s%s", basename (filename), suffix);
    XtVaSetValues (graphLabel, XtNlabel, buf, NULL);
}

void
set_costfile_label (filename, modified)
char *filename;
{
    char buf[1024];
    char *suffix = modified ? " *" : "";

    sprintf (buf, "cost matrix: %s%s", basename (filename), suffix);
    XtVaSetValues (costLabel, XtNlabel, buf, NULL);
}

void
set_tracefile_label (filename)
char *filename;
{
    char buf[1024];
    sprintf (buf, "trace file: %s", basename (filename));
    XtVaSetValues (traceLabel, XtNlabel, buf, NULL);
}

void
set_language_label (language)
{
    char buf[1024];
    sprintf (buf, "language: %s", language == LANG_C ? "c" : "FORTRAN");
    XtVaSetValues (languageLabel, XtNlabel, buf, NULL);
}

void
set_mode_label (string)
char *string;
{
    char buf[1000];

    sprintf (buf, "mode: %s", string);
    XtVaSetValues (modeLabel, XtNlabel, buf, NULL);
}

/*
 * stuff to deal with "change directory" function.  We can't use
 * getcwd() because the implementation of getcwd() usually calls
 * popen("/bin/pwd") to do its dirty work, and popen() does a wait()
 * to see when its child finishes.  Subproc.c sets up a SIGCHLD
 * handler that wakes up whenever a child exits.  The SIGCHLD
 * handler calls wait3(), which eats up the termination status
 * from the /bin/pwd process, so popen() never returns.
 *
 * So in effect, we have our own getcwd() here, using the subproc
 * package.
 */

struct get_cwd_args {
    char *buf;
    char *ptr;
    int size;
    FILE *fp;
};

/*
 * this function saves up the output of /bin/pwd
 */

static void
directory_sink (fd, ptr)
int fd;
struct get_cwd_args *ptr;
{
    int c;

    if (ptr->fp == NULL) {
	if ((ptr->fp = fdopen (fd, "r")) == NULL)
	    return;
    }
    while ((c = getc (ptr->fp)) != '\n' && c != EOF) {
	if (ptr->size > 0) {
	    *ptr->ptr++ = c;
	    ptr->size--;
	}
    }
    *ptr->ptr = '\0';
}

/*
 * this function is called when /bin/pwd exits.  Grab the saved directory
 * string and stuff it in a global location.  Also set the directory label.
 * Convert to tilde-notation before displaying.
 * 
 * XXX It would be nice to deal with the wierd results you get from
 * running pwd when automounters are being used.
 */

static void
got_directory (pid, exitArg, ptr, howDied)
int pid;
int exitArg;
struct get_cwd_args *ptr;
enum causeOfDeath howDied;
{
    if (ptr->fp)
	fclose (ptr->fp);
    strcpy (global.currentDirectory, ptr->buf);
    setenv ("PWD", global.currentDirectory, 1);
    msg_Format ("current directory is now \"%s\"\n",
		make_pretty (global.currentDirectory));
    set_directory_label (global.currentDirectory);
}

/*
 * this function is called when we select the "Change directory" menu
 * option.
 */

static void
change_directory (w, p1, p2)
Widget w;
XtPointer p1, p2;
{
    int pwdPid;
    static struct get_cwd_args get_cwd_args;
    char dirname[1024];
    static char dir_buf[1024];

    get_cwd_args.buf = dir_buf;
    get_cwd_args.ptr = dir_buf;
    get_cwd_args.size = sizeof (dir_buf);
    dir_buf[0] = '\0';
    get_cwd_args.fp = NULL;

    strcpy (dirname, make_pretty (global.currentDirectory));

    if (fileVerify ("Change directory to ...",
		    dirname, sizeof (dirname), "*",
		    FS_Directory|FS_MustExist|FS_MustBeReadable) == 0) {
	if (chdir (dirname) < 0) {
	    msg_Format ("chdir(%s) failed: %s\n", dirname, strerror (errno));
	    return;
	}
	else {
	    pwdPid = subproc_Popen ("/bin/pwd",
				    got_directory,
				    got_directory,
				    directory_sink,
				    &get_cwd_args);
	    if (pwdPid <= 0) {
		msg_Format ("system error: /bin/pwd failed: %s\n",
			    strerror (errno));
		set_directory_label (dirname);
		strcpy (global.currentDirectory, dirname);
		return;
	    }
	}
    }
}

static void
about_htool (w, p1, p2)
Widget w;
XtPointer p1, p2;
{
    /* XXX should pop up a pretty picture */
}

static void
quit (w, p1, p2)
Widget w;
XtPointer p1, p2;
{
    /* XXX should check modified files, etc. */
    /* XXX also one in main.c -- combine into a single function */
    exit (0);
}

#if 0
static void
change_mode (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    char *s = (char *) client_data;

    if (*s == 'c')
	set_mode (MODE_COMPOSE);
    else if (*s == 'e') {
	set_mode (MODE_EXECUTE);
    }
    else if (*s == 't') {
	set_mode (MODE_TRACE);
    }
}
#endif

static void
change_language (w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    switch (global.language) {
    case LANG_C:
	global.language = LANG_FORTRAN;
	break;
    case LANG_FORTRAN:
    default:
	global.language = LANG_C;
	break;
    }
    set_language_label (global.language);
}

struct menu_entry main_menu[] = {
#if 0
    { NULL,     "About htool",      about_htool },
#endif
    { "c",	"Change directory", change_directory },
    { "c",	"Change language",  change_language, "" },
    { "cte", 	"Quit",             quit },
    { NULL, NULL },
};

void
make_label_window (parent, width)
Widget parent;
int width;
{
    Widget w;
    int borderWidth = 1;
    Pixel background;

    make_menu ("HeNCE", main_menu);

    XtVaGetValues (parent,
		   XtNbackground, &background,
		   NULL);

    w = XtGCFSW ("version", menuButtonWidgetClass, parent, Center,
		 XtNmenuName, "HeNCE",
		 XtNlabel, "HeNCE tool v2.0",
		 XtNjustify, XtJustifyCenter,
		 XtNborderWidth, borderWidth,
		 XtNresizable, False,
		 XtNwidth, width - 2 * borderWidth,
		 NULL);
    versionLabel = w;

    w =	XtGCFSW ("mode", labelWidgetClass, parent, South,
		 XtNlabel, "mode:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    modeLabel = w;

    w =	XtGCFSW ("directory", labelWidgetClass, parent, South,
		 XtNlabel, "dir:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    dirLabel = w;

    w = XtGCFSW ("graphFile", labelWidgetClass, parent, South,
		 XtNlabel, "graph:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    graphLabel = w;

    w =	XtGCFSW ("costFile", labelWidgetClass, parent, South,
		 XtNlabel, "cost:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    costLabel = w;

    w =	XtGCFSW ("traceFile", labelWidgetClass, parent, South,
		 XtNlabel, "trace:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    traceLabel = w;

    w =	XtGCFSW ("language", labelWidgetClass, parent, South,
		 XtNlabel, "language:",
		 XtNbackground, background,
		 XtNjustify, XtJustifyLeft,
		 XtNborderWidth, 0,
		 XtNresizable, False,
		 XtNwidth, width,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
    languageLabel = w;
}
