/*
 * routines to manipulate the information window
 * htool version 2.x
 * Keith Moore
 *
 * $Id: info_panel.c,v 1.1 1994/02/17 21:32:04 moore Exp $
 *
 * $Log: info_panel.c,v $
 * Revision 1.1  1994/02/17  21:32:04  moore
 * Initial revision
 *
 */

#include <stdio.h>
#include <varargs.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "global.h"
#include "menu.h"
#include "text_sink.h"

#ifdef USE_ASCII_TEXT_WIDGET
#include <X11/Xaw/AsciiText.h>
#else
#include "Canvas.h"
#endif

#include <Malloc.h>

#define XtVaCMW XtVaCreateManagedWidget

void
make_info_panel (parent, height, width)
Widget parent;
int height, width;
{
    Widget w;
    
    w = XtVaCMW ("infoTitle", labelWidgetClass, parent,
		 XtNlabel, "Information",
		 XtNwidth, width,
		 XtNresizable, False,
		 XtNforeground, defaults.titleForeground,
		 XtNbackground, defaults.titleBackground,
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainTop,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainRight,
		 NULL);

#ifdef USE_ASCII_TEXT_WIDGET
    w = XtVaCMW ("infoText", asciiTextWidgetClass, parent,
		 XtNeditType, XawtextRead,
		 XtNresize, XawtextResizeNever,
		 XtNscrollHorizontal, XawtextScrollWhenNeeded,
		 XtNscrollVertical, XawtextScrollAlways,
		 XtNuseStringInPlace, True,
		 XtNstring, "",
		 /* geometry */
		 XtNwidth, width,
		 XtNheight, height,
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainBottom,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainRight,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
#else
    w = XtVaCMW ("infoText", canvasWidgetClass, parent,
		 /* geometry */
		 XtNwidth, width,
		 XtNheight, height,
		 /* form constraints */
		 XtNtop, XtChainTop,
		 XtNbottom, XtChainBottom,
		 XtNleft, XtChainLeft,
		 XtNright, XtChainRight,
		 XtNfromVert, w,
		 XtNvertDistance, 0,
		 NULL);
#endif

    global.info_sink = ts_create (w, 40000);
}
