/*
 * routines to manipulate filenames
 *
 * $Id: filenames.c,v 1.1 1994/02/17 20:21:20 moore Exp $
 *
 * $Log: filenames.c,v $
 * Revision 1.1  1994/02/17  20:21:20  moore
 * Initial revision
 *
 */

#include <X11/Intrinsic.h>

#include "global.h"
#include "filenames.h"

/*
 * Bondo...
 */
#include <Malloc.h>
#include <String.h>

/*
 * return the last component of a path name
 */

char *
basename (filename)
char *filename;
{
    char *ptr, *strrchr();
    ptr = strrchr (filename, '/');
    if (ptr)
	return ptr + 1;
    return filename;
}

/*
 * given a filename, if it starts with luser's home directory,
 * return a version that has the home dir replaced with "~".
 *
 * NOTE: return value points to static data.
 */

char *
make_pretty (filename)
char *filename;
{
    char *getenv();
    static char pretty_name[1024];
    char *home = getenv ("HOME");
    int length;

    length = strlen (global.homeDirectory);
    if (strncmp (global.homeDirectory, filename, length) == 0) {
	if (filename[length] == '\0')
	    goto exact_match;
	else
	    goto do_tilde_prefix;
    }
    else if (home) {
	length = strlen (home);
	if (strncmp (home, filename, length) == 0) {
	    if (filename[length] == '\0')
		goto exact_match;
	    else
		goto do_tilde_prefix;
	}
    }

    strcpy (pretty_name, filename);
    return pretty_name;

 do_tilde_prefix:
    sprintf (pretty_name, "~/%s", filename + length + 1);
    return pretty_name;

 exact_match:
    return "~";
}
