/*
 * htool version 2.x
 * Keith Moore
 *
 * $Id: dot_htool.c,v 1.3 1994/06/11 20:39:42 moore Exp $
 *
 * $Log: dot_htool.c,v $
 * Revision 1.3  1994/06/11  20:39:42  moore
 * fix typo in {PMAX,RS6K}_BUILD_FLAGS
 *
 * Revision 1.2  1994/02/24  01:08:41  moore
 * (process_line): htool was core dumping because process_line was
 * writing NULs into the char* 'buf' passed by the caller -- which
 * was a read-only string if compiled under ANSI C.  Fix process_line
 * to copy the string to writable storage instead of using it in place.
 *
 * Revision 1.1  1994/02/17  20:19:50  moore
 * Initial revision
 *
 */

#include <stdio.h>

#include <X11/Intrinsic.h>

#include <Malloc.h>
#include <String.h>

#include "dot_htool.h"
#include "global.h"
#include "rb.h"

rbTree t = NULL;

static char *dotfile_defaults[] = {
    "EDITOR_COMMAND: xterm -title %s -e vi %s",
    "LANGUAGE: C",
    "PRINT_COMMAND: lpr %s",
    "TMP_DIR: /tmp",
    /*
     * Hewlett-Packard Precision Architecture (HPPA) running HP/UX.
     * Use fort77 instead of f77 to get proper linkage with C.
     */
    "HPPA_BUILD_FLAGS: l",
    "HPPA_CC: cc -o %o %{-g}%[-O] %D %I %s %w %L -lm",
    "HPPA_FC: cc %{-g}%[-O] %D %I -c %w && fort77 -o %o %{-g}%[-O] fmain.f %W %s %L -lm",
    /*
     * SUN4 under SunOS 4.x (NOT Solaris)
     * -Bstatic helps get around some library brain damage
     */
    "SUN4_BUILD_FLAGS: _l",
    "SUN4_CC: cc -o %o -Bstatic %{-g}%[-O] %D %I %s %w %L -ldl -lm",
    "SUN4_FC: cc %{-g}%[-O] %D %I -c %w && f77 -o %o -Bstatic %{-g}%[-O] fmain.f %W %s %L -ldl -lm",
    /*
     * DecStation under Ultrix
     */
    "PMAX_BUILD_FLAGS: _l",
    /*
     * IBM RS/6000 under AIX
     */
    "RS6K_BUILD_FLAGS: l",
};

#define SIZE(x) (sizeof(x)/sizeof(*x))

static void
trim (s)
char *s;
{
    char *p = s;

    while (*p)
	++p;
    while (--p >= s && (*p == ' ' || *p == '\t' || *p == '\n'))
	*p = '\0';
}

static void
process_line (filename, line_number, buf)
char *filename;
int line_number;
char *buf;
{
    char name[255];
    char *value;
    char *dst;
    rbNode n;
    int fnd = 0;

    if (*buf == '#')
	return;
    /* copy name to scratch buffer */
    dst = name;
    while (*buf == ' ' || *buf == '\t') /* skip leading space */
	++buf;
    while (*buf != '\0' && *buf != ':' && *buf != '\n') {
	if (dst >= name + sizeof (name) - 1) {
	    fprintf (stderr, "%s, line %d: name too long\n", filename,
		     line_number);
	    return;
	}
	*dst++ = *buf++;
    }
    *dst++ = '\0';
    if (*buf != ':') {
	fprintf (stderr, "%s, line %d: missing ':'\n", filename, line_number);
	return;
    }
    ++buf;			/* skip over ':' */
    /* skip over white space following ':' */
    while (*buf == ' ' || *buf == '\t')
	++buf;
    if (*buf == '\n' || *buf == '\0') {
	fprintf (stderr, "%s, line %d: missing value\n", filename,
		 line_number);
	return;
    }
    trim (name);
    value = STRDUP (buf);
    trim (value);
    n = rb_Find (t, (void *) name, &fnd);
    if (fnd) {
	FREE (rb_Value (n));
	rb_SetValue (n, (void *) value);
    }
    else {
	rb_InsertBefore (n, (void *) STRDUP (name), (void *) value);
    }
}


char *
dot_htool_get_value (str)
char *str;
{
    int fnd = 0;
    rbNode n;

    if (t == NULL)
	return NULL;

    n = rb_Find (t, str, &fnd);
    return fnd ? rb_Value (n) : NULL;
}

/*
 * read in the ~/.htool file and initialize some other default values.
 */

void
dot_htool_init ()
{
    char filename[1024];
    char buf[1024];
    FILE *fp;
    int line_number = 0;
    int strcasecmp ();
    int i;

    t = rb_Create (strcasecmp);
    for (i = 0; i < SIZE(dotfile_defaults); ++i)
	process_line ("(internal defaults)", i, dotfile_defaults[i]);

    sprintf (filename, "%s/.htool", getenv ("HOME"));
    if ((fp = fopen (filename, "r")) != NULL) {
	while (fgets (buf, sizeof (buf), fp) != NULL)
	    process_line (filename, ++line_number, buf);
	fclose (fp);
    }

    defaults.editorCommand = dot_htool_get_value ("EDITOR_COMMAND");
    defaults.language = dot_htool_get_value ("LANGUAGE");
    defaults.printCommand = dot_htool_get_value ("PRINT_COMMAND");
    defaults.pvmHostFile = dot_htool_get_value ("PVM_HOST_FILE");
    defaults.subDefsFile = dot_htool_get_value ("SUB_DEFS_FILE");
    defaults.tmpDir = dot_htool_get_value ("TMP_DIR");
}
