#ifndef _XawFileselectP_h
#define _XawFileselectP_h

#include "FileSelect.h"
#include <X11/Xaw/SimpleP.h>

typedef struct {int foo;} FileselectClassPart;

typedef struct _FileselectClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    FileselectClassPart	fileselect_class;
} FileselectClassRec;

extern FileselectClassRec fileselectClassRec;

typedef struct {
    /* resources */
    Pixel foreground;
    XFontStruct	*font;
    char *fileselect;
    char dir[255];
    XtJustify justify;
    Pixmap pixmap;
    Boolean resize;
    Position pad;

    XtCallbackList callbacks;
    int searchFlags;
    Boolean showDirs;
    Boolean showRegular;
    String label1;
    String label2;
    String filter;
    String selection;
    String directory;
    Widget nameLabel1;
    Widget nameLabel2;
    Widget filterLabel;
    Widget filterText;
    Widget dirLabel;
    Widget dirText;
    Widget selectText;
#ifdef SELECTLABEL
    Widget selectLabel;
#endif
    Widget currSelectText;
    Widget okButton;
    Widget cancelButton;

    /* private state */
    int text_height;
    GC normal_GC;
    GC gray_GC;
    Pixmap stipple;
    Position fileselect_x;
    Position fileselect_y;
    Dimension fileselect_width;
    Dimension fileselect_height;
    Dimension fileselect_len;
} FileselectPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _FileselectRec {
    CorePart core;
    CompositePart composite;
    FileselectPart fileselect;
} FileselectRec;

#endif /* _XawFileselectP_h */
