/*
 * Canvas.c - Canvas widget
 *
 * Based on the window widget by Chris Peterson, which was
 * based upon the label widget by Charles Haynes.
 *
 * $Id: Canvas.c,v 1.1 1994/02/17 20:15:21 moore Exp $
 *
 * $Log: Canvas.c,v $
 * Revision 1.1  1994/02/17  20:15:21  moore
 * Initial revision
 *
 */

/* 
 * This is the window widget, its purpose is to allow windows to be
 * used with the toolkit.  It has a foreground color, as core does not
 * and it is best if this resource is owned by the widget.
 * It will also add a pixmap to the background of your window.
 *
 *                                Chris Peterson - 2/9/88
 *
 * I added a font to make it more usable with htool.
 *
 *                                Keith Moore - 10/22/92
 *
 *
 */

/*
 * X includes
 */

#include <X11/IntrinsicP.h>
#include "Canvas.h"
#include "CanvasP.h"
#include <X11/StringDefs.h>

/*
 * Bondo
 */
#include <Malloc.h>

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static XtResource resources[] = {
    { XtNpixmap, XtCpixmap, XtRString, sizeof(caddr_t),
	  XtOffset(CanvasWidget, canvas.pixmap), XtRString, (caddr_t) NULL },
    { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	  XtOffset(CanvasWidget, canvas.foreground), XtRString, "Black"},
    { XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
	 XtOffset(CanvasWidget, canvas.fontinfo), XtRString, XtDefaultFont },
};

static void Realize();

CanvasClassRec canvasClassRec = {
  {
/* core_class fields */	
    /* superclass         */    (WidgetClass) &widgetClassRec,
    /* class_name         */    "Canvas",
    /* widget_size        */    sizeof(CanvasRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */    NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    NULL,
    /* initialize_hook    */    NULL,
    /* realize            */    Realize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    NULL,
    /* expose             */    NULL,
    /* set_values         */    NULL,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */    NULL,
#ifdef XtCAccelerators
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension		  */	NULL
#endif /* XtCAccelerators */
  }
};

WidgetClass canvasWidgetClass = (WidgetClass)&canvasClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void Realize(w, valueMask, attributes)
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
    CanvasWidget lw = (CanvasWidget)w;
    if (lw->canvas.pixmap != (Pixmap) 0) {
	*valueMask |= CWBackPixmap;
	*valueMask &= ~CWBackPixel;
	attributes->background_pixmap = lw->canvas.pixmap;
    }

    XtCreateWindow(w, (Cardinal) InputOutput, (Visual *)CopyFromParent,
		   *valueMask, attributes);
} /* Realize */
