/***********************************************************************
 *                                                                     *
 *                                 wait                                *
 *                                                                     *
 ***********************************************************************/

/*
 * Kludge for IBM brain-damage.
 */

#if (defined (IMA_RIOS) || defined(IMA_U370)) && defined(_BSD)
#undef _BSD
#endif

#include <sys/wait.h>

/*
 * Some machines use a union for wait, some use an int.
 * Some take either one, and carefully arrange things so that the bits
 * line up.
 *
 * Older machines don't have the WTERMSIG and WEXITSTATUS macros.
 */

#if defined(IMA_SYMM) || defined(IMA_PMAX) || defined(IMA_UVAX) || \
    defined(IMA_RT) || defined(IMA_NEXT)
typedef union wait waitbuf;
#else
typedef int waitbuf;
#endif

/*
 * magic stuff for machines that don't define WTERMSIG or WEXITSTATUS
 * in <sys/wait.h>.  So far, only the Sequent has needed these, but
 * others might.
 */

#ifndef WTERMSIG
#ifdef w_termsig				/* has union wait */
#define WTERMSIG(status) (((union wait *) &(status))->w_termsig)
#else							/* V7 style */
#define WTERMSIG(status) ((status) & 0x7f)
#endif
#endif

#ifndef WEXITSTATUS
#ifdef w_retcode				/* has union wait */
#define WEXITSTATUS(status) (((union wait *) &(status))->w_retcode)
#else							/* V7 style */
#define WEXITSTATUS(status) (((status) >> 8) & 0xff)
#endif
#endif
